/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AccessTemplateDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AccessTemplateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceBaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessTemCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleAccessTemRemoveReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleTemplateCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleTemplateModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleTemplateQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.AccessTemplateRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ResourceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleTemplateRespDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IResourceService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleTemplateService;
import com.dtyunxi.yundt.cube.center.user.dao.das.AccessTemplateDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleAccessTemplateRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleTemplateAccessRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleTemplateDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AccessTemplateEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleAccessTemplateRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleTemplateAccessRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleTemplateEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdRoleAccessTemplateRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdRoleTemplateAccessRelationEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class RoleTemplateServiceImpl
implements IRoleTemplateService {
    @Resource
    private RoleTemplateDas roleTemplateDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private RoleTemplateAccessRelationDas roleTemplateAccessRelationDas;
    @Resource
    private AccessTemplateDas accessTemplateDas;
    @Resource
    private RoleAccessTemplateRelationDas roleAccessTemplateRelationDas;
    @Resource
    private IResourceService resourceService;
    private static final String roleTemplateCacheKeyPre = "roleTemplateService_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addRoleTemplate(RoleTemplateCreateReqDto roleTemplateCreateReqDto) {
        Assert.notNull((Object)roleTemplateCreateReqDto.getApplicationId(), (String)"\u5e94\u7528\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        String cacheKey = roleTemplateCacheKeyPre + roleTemplateCreateReqDto.getCode();
        Boolean isSuccess = this.cacheService.setCache(cacheKey, (Object)"1", 30);
        if (isSuccess.booleanValue()) {
            try {
                RoleTemplateEo roleTemplateEo = new RoleTemplateEo();
                roleTemplateEo.setCode(roleTemplateCreateReqDto.getCode());
                roleTemplateEo.setApplicationId(roleTemplateCreateReqDto.getApplicationId());
                if (this.roleTemplateDas.count((BaseEo)roleTemplateEo) > 0) {
                    throw new BizException(UserExceptionCode.ROLE_TEMPLATE_EXIT_FAIL.getCode(), UserExceptionCode.ROLE_TEMPLATE_EXIT_FAIL.getMsg() + ":code \u9700\u552f\u4e00");
                }
                roleTemplateEo.setName(roleTemplateCreateReqDto.getName());
                roleTemplateEo.setApplicationId(roleTemplateCreateReqDto.getApplicationId());
                roleTemplateEo.setCode(null);
                if (this.roleTemplateDas.count((BaseEo)roleTemplateEo) > 0) {
                    throw new BizException(UserExceptionCode.ROLE_TEMPLATE_EXIT_FAIL.getCode(), UserExceptionCode.ROLE_TEMPLATE_EXIT_FAIL.getMsg() + ":name \u9700\u552f\u4e00");
                }
                DtoHelper.dto2Eo((BaseVo)roleTemplateCreateReqDto, (BaseEo)roleTemplateEo);
                this.roleTemplateDas.insert((BaseEo)roleTemplateEo);
                Long l = roleTemplateEo.getId();
                return l;
            }
            finally {
                this.cacheService.delCache(cacheKey);
            }
        }
        throw new BizException(UserExceptionCode.CACHE_EXIST_FAIL.getCode(), UserExceptionCode.CACHE_EXIST_FAIL.getMsg());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyRoleTemplate(String code, RoleTemplateModifyReqDto roleTemplateModifyReqDto) {
        RoleTemplateEo roleTemplateEo = new RoleTemplateEo();
        roleTemplateEo.setCode(code);
        List roleTemplateEoList = this.roleTemplateDas.select((BaseEo)roleTemplateEo);
        if (CollectionUtils.isEmpty((Collection)roleTemplateEoList)) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg());
        }
        String cacheKey = null;
        if (StringUtils.isNotBlank((CharSequence)roleTemplateModifyReqDto.getName())) {
            cacheKey = roleTemplateCacheKeyPre + code + roleTemplateModifyReqDto.getName();
            Boolean isSuccess = this.cacheService.setCache(cacheKey, (Object)"1", 30);
            if (isSuccess.booleanValue()) {
                RoleTemplateEo queryEo = new RoleTemplateEo();
                queryEo.setName(roleTemplateModifyReqDto.getName());
                queryEo.setApplicationId(roleTemplateModifyReqDto.getApplicationId());
                List roleTemplateEos = this.roleTemplateDas.select((BaseEo)queryEo);
                if (CollectionUtils.isNotEmpty((Collection)roleTemplateEos) && roleTemplateEos.size() == 1 && !((RoleTemplateEo)roleTemplateEos.get(0)).getCode().equals(code)) {
                    throw new BizException(UserExceptionCode.ROLE_TEMPLATE_EXIT_FAIL.getCode(), UserExceptionCode.ROLE_TEMPLATE_EXIT_FAIL.getMsg() + ":name \u9700\u552f\u4e00");
                }
            } else {
                throw new BizException(UserExceptionCode.CACHE_EXIST_FAIL.getCode(), UserExceptionCode.CACHE_EXIST_FAIL.getMsg());
            }
        }
        roleTemplateEo.setCode(null);
        DtoHelper.dto2Eo((BaseVo)roleTemplateModifyReqDto, (BaseEo)roleTemplateEo, (String[])new String[]{"tenantId", "instanceId"});
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"code", (Object)code));
        roleTemplateEo.setSqlFilters(sqlFilters);
        this.roleTemplateDas.updateSelectiveSqlFilter((BaseEo)roleTemplateEo);
        if (StringUtils.isNotBlank((CharSequence)cacheKey)) {
            this.cacheService.delCache(cacheKey);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRoleTemplate(List<String> codes) {
        for (String code : codes) {
            RoleTemplateEo roleTemplateEo = new RoleTemplateEo();
            roleTemplateEo.setCode(code);
            if (this.roleTemplateDas.count((BaseEo)roleTemplateEo) > 1) {
                throw new BizException(UserExceptionCode.TOO_MATCH_REF.getCode(), UserExceptionCode.TOO_MATCH_REF.getMsg());
            }
            this.roleTemplateDas.logicDelete((BaseEo)roleTemplateEo);
        }
    }

    @Override
    public RoleTemplateRespDto queryByCode(String code) {
        RoleTemplateEo roleTemplateEo = new RoleTemplateEo();
        roleTemplateEo.setCode(code);
        List roleTemplateEos = this.roleTemplateDas.select((BaseEo)roleTemplateEo);
        RoleTemplateRespDto roleTemplateRespDto = new RoleTemplateRespDto();
        if (!CollectionUtils.isNotEmpty((Collection)roleTemplateEos) || roleTemplateEos.size() != 1) {
            throw new BizException(UserExceptionCode.TOO_MATCH_REF.getCode(), UserExceptionCode.TOO_MATCH_REF.getMsg());
        }
        DtoHelper.eo2Dto((BaseEo)((BaseEo)roleTemplateEos.get(0)), (BaseVo)roleTemplateRespDto);
        roleTemplateRespDto.setAccessTemplateRespDtos(this.getAccessDtos(roleTemplateRespDto.getCode()));
        return roleTemplateRespDto;
    }

    @Override
    public PageInfo<RoleTemplateRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        RoleTemplateQueryReqDto roleTemplateQueryReqDto = null;
        Boolean withResources = false;
        RoleTemplateEo roleTemplateEo = new RoleTemplateEo();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            roleTemplateQueryReqDto = (RoleTemplateQueryReqDto)JSON.parseObject((String)filter, RoleTemplateQueryReqDto.class);
            DtoHelper.dto2Eo((BaseVo)roleTemplateQueryReqDto, (BaseEo)roleTemplateEo);
            if (roleTemplateQueryReqDto != null && roleTemplateQueryReqDto.getWithResources() != null) {
                withResources = roleTemplateQueryReqDto.getWithResources();
            }
        }
        PageInfo eoPageInfo = this.roleTemplateDas.selectPage((BaseEo)roleTemplateEo, pageNum, pageSize);
        List roleTemplateEoList = eoPageInfo.getList();
        ArrayList<RoleTemplateRespDto> roleTemplateRespDtos = new ArrayList<RoleTemplateRespDto>();
        for (RoleTemplateEo r : roleTemplateEoList) {
            RoleTemplateRespDto roleTemplateRespDto = new RoleTemplateRespDto();
            DtoHelper.eo2Dto((BaseEo)r, (BaseVo)roleTemplateRespDto);
            if (withResources.booleanValue()) {
                roleTemplateRespDto.setAccessTemplateRespDtos(this.getAccessDtos(r.getCode()));
            }
            roleTemplateRespDtos.add(roleTemplateRespDto);
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(roleTemplateRespDtos);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void giveRoleTemplateResource(List<RoleAccessTemCreateReqDto> roleAccessTemCreateReqDtos) {
        Set codes = roleAccessTemCreateReqDtos.stream().map(RoleAccessTemCreateReqDto::getRoleTemplateCode).collect(Collectors.toSet());
        if (codes.size() <= 0) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg());
        }
        List roleTemplateEos = this.roleTemplateDas.selectByCodeList(codes);
        if (roleTemplateEos.size() != codes.size()) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg());
        }
        this.checkAccessTemCodeExist(roleAccessTemCreateReqDtos);
        for (RoleAccessTemCreateReqDto roleAccessTemCreateReqDto : roleAccessTemCreateReqDtos) {
            String roleTemplateCode = roleAccessTemCreateReqDto.getRoleTemplateCode();
            this.removeRoleAccessTemlate(roleTemplateCode);
            ArrayList<RoleAccessTemplateRelationEo> roleAccessTemplateRelationEoList = new ArrayList<RoleAccessTemplateRelationEo>();
            ArrayList<AccessTemplateEo> accessTemplateEoList = new ArrayList<AccessTemplateEo>();
            for (AccessTemplateReqDto dto : roleAccessTemCreateReqDto.getAccessTemplateReqDtos()) {
                AccessTemplateEo accessTemInsertEo = new AccessTemplateEo();
                DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)accessTemInsertEo);
                if (StringUtils.isBlank((CharSequence)dto.getExtension())) {
                    accessTemInsertEo.setExtension("");
                }
                accessTemplateEoList.add(accessTemInsertEo);
                RoleAccessTemplateRelationEo roleAccessTemRelationInsertEo = new RoleAccessTemplateRelationEo();
                roleAccessTemRelationInsertEo.setRoleTemplateCode(roleTemplateCode);
                roleAccessTemRelationInsertEo.setAccessTemplateCode(accessTemInsertEo.getCode());
                roleAccessTemRelationInsertEo.setExtension("");
                roleAccessTemplateRelationEoList.add(roleAccessTemRelationInsertEo);
            }
            this.roleAccessTemplateRelationDas.insertBatch(roleAccessTemplateRelationEoList);
            this.accessTemplateDas.insertBatch(accessTemplateEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRoleTemplateResource(List<RoleAccessTemRemoveReqDto> roleAccessTemRemoveReqDtos) {
        Set codes = roleAccessTemRemoveReqDtos.stream().map(RoleAccessTemRemoveReqDto::getRoleTemplateCode).collect(Collectors.toSet());
        List roleTemplateEos = this.roleTemplateDas.selectByCodeList(codes);
        if (roleTemplateEos.size() != codes.size()) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), UserExceptionCode.NON_EXIST_FAIL.getMsg());
        }
        for (RoleAccessTemRemoveReqDto roleAccessTemRemoveReqDto : roleAccessTemRemoveReqDtos) {
            if (CollectionUtils.isEmpty((Collection)roleAccessTemRemoveReqDto.getAccessTemplateDtos())) {
                this.removeRoleAccessTemlate(roleAccessTemRemoveReqDto.getRoleTemplateCode());
                continue;
            }
            List accessTemplateDtos = roleAccessTemRemoveReqDto.getAccessTemplateDtos();
            for (AccessTemplateDto accessTemplateDto : accessTemplateDtos) {
                AccessTemplateEo accessTemplateEo = new AccessTemplateEo();
                accessTemplateEo.setCode(accessTemplateDto.getCode());
                this.accessTemplateDas.logicDelete((BaseEo)accessTemplateEo);
                RoleAccessTemplateRelationEo roleAccessTemplateRelationEo = new RoleAccessTemplateRelationEo();
                roleAccessTemplateRelationEo.setAccessTemplateCode(accessTemplateDto.getCode());
                roleAccessTemplateRelationEo.setRoleTemplateCode(roleAccessTemRemoveReqDto.getRoleTemplateCode());
                this.roleAccessTemplateRelationDas.logicDelete((BaseEo)roleAccessTemplateRelationEo);
            }
        }
    }

    private List<AccessTemplateRespDto> getAccessDtos(String roleTemplateCode) {
        Set accessTemplateCodes;
        ArrayList<AccessTemplateRespDto> accessTemplateRespDtos = new ArrayList<AccessTemplateRespDto>();
        RoleTemplateAccessRelationEo roleTemplateAccessRelationEo = new RoleTemplateAccessRelationEo();
        roleTemplateAccessRelationEo.setRoleTemplateCode(roleTemplateCode);
        List roleTemplateAccessRelationEos = this.roleTemplateAccessRelationDas.select((BaseEo)roleTemplateAccessRelationEo);
        if (CollectionUtils.isNotEmpty((Collection)roleTemplateAccessRelationEos) && CollectionUtils.isNotEmpty(accessTemplateCodes = roleTemplateAccessRelationEos.stream().filter(r -> r.getAccessTemplateCode() != null).map(StdRoleTemplateAccessRelationEo::getAccessTemplateCode).collect(Collectors.toSet()))) {
            List accessTemplateEos = this.accessTemplateDas.selectByCodeList(accessTemplateCodes);
            for (AccessTemplateEo eo : accessTemplateEos) {
                AccessTemplateRespDto accessTemplateRespDto = new AccessTemplateRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)accessTemplateRespDto);
                ResourceBaseDto resourceBaseDto = new ResourceBaseDto();
                resourceBaseDto.setStatus(Integer.valueOf(1));
                ResourceQueryResDto resourceQueryResDto = this.resourceService.queryResourceByCode(eo.getResourceCode(), new ArrayList<String>(), resourceBaseDto);
                if (resourceQueryResDto != null) {
                    accessTemplateRespDto.setResourceQueryResDto(resourceQueryResDto);
                }
                accessTemplateRespDtos.add(accessTemplateRespDto);
            }
        }
        return accessTemplateRespDtos;
    }

    private void checkAccessTemCodeExist(List<RoleAccessTemCreateReqDto> roleAccessTemCreateReqDtos) {
        HashMap<String, AccessTemplateReqDto> checkAccessTemCodes = new HashMap<String, AccessTemplateReqDto>();
        for (RoleAccessTemCreateReqDto reqDto : roleAccessTemCreateReqDtos) {
            if (CollectionUtils.isEmpty((Collection)reqDto.getAccessTemplateReqDtos())) {
                throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg() + "\u6743\u9650\u6a21\u677f\u4e0d\u80fd\u4e3anull");
            }
            for (AccessTemplateReqDto accessTemplateReqDto : reqDto.getAccessTemplateReqDtos()) {
                if (StringUtils.isBlank((CharSequence)accessTemplateReqDto.getCode()) || StringUtils.isBlank((CharSequence)accessTemplateReqDto.getResourceCode())) {
                    throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg() + "\u6743\u9650\u6a21\u677fcode\u6216\u8d44\u6e90code\u4e0d\u80fd\u4e3anull");
                }
                if (checkAccessTemCodes.get(accessTemplateReqDto.getCode()) != null) {
                    throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg() + "\u6743\u9650\u6a21\u677fcode\u9700\u8981\u552f\u4e00");
                }
                checkAccessTemCodes.put(accessTemplateReqDto.getCode(), accessTemplateReqDto);
            }
        }
        Set accessTemCodeSet = checkAccessTemCodes.keySet();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(accessTemCodeSet, (String)",")));
        AccessTemplateEo queryEo = new AccessTemplateEo();
        queryEo.setSqlFilters(filters);
        if (this.accessTemplateDas.count((BaseEo)queryEo) > 0) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), UserExceptionCode.REQ_PARAM_ERROR.getMsg() + "\u6743\u9650\u6a21\u677fcode\u5df2\u5b58\u5728");
        }
    }

    private void removeRoleAccessTemlate(String roleTemplateCode) {
        RoleAccessTemplateRelationEo roleAccessTemplateRelationEo = new RoleAccessTemplateRelationEo();
        roleAccessTemplateRelationEo.setRoleTemplateCode(roleTemplateCode);
        List roleAccessTemplateRelationEos = this.roleAccessTemplateRelationDas.select((BaseEo)roleAccessTemplateRelationEo);
        if (CollectionUtils.isNotEmpty((Collection)roleAccessTemplateRelationEos)) {
            Set accessTemCodes = roleAccessTemplateRelationEos.stream().filter(r -> r.getAccessTemplateCode() != null).map(StdRoleAccessTemplateRelationEo::getAccessTemplateCode).collect(Collectors.toSet());
            for (String accessCode : accessTemCodes) {
                AccessTemplateEo accessTemplateEo = new AccessTemplateEo();
                accessTemplateEo.setCode(accessCode);
                this.accessTemplateDas.logicDelete((BaseEo)accessTemplateEo);
            }
            for (RoleAccessTemplateRelationEo eo : roleAccessTemplateRelationEos) {
                this.roleAccessTemplateRelationDas.logicDelete((BaseEo)eo);
            }
        }
    }
}

