/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserInstanceRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserAppInstanceService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserAppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserAppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.ext.access.IAfterDeleteUserAppInstanceExt;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserAppInstanceServiceImpl
implements IUserAppInstanceService {
    @Resource
    private UserAppInstanceDas userAppInstanceDas;
    @Resource
    private UserDas userDas;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private IAfterDeleteUserAppInstanceExt afterDeleteUserAppInstanceExt;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUserInstanceRelationAll(UserInstanceRelationReqDto userInstanceRelationReqDto) {
        this.paramsCheck(userInstanceRelationReqDto);
        if (CollectionUtils.isNotEmpty((Collection)userInstanceRelationReqDto.getInstanceIds())) {
            ArrayList eoList = Lists.newArrayList();
            for (Object instanceId : userInstanceRelationReqDto.getInstanceIds()) {
                UserAppInstanceEo eo = this.buildUserAppInstanceEo(userInstanceRelationReqDto, (Long)instanceId);
                eoList.add(eo);
            }
            List list = this.userAppInstanceDas.selectListByUserId(userInstanceRelationReqDto.getUserId());
            for (UserAppInstanceEo eo : list) {
                this.userAppInstanceDas.logicDelete((BaseEo)eo);
            }
            UserRoleRelationEo extEo = new UserRoleRelationEo();
            extEo.setUserId(userInstanceRelationReqDto.getUserId());
            this.afterDeleteUserAppInstanceExt.execute((Object)extEo);
            this.userAppInstanceDas.insertBatch((List)eoList);
        }
    }

    private void paramsCheck(UserInstanceRelationReqDto userInstanceRelationReqDto) {
        AssertUtil.isTrue(userInstanceRelationReqDto.getUserId() != null, "\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)userInstanceRelationReqDto.getInstanceIds()), "\u5e94\u7528id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userInstanceRelationReqDto.getUserId());
        if (userEo == null) {
            throw new BizException(UserExceptionCode.USER_NOTEXIST_FAIL.getCode(), UserExceptionCode.USER_NOTEXIST_FAIL.getMsg());
        }
        for (Long id : userInstanceRelationReqDto.getInstanceIds()) {
            AppInstanceEo eo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(id);
            if (eo != null) continue;
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg() + "\uff0c\u5e94\u7528id\u4e3a[" + id + "]");
        }
    }

    private UserAppInstanceEo buildUserAppInstanceEo(UserInstanceRelationReqDto userInstanceRelationReqDto, Long instanceId) {
        UserAppInstanceEo eo = new UserAppInstanceEo();
        eo.setUserId(userInstanceRelationReqDto.getUserId());
        eo.setInstanceId(instanceId);
        eo.setExtension(StringUtils.isNotBlank((CharSequence)userInstanceRelationReqDto.getExtension()) ? userInstanceRelationReqDto.getExtension() : "");
        return eo;
    }

    @Override
    public void addUserInstanceRelation(UserInstanceRelationReqDto userInstanceRelationReqDto) {
        this.paramsCheck(userInstanceRelationReqDto);
        if (CollectionUtils.isNotEmpty((Collection)userInstanceRelationReqDto.getInstanceIds())) {
            List<Long> instanceIdList = this.getInstanceIdList(userInstanceRelationReqDto.getUserId());
            ArrayList eoList = Lists.newArrayList();
            for (Long instanceId : userInstanceRelationReqDto.getInstanceIds()) {
                if (!CollectionUtils.isEmpty(instanceIdList) && instanceIdList.contains(instanceId)) continue;
                UserAppInstanceEo eo = this.buildUserAppInstanceEo(userInstanceRelationReqDto, instanceId);
                eoList.add(eo);
            }
            this.userAppInstanceDas.insertBatch((List)eoList);
        }
    }

    private List<Long> getInstanceIdList(Long userId) {
        List list = this.userAppInstanceDas.selectListByUserId(userId);
        List<Object> instanceIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            instanceIdList = list.stream().map(BaseEo::getInstanceId).collect(Collectors.toList());
        }
        return instanceIdList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteUserInstanceRelation(UserInstanceRelationReqDto userInstanceRelationReqDto) {
        this.paramsCheck(userInstanceRelationReqDto);
        if (CollectionUtils.isNotEmpty((Collection)userInstanceRelationReqDto.getInstanceIds())) {
            List list = this.userAppInstanceDas.selectListByUserIdAndOrgIdList(userInstanceRelationReqDto.getUserId(), userInstanceRelationReqDto.getInstanceIds());
            for (UserAppInstanceEo eo : list) {
                this.userAppInstanceDas.logicDelete((BaseEo)eo);
                UserRoleRelationEo extEo = new UserRoleRelationEo();
                extEo.setInstanceId(eo.getInstanceId());
                extEo.setUserId(userInstanceRelationReqDto.getUserId());
                this.afterDeleteUserAppInstanceExt.execute((Object)extEo);
            }
        }
    }

    @Override
    public PageInfo<AppInstanceDto> queryUserInstanceRelation(Long userId, Integer pageNum, Integer pageSize) {
        List<Long> instanceIdList = this.getInstanceIdList(userId);
        if (CollectionUtils.isNotEmpty(instanceIdList)) {
            AppInstanceEo queryEo = new AppInstanceEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join(instanceIdList, (String)",")));
            queryEo.setSqlFilters(sqlFilterList);
            queryEo.setOrderByDesc("update_time");
            PageInfo eoPageInfo = this.appInstanceDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
            return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPageInfo, AppInstanceDto.class);
        }
        return new PageInfo();
    }
}

