/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserGroupDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.IExceptionEnum;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.Collection2SqlInConditionUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.GroupUserRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserGroupDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserGroupRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.GroupUserRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdGroupUserRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserGroupEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserGroupRoleRelationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserGroupServiceImpl
implements IUserGroupService {
    private Logger logger = LoggerFactory.getLogger(UserGroupServiceImpl.class);
    @Resource
    private UserGroupDas userGroupDas;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private UserDas userDas;
    @Resource
    private RoleDas roleDas;
    @Resource
    private UserGroupRoleRelationDas userGroupRoleRelationDas;
    @Resource
    private GroupUserRelationDas groupUserRelationDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addUserGroup(Long instanceId, Long userId, UserGroupDto userGroupDto) {
        UserGroupEo userGroupEo;
        UserGroupEo userGroupEo2;
        Long tenantId = userGroupDto.getTenantId();
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (appInstanceEo == null) {
            throw new BizException(UserExceptionCode.APPLICATION_EXCEPTION_CODE.getCode(), UserExceptionCode.APPLICATION_EXCEPTION_CODE.getMsg());
        }
        List userGroupEos = this.userGroupDas.selectAll();
        if (CollectionUtils.isEmpty((Collection)userGroupEos)) {
            userGroupEo2 = new UserGroupEo();
            userGroupEo2.setOwnerId(userId);
            userGroupEo2.setGroupName("\u6839\u8282\u70b9");
            userGroupEo2.setInstanceId(instanceId);
            userGroupEo2.setTenantId(tenantId);
            appInstanceEo.setTenantId(tenantId);
            this.userGroupDas.insert((BaseEo)userGroupEo2);
        } else {
            userGroupEo2 = userGroupEos.iterator();
            while (userGroupEo2.hasNext()) {
                userGroupEo = (UserGroupEo)userGroupEo2.next();
                AssertUtil.isTrue(!userGroupEo.getGroupName().equals(userGroupDto.getGroupName()), "\u7528\u6237\u7ec4\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        if (userGroupDto.getParentId() != null && (userGroupEo2 = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(userGroupDto.getParentId())) == null) {
            throw new BizException(UserExceptionCode.USERGROUP_FIND_FAIL.getCode(), UserExceptionCode.USERGROUP_FIND_FAIL.getMsg());
        }
        UserEo owner = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (owner != null) {
            userGroupEo = new UserGroupEo();
            DtoHelper.dto2Eo((BaseVo)userGroupDto, (BaseEo)userGroupEo);
            userGroupEo.setOwnerId(userId);
            userGroupEo.setInstanceId(instanceId);
            if (userGroupDto.getParentId() != null) {
                UserGroupEo parent = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(userGroupDto.getParentId());
                userGroupEo.setParentId(parent.getId());
            } else {
                AssertUtil.isTrue(this.userGroupDas.findRootByInstanceId(instanceId) == null, "\u8be5\u5b9e\u4f8b\u7684\u6839\u7528\u6237\u7ec4\u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0\u65b0\u7684\u6839\u7528\u6237\u7ec4");
            }
            if (userGroupEo.getStatus() == null) {
                userGroupEo.setStatus(Integer.valueOf(1));
            }
            userGroupEo.setTenantId(tenantId);
            userGroupEo.setRemark(userGroupDto.getRemark());
            this.userGroupDas.insert((BaseEo)userGroupEo);
            return userGroupEo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateUserGroup(Long groupId, UserGroupDto userGroupDto) {
        UserGroupEo userGroupEo = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(groupId);
        AssertUtil.isTrue(null != userGroupEo, "\u7528\u6237\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728");
        userGroupEo = new UserGroupEo();
        userGroupDto.setId(groupId);
        DtoHelper.dto2Eo((BaseVo)userGroupDto, (BaseEo)userGroupEo, (String[])new String[]{"parentId", "tenantId", "instanceId"});
        if (userGroupDto.getParentId() != null) {
            UserGroupEo parent = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(userGroupDto.getParentId());
            if (parent == null) {
                throw new BizException(UserExceptionCode.USERGROUP_PARENT_FAIL.getCode(), UserExceptionCode.USERGROUP_PARENT_FAIL.getMsg());
            }
            userGroupEo.setParentId(parent.getId());
        }
        userGroupEo.setId(userGroupDto.getId());
        this.userGroupDas.updateSelective((BaseEo)userGroupEo);
        return groupId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long deleteUserGroup(Long groupId) {
        UserGroupEo userGroupEo = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(groupId);
        if (userGroupEo != null) {
            List children = this.userGroupDas.findByParentId(groupId);
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                this.logger.error("\u8be5\u7528\u6237\u7ec4\u7684\u5b50\u5206\u7ec4\u6709\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
                throw new BizException(UserExceptionCode.USERGROUP_CHILD_FAIL.getCode(), UserExceptionCode.USERGROUP_CHILD_FAIL.getMsg());
            }
            Long count = this.userGroupDas.findUsersByGroupId(groupId);
            if (count > 0L) {
                this.logger.error("\u8be5\u7528\u6237\u7ec4\u4e0b\u9762\u6709\u7528\u6237\uff0c\u65e0\u6cd5\u5220\u9664");
                throw new BizException(UserExceptionCode.USERGROUP_USER_FAIL.getCode(), UserExceptionCode.USERGROUP_USER_FAIL.getMsg());
            }
            this.userGroupDas.logicDeleteById(groupId);
        }
        return 1L;
    }

    @Override
    public UserGroupDto queryOne(Long instanceId) {
        UserGroupEo userGroupEo = this.userGroupDas.findRootByInstanceId(instanceId);
        if (userGroupEo == null) {
            this.logger.info("\u901a\u8fc7\u5e94\u7528\u5b9e\u4f8bid\u67e5\u8be2\u7528\u6237\u7ec4\u4fe1\u606f\u5f02\u5e38\uff0c\u5b9e\u4f8bid\u4e3a" + instanceId);
            throw new BizException(UserExceptionCode.USERGROUP_APPID_FAIL.getCode(), UserExceptionCode.USERGROUP_APPID_FAIL.getMsg());
        }
        List children = this.userGroupDas.findUserGroupTreeByParentId(userGroupEo.getId());
        ArrayList childrenDto = Lists.newArrayList();
        this.userGroupEoList2DtoList(children, childrenDto);
        UserGroupDto userGroupDto = new UserGroupDto();
        DtoHelper.eo2Dto((BaseEo)userGroupEo, (BaseVo)userGroupDto);
        userGroupDto.setChildren((List)childrenDto);
        return userGroupDto;
    }

    @Override
    public PageInfo<UserGroupDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo eoPageInfo;
        UserGroupEo userGroupEo;
        UserGroupEo userGroupEo2 = userGroupEo = StringUtils.isNotBlank((CharSequence)filter) ? (UserGroupEo)JSON.parseObject((String)filter, UserGroupEo.class) : new UserGroupEo();
        if (StringUtils.isNotEmpty((CharSequence)userGroupEo.getGroupName())) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            SqlFilter sqlFilter = new SqlFilter();
            sqlFilter.setProperty("groupName");
            sqlFilter.setValue((Object)("%" + userGroupEo.getGroupName() + "%"));
            sqlFilter.setOperator(SqlFilter.Operator.like);
            sqlFilters.add(sqlFilter);
            userGroupEo.setSqlFilters(sqlFilters);
            userGroupEo.setGroupName(null);
        }
        if ((eoPageInfo = this.userGroupDas.selectPage((BaseEo)userGroupEo, pageNum, pageSize)) != null) {
            ArrayList userGroupDtoList = Lists.newArrayList();
            PageInfo dtoPageInfo = new PageInfo((List)userGroupDtoList);
            if (!eoPageInfo.getList().isEmpty()) {
                DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), (Collection)userGroupDtoList, UserGroupDto.class);
            }
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list"});
            return dtoPageInfo;
        }
        return null;
    }

    private void userGroupEoList2DtoList(List<UserGroupEo> userGroupEos, List<UserGroupDto> userGroupDtos) {
        if (CollectionUtils.isNotEmpty(userGroupEos)) {
            for (UserGroupEo userGroupEo : userGroupEos) {
                if (userGroupEo.getParentId() != null && userGroupEo.getId().equals(userGroupEo.getParentId())) {
                    this.logger.info(String.format("\u7528\u6237\u7ec4[%s]\u7684\u7236\u7528\u6237\u7ec4\u4e0d\u80fd\u662f\u81ea\u5df1", userGroupEo.getId()));
                    throw new BizException(UserExceptionCode.USER_GROUP_DATA_EXCEPTION.getCode(), UserExceptionCode.USER_GROUP_DATA_EXCEPTION.getMsg());
                }
                UserGroupDto userGroupDto = new UserGroupDto();
                DtoHelper.eo2Dto((BaseEo)userGroupEo, (BaseVo)userGroupDto);
                userGroupDtos.add(userGroupDto);
                if (!CollectionUtils.isNotEmpty((Collection)userGroupEo.getChildren())) continue;
                ArrayList childrenDtos = Lists.newArrayList();
                this.userGroupEoList2DtoList(userGroupEo.getChildren(), childrenDtos);
                userGroupDto.setChildren((List)childrenDtos);
            }
        }
    }

    @Override
    public void removeUserRoles(Long groupId, Long[] roleIds) {
        UserGroupEo userGroupEo = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(groupId);
        AssertUtil.isTrue(null != userGroupEo, "id\u4e3a" + groupId + "\u7684\u7528\u6237\u7ec4\u4e0d\u5b58\u5728");
        for (Long roleId : roleIds) {
            RoleEo role = (RoleEo)this.roleDas.selectByPrimaryKey(roleId);
            AssertUtil.isTrue(null != role, "id\u4e3a" + roleId + "\u7684\u89d2\u8272\u4e0d\u5b58\u5728");
            UserGroupRoleRelationEo userGroupRoleRelationEo = new UserGroupRoleRelationEo();
            userGroupRoleRelationEo.setUserGroupId(groupId);
            userGroupRoleRelationEo.setRoleId(roleId);
            this.userGroupRoleRelationDas.delete((BaseEo)userGroupRoleRelationEo);
        }
    }

    @Override
    public List<UserGroupDto> findUserGroupOfUser(Long userId) {
        AssertUtil.isTrue(this.userDas.selectByPrimaryKey(userId) != null, (IExceptionEnum)UserExceptionCode.USER_IDCHECK_FAIL);
        GroupUserRelationEo selectParam = new GroupUserRelationEo();
        selectParam.setUserId(userId);
        List groupUserRelationEos = this.groupUserRelationDas.select((BaseEo)selectParam);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)groupUserRelationEos), (IExceptionEnum)UserExceptionCode.USER_NOT_BELONG_TO_GROUP);
        Set<Long> groupIds = groupUserRelationEos.stream().map(StdGroupUserRelationEo::getUserGroupId).collect(Collectors.toSet());
        List<UserGroupEo> userGroupEos = this.findUserGroupsInProperties(groupIds, "id");
        if (CollectionUtils.isEmpty(userGroupEos)) {
            this.logger.info("\u901a\u8fc7\u7528\u6237\u7ec4id\u3010{}\u3011\u67e5\u8be2\u7528\u6237\u7ec4\u4fe1\u606f\u5f02\u5e38", groupIds);
            throw new BizException(UserExceptionCode.USERGROUP_FIND_FAIL.getCode(), UserExceptionCode.USERGROUP_FIND_FAIL.getMsg());
        }
        List<UserGroupDto> list = userGroupEos.stream().map(userGroupEo -> {
            UserGroupDto userGroupDto = new UserGroupDto();
            DtoHelper.eo2Dto((BaseEo)userGroupEo, (BaseVo)userGroupDto);
            return userGroupDto;
        }).collect(Collectors.toList());
        return list;
    }

    @Override
    public List<UserGroupDto> queryByGroupType(Integer type, Long tenantId) {
        UserGroupEo userGroupEo = new UserGroupEo();
        userGroupEo.setGroupType(type);
        userGroupEo.setTenantId(tenantId);
        List userGroupEoList = this.userGroupDas.select((BaseEo)userGroupEo);
        ArrayList<UserGroupDto> userGroupDtoList = new ArrayList<UserGroupDto>();
        DtoHelper.eoList2DtoList((Collection)userGroupEoList, userGroupDtoList, UserGroupDto.class);
        return userGroupDtoList;
    }

    private List<UserGroupEo> findUserGroupsInProperties(Collection<Long> properties, String propertyName) {
        if (CollectionUtils.isEmpty(properties)) {
            return Lists.newArrayList();
        }
        String idChain = Collection2SqlInConditionUtil.transefer(properties);
        UserGroupEo userGroupEo = new UserGroupEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        SqlFilter sqlFilter = new SqlFilter();
        sqlFilter.setOperator(SqlFilter.Operator.in);
        sqlFilter.setProperty(propertyName);
        sqlFilter.setValue((Object)idChain);
        sqlFilters.add(sqlFilter);
        userGroupEo.setSqlFilters(sqlFilters);
        return this.userGroupDas.select((BaseEo)userGroupEo);
    }
}

