/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.meta.sql.biz.parser;

import com.dtyunxi.yundt.cube.center.meta.sql.biz.parser.AbstractValueSqlWhereParamsParser;
import com.dtyunxi.yundt.cube.center.meta.sql.biz.util.Assert;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeSqlWhereParamsParser
extends AbstractValueSqlWhereParamsParser {
    private String timeFormat = "yyyy-MM-dd";
    private String fullTimeFlag = "";
    private String[] opers = new String[]{"time>", "time>=", "time<", "time<="};

    public TimeSqlWhereParamsParser() {
        this.setOpers(this.opers);
    }

    public TimeSqlWhereParamsParser(String timeFormat, String fullTimeFlag) {
        this.setTimeFormat(timeFormat);
        this.setFullTimeFlag(fullTimeFlag);
        String[] newOpers = new String[this.opers.length];
        int len = this.opers.length;
        for (int i = 0; i < len; ++i) {
            newOpers[i] = this.fullTimeFlag + this.opers[i];
        }
        this.setOpers(newOpers);
    }

    public void setFullTimeFlag(String fullTimeFlag) {
        this.fullTimeFlag = fullTimeFlag == null ? this.fullTimeFlag : fullTimeFlag;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    @Override
    protected String getKey(String key) {
        return "unix_timestamp(" + key + ")*1000";
    }

    @Override
    protected String getOper(String oper) {
        return oper.substring(4 + this.fullTimeFlag.length());
    }

    @Override
    protected Object getStringValue(Object value) {
        if (value instanceof String) {
            String tmp = (String)value;
            Assert.isLarger(tmp.length(), 2, "\u65f6\u95f4\u7684value\u503c " + tmp + " \u4e0d\u5408\u6cd5");
            value = tmp.substring(1, tmp.length() - 1);
        }
        return this.getObjectValue(value);
    }

    @Override
    protected Object getObjectValue(Object value) {
        if (value instanceof String) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(this.timeFormat);
                Date date = format.parse((String)value);
                value = date.getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("timeFormat\u4e3a" + this.timeFormat + ";value=" + value + ";\u51fa\u73b0\u4e86\u89e3\u6790\u5f02\u5e38");
            }
        } else {
            Assert.isInstanceof(value, Number.class, "\u65f6\u95f4\u53c2\u6570\u5fc5\u987b\u4e3a\u65f6\u95f4\u7684\u6beb\u79d2\u6570");
        }
        return value;
    }
}

