/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserModifyPasswordDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserResetPasswordDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.ISecurityService;
import com.dtyunxi.yundt.module.context.api.IContext;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="iSecurityApi")
public class SecurityApiImpl
implements ISecurityApi {
    @Autowired
    private ISecurityService iSecurityService;
    @Resource
    private IContext context;

    public RestResponse<Void> modifyPassword(String userName, String password, String oldPassword) {
        this.iSecurityService.modifyPassword(userName, password, oldPassword);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> resetPassword(UserResetPasswordDto userResetPasswordDto) {
        String domain = userResetPasswordDto.getDomain();
        if (StringUtils.isBlank((CharSequence)domain) && null != userResetPasswordDto.getExtFields() && null != userResetPasswordDto.getExtFields().get("domain")) {
            domain = (String)userResetPasswordDto.getExtFields().get("domain");
        }
        this.iSecurityService.resetPassword(userResetPasswordDto.getVerifyCode(), userResetPasswordDto.getTarget(), userResetPasswordDto.getNewPassword(), userResetPasswordDto.getInstanceId(), domain);
        return RestResponse.VOID;
    }

    public RestResponse<Void> resetPassword(String verifyCode, String target, String newPassword) {
        this.iSecurityService.resetPassword(verifyCode, target, newPassword);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> modifyPassword(UserModifyPasswordDto userModifyPasswordDto) {
        String domain = userModifyPasswordDto.getDomain();
        if (StringUtils.isBlank((CharSequence)domain) && null != userModifyPasswordDto.getExtFields() && null != userModifyPasswordDto.getExtFields().get("domain")) {
            domain = (String)userModifyPasswordDto.getExtFields().get("domain");
        }
        Long intanceId = userModifyPasswordDto.getInstanceId() == null ? this.context.instanceId() : userModifyPasswordDto.getInstanceId();
        this.iSecurityService.modifyPassword(userModifyPasswordDto.getUserName(), userModifyPasswordDto.getPassword(), userModifyPasswordDto.getNewPassword(), intanceId, domain);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyPassword(Long instanceId, String userName, String password, String oldPassword) {
        this.iSecurityService.modifyPassword(userName, password, oldPassword, instanceId, null);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> resetPassword(Long instanceId, String verifyCode, String target, String newPassword) {
        this.iSecurityService.resetPassword(verifyCode, target, newPassword, instanceId, null);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> resetPasswordByAdmin(Long userId, String newPassword) {
        this.iSecurityService.resetPasswordByAdmin(userId, newPassword);
        return RestResponse.SUCCESS;
    }
}

