/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.BindingsDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ImportUsersDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.TenantDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserValidDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.AddUserAndGiveRolesReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.UserModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ext.user.UserUniqueCheckDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.TenantManagerCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.TenantManagerUpdateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ThirdPartyUserReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserInstanceRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.ImportUserResult;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBocUserService;
import com.dtyunxi.yundt.cube.center.user.biz.service.ITenantService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserAppInstanceService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserRelationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.ext.tenant.ITenantAfterDisableExt;
import com.dtyunxi.yundt.cube.center.user.ext.tenant.ITenantAfterRegisterExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IPostproccess4BatchImportUserExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IPreproccess4BatchImportUserExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IUserUniquenessExt;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="iUserApi")
public class UserApiImpl
implements IUserApi {
    @Autowired
    private IUserService userService;
    @Autowired
    private IUserRelationService userRelationService;
    @Resource
    private ITenantService tenantService;
    @Resource
    private IApplicationService applicationService;
    @Resource
    private IBocUserService bocUserService;
    @Resource
    private IUserAppInstanceService userAppInstanceService;
    @Resource
    private IContext context;
    @Autowired
    private IUserUniquenessExt<Boolean, UserUniqueCheckDto> userUniquenessExt;
    @Resource
    private ITenantAfterRegisterExt tenantAfterRegisterExt;
    @Resource
    private ITenantAfterDisableExt tenantAfterDisableExt;
    @Autowired
    private IPreproccess4BatchImportUserExt<Boolean, List<ImportUsersDto>> preproccess4BatchImportUserExt;
    @Autowired
    private IPostproccess4BatchImportUserExt<ImportUserResult, ImportUserResult> postproccess4BatchImportUserExt;
    public static final Logger logger = LoggerFactory.getLogger(UserApiImpl.class);

    public RestResponse<Void> bindUserRelation(Long instanceId, Long firstUserId, Long secondUserId, Integer relationType) {
        this.userRelationService.bindUserRelation(instanceId, firstUserId, secondUserId, relationType);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> unbindUserRelation(Long instanceId, Long firstUserId, Long secondUserId, Integer relationType) {
        this.userRelationService.unbindUserRelation(instanceId, firstUserId, secondUserId, relationType);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> addUser(Long instanceId, UserDto userDto) {
        UserEo userEo = this.userService.addUser(instanceId, userDto);
        return new RestResponse((Object)userEo.getId());
    }

    public RestResponse<Long> addUserWithSalt(Long instanceId, UserDto userDto) {
        UserEo userEo = this.userService.addUserWithEncryptedPasswd(instanceId, userDto);
        return new RestResponse((Object)userEo.getId());
    }

    public RestResponse<Long> addThirdPartyUser(Long instanceId, @Valid ThirdPartyUserReqDto thirdPartyUserReqDto) {
        UserEo userEo = this.userService.addThirdPartyUser(instanceId, thirdPartyUserReqDto);
        return new RestResponse((Object)userEo.getId());
    }

    public RestResponse<Long> addTenantManager(Long tenantId, TenantManagerCreateReqDto tenantManagerCreateReqDto) {
        tenantManagerCreateReqDto.setTenantId(tenantId);
        UserEo userEo = this.userService.addTenantManager(tenantManagerCreateReqDto);
        return new RestResponse((Object)userEo.getId());
    }

    public RestResponse<Long> addTenantAdmin(TenantManagerCreateReqDto tenantManagerCreateReqDto) {
        Long curTenantId = ServiceContext.getContext().getRequestTenantId();
        Long curInstanceId = ServiceContext.getContext().getRequestInstanceId();
        if (curInstanceId == null || curTenantId == null) {
            throw new RuntimeException("\u7f3a\u5c11\u8bf7\u6c42\u5bf9\u5e94\u7684instanceId \u6216 tenantId");
        }
        if (this.applicationService.isGlobalInstance(curInstanceId)) {
            if (tenantManagerCreateReqDto.getTenantId() == null) {
                tenantManagerCreateReqDto.setTenantId(curTenantId);
            }
        } else {
            tenantManagerCreateReqDto.setTenantId(curTenantId);
        }
        UserEo userEo = this.userService.addTenantManager(tenantManagerCreateReqDto);
        return new RestResponse((Object)userEo.getId());
    }

    public RestResponse<Void> update(Long id, UserDto userDto) {
        userDto.setId(id);
        this.userService.update(userDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> updateTenantManager(Long id, TenantManagerUpdateReqDto tenantManagerUpdateReqDto) {
        AssertUtil.isTrue(tenantManagerUpdateReqDto != null && (StringUtils.isNotBlank((CharSequence)tenantManagerUpdateReqDto.getNickName()) || StringUtils.isNotBlank((CharSequence)tenantManagerUpdateReqDto.getPhone()) || StringUtils.isNotBlank((CharSequence)tenantManagerUpdateReqDto.getEmail())), "userId \u4e0d\u80fd\u4e3a\u7a7a");
        UserDto userDto = new UserDto();
        CubeBeanUtils.copyProperties((Object)userDto, (Object)tenantManagerUpdateReqDto, (String[])new String[0]);
        userDto.setId(id);
        this.userService.update(userDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updatePasswordPermitted(Long id, UserDto userDto) {
        userDto.setId(id);
        this.userService.updatePasswordPermitted(userDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> updatePasswordPermittedWithSalt(Long id, UserDto userDto) {
        userDto.setId(id);
        this.userService.updatePasswordPermittedWithSalt(userDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> enableTenantManager(Long userId) {
        this.userService.enableTenantManager(userId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> disableTenantManager(Long userId) {
        this.userService.disableTenantManager(userId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long userId) {
        this.userService.delete(userId);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> batchDelete(String batch) {
        this.userService.batchDelete(batch);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> enableLogin(Long userId, String type, Integer status) {
        this.userService.enableLogin(userId, type, status);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Long> registerDeveloper(UserDto userDto) {
        Long userId = this.userService.registerDeveloper(userDto);
        return new RestResponse((Object)userId);
    }

    public RestResponse<Long> registerTenant(TenantDto tenantDto) {
        Long tenantId = this.tenantService.addTenant(tenantDto);
        return new RestResponse((Object)tenantId);
    }

    public RestResponse<Void> updateTenant(@Valid TenantDto tenantDto) {
        this.tenantService.updateTenant(tenantDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> enableTenant(Long tenantId) {
        this.tenantService.enableTenant(tenantId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> disableTenant(Long tenantId) {
        this.tenantService.disableTenant(tenantId);
        if (this.tenantAfterRegisterExt != null) {
            this.tenantAfterDisableExt.execute();
        }
        return RestResponse.VOID;
    }

    public RestResponse<Boolean> checkUserUnique(String column, String value) {
        return new RestResponse((Object)this.userService.checkUserUnique(column, value));
    }

    public RestResponse<Boolean> checkUserUnique(Long instanceId, String column, String value) {
        return new RestResponse(this.userUniquenessExt.execute((Object)UserUniqueCheckDto.init(null, (Long)instanceId, null, (String)column, (Object)value)));
    }

    public RestResponse<Void> setTenantRegisterConfig(Long tenantId, Integer isolationType) {
        this.userService.setTenantRegisterConfig(tenantId, isolationType);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Boolean> isValid(Long instanceId, Long tenantId, String loginStr, String password) {
        return new RestResponse((Object)this.userService.isValid(loginStr, password, instanceId, tenantId, null));
    }

    public RestResponse<Boolean> isValid(UserValidDto userValidDto) {
        String domain = userValidDto.getDomain();
        if (StringUtils.isBlank((CharSequence)domain) && null != userValidDto.getExtFields() && null != userValidDto.getExtFields().get("domain")) {
            domain = (String)userValidDto.getExtFields().get("domain");
        }
        Long intanceId = userValidDto.getInstanceId() == null ? this.context.instanceId() : userValidDto.getInstanceId();
        Long tenantId = userValidDto.getTenantId() == null ? this.context.tenantId() : userValidDto.getTenantId();
        return new RestResponse((Object)this.userService.isValid(userValidDto.getLoginStr(), userValidDto.getPassword(), intanceId, tenantId, domain));
    }

    public RestResponse<Long> addBinding(Long userId, BindingsDto bindingsDto) {
        return new RestResponse((Object)this.userService.addBinding(userId, bindingsDto));
    }

    public RestResponse<Integer> unbinding(String filter) {
        BindingsDto bindingsDto = (BindingsDto)JSON.parseObject((String)filter, BindingsDto.class);
        return new RestResponse((Object)this.userService.unbinding(bindingsDto));
    }

    public RestResponse<Void> removeBinding(Long userId, BindingsDto bindingsDto) {
        this.userService.removeBinding(userId, bindingsDto);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> addUserToGroup(Long userId, Long groupId) {
        this.userService.addUserToGroup(userId, groupId);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> removeUserRoles(Long userId, Long[] roleIds) {
        this.userService.removeUserRoles(userId, roleIds);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> removeUserPhone(Long userId) {
        this.userService.removeUserPhone(userId);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> batchDelete(List<Long> ids) {
        this.bocUserService.batchDelete(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Long> createUserAndGiveRoles(AddUserAndGiveRolesReqDto addUserAndGiveRolesReqDto) {
        return new RestResponse((Object)this.bocUserService.createUserAndGiveRoles(addUserAndGiveRolesReqDto.getUserDto(), addUserAndGiveRolesReqDto.getGiveRolesReqDtoList(), addUserAndGiveRolesReqDto.getInstanceIds()));
    }

    public RestResponse<Void> modifyUserAndGiveRoles(UserModifyReqDto userModifyReqDto) {
        this.bocUserService.modifyUserAndGiveRoles(userModifyReqDto.getId(), userModifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<List<Map<String, String>>> importUsers(Long instanceId, List<ImportUsersDto> list) {
        List<Map<String, String>> errorList = this.userService.addBatchUsers(instanceId, list);
        if (errorList.isEmpty()) {
            return RestResponse.SUCCESS;
        }
        return new RestResponse(errorList);
    }

    public RestResponse<ImportUserResult> addBatchUsers(Long instanceId, List<ImportUsersDto> list) {
        return new RestResponse(null);
    }

    public RestResponse<ImportUserResult> batchImportUser(Long instanceId, @Valid List<ImportUsersDto> list) {
        this.preproccess4BatchImportUserExt.execute(list);
        ImportUserResult result = this.userService.importUsers(instanceId, list);
        return new RestResponse(this.postproccess4BatchImportUserExt.execute((Object)result));
    }

    public RestResponse<Long> addUserAndBindRole(UserCreateReqDto userDto) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        UserDto user = new UserDto();
        CubeBeanUtils.copyProperties((Object)user, (Object)userDto, (String[])new String[0]);
        if (StringUtils.isBlank((CharSequence)user.getExtension())) {
            user.setExtension("");
        }
        user.setInstanceId(instanceId);
        user.setTenantId(tenantId);
        if (CollectionUtils.isNotEmpty((Collection)userDto.getRoleCodes())) {
            Set roleDtos = userDto.getRoleCodes().stream().map(roleCode -> {
                RoleDto roleDto = new RoleDto();
                roleDto.setCode(roleCode);
                return roleDto;
            }).collect(Collectors.toSet());
            user.setRoleSet(roleDtos);
        }
        if (CollectionUtils.isNotEmpty((Collection)userDto.getInstanceIds())) {
            user.setInstanceIds(userDto.getInstanceIds());
        }
        UserEo userEo = this.userService.addUser(instanceId, user);
        return new RestResponse((Object)userEo.getId());
    }

    public RestResponse<Void> addUserInstanceRelationAll(UserInstanceRelationReqDto userInstanceRelationReqDto) {
        this.userAppInstanceService.addUserInstanceRelationAll(userInstanceRelationReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addUserInstanceRelation(UserInstanceRelationReqDto userInstanceRelationReqDto) {
        this.userAppInstanceService.addUserInstanceRelation(userInstanceRelationReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> deleteUserInstanceRelation(UserInstanceRelationReqDto userInstanceRelationReqDto) {
        this.userAppInstanceService.deleteUserInstanceRelation(userInstanceRelationReqDto);
        return RestResponse.VOID;
    }
}

