/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.yundt.cube.center.user.api.dto.ext.user.Verification4ResetPasswordDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPasswordService;
import com.dtyunxi.yundt.cube.center.user.biz.service.ISecurityService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.TenantDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.TenantEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.ext.user.IVerifyBeforeResetPasswordExt;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SecurityServiceImpl
implements ISecurityService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityServiceImpl.class);
    @Resource
    private IUserService userService;
    @Resource
    private UserDas userDas;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private IPasswordService passwordService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private TenantDas tenantDas;
    @Resource
    private IContext context;
    @Value(value="${user.empty.salt.generate.enabled:true}")
    private boolean emptySaltGenerate;
    @Autowired
    IVerifyBeforeResetPasswordExt<Boolean, Verification4ResetPasswordDto> verifyBeforeResetPasswordExt;

    @Override
    public void modifyPassword(String userName, String oldPassword, String newPassword) {
        UserEo userEo = this.userDas.findByUserName(userName);
        if (userEo == null) {
            logger.info("\u901a\u8fc7\u7528\u6237\u540d\u67e5\u8be2\u4e0d\u5230\u7528\u6237\u4fe1\u606f\uff0c\u7528\u6237\u540d\u4e3a" + userName);
            throw new BizException(UserExceptionCode.USERNAME_CHECK_FAIL.getCode(), UserExceptionCode.USERNAME_CHECK_FAIL.getMsg());
        }
        boolean isPass = this.passwordService.verifyPassword(oldPassword, userEo.getPassword(), userEo.getSalt(), userEo.getTenantId(), userEo.getInstanceId());
        if (isPass) {
            if (this.emptySaltGenerate) {
                userEo.setSalt(UUID.randomUUID().toString());
            }
        } else {
            logger.info("\u5bc6\u7801\u4e0d\u6b63\u786e");
            throw new BizException(UserExceptionCode.MODIFYPW_CHECK_FAIL.getCode(), UserExceptionCode.MODIFYPW_CHECK_FAIL.getMsg());
        }
        String md5Password = this.passwordService.encryptPassword(newPassword, userEo.getSalt(), userEo.getTenantId(), userEo.getInstanceId());
        userEo.setPassword(md5Password);
        userEo.setModifyPasswordTime(new Date());
        this.userDas.update((BaseEo)userEo);
    }

    @Override
    public void resetPassword(String verifyCode, String target, String newPassword) {
        this.verifyBeforeResetPasswordExt.execute((Object)Verification4ResetPasswordDto.init((String)verifyCode, (String)target));
        UserEo userEo = this.userDas.findByLoginStr(target);
        this.userExist(userEo);
        if (this.emptySaltGenerate) {
            userEo.setSalt(UUID.randomUUID().toString());
        }
        String md5Password = this.passwordService.encryptPassword(newPassword, userEo.getSalt(), userEo.getTenantId(), userEo.getInstanceId());
        userEo.setPassword(md5Password);
        userEo.setModifyPasswordTime(new Date());
        this.userDas.update((BaseEo)userEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPassword(String userName, String oldPassword, String newPassword, Long instanceId, String domain) {
        if (StringUtils.isBlank((CharSequence)oldPassword)) {
            throw new BizException("\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)newPassword)) {
            throw new BizException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String thisNewPassword = this.passwordService.RSAEncrypt(newPassword);
        String thisOldPassword = this.passwordService.RSAEncrypt(oldPassword);
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        this.instanceIdExist(appInstanceEo);
        if (!this.userService.isIsolationByInstance(appInstanceEo.getTenantId())) {
            instanceId = null;
        }
        domain = this.checkAndGetDomain(domain, appInstanceEo, appInstanceEo.getTenantId());
        UserEo userEo = this.userDas.findByUserName(userName, appInstanceEo.getTenantId(), instanceId, domain);
        if (userEo == null) {
            logger.info("\u901a\u8fc7\u7528\u6237\u540d\u67e5\u8be2\u4e0d\u5230\u7528\u6237\u4fe1\u606f\uff0c\u7528\u6237\u540d\u4e3a" + userName);
            throw new BizException(UserExceptionCode.USERNAME_CHECK_FAIL.getCode(), UserExceptionCode.USERNAME_CHECK_FAIL.getMsg());
        }
        boolean isPass = this.passwordService.verifyPassword(thisOldPassword, userEo.getPassword(), userEo.getSalt(), userEo.getTenantId(), userEo.getInstanceId());
        if (isPass) {
            if (this.emptySaltGenerate) {
                userEo.setSalt(UUID.randomUUID().toString());
            }
        } else {
            logger.info("\u5bc6\u7801\u4e0d\u6b63\u786e");
            throw new BizException(UserExceptionCode.MODIFYPW_CHECK_FAIL.getCode(), UserExceptionCode.MODIFYPW_CHECK_FAIL.getMsg());
        }
        String md5Password = this.passwordService.encryptPassword(thisNewPassword, userEo.getSalt(), userEo.getTenantId(), userEo.getInstanceId());
        userEo.setPassword(md5Password);
        userEo.setModifyPasswordTime(new Date());
        this.userDas.update((BaseEo)userEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetPassword(String verifyCode, String target, String newPassword, Long instanceId, String domain) {
        this.verifyBeforeResetPasswordExt.execute((Object)Verification4ResetPasswordDto.init((String)verifyCode, (String)target));
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        this.instanceIdExist(appInstanceEo);
        if (!this.userService.isIsolationByInstance(appInstanceEo.getTenantId())) {
            instanceId = null;
        }
        domain = this.checkAndGetDomain(domain, appInstanceEo, appInstanceEo.getTenantId());
        UserEo userEo = this.userDas.findByLoginStr(target, appInstanceEo.getTenantId(), instanceId, domain);
        this.userExist(userEo);
        if (this.emptySaltGenerate) {
            userEo.setSalt(UUID.randomUUID().toString());
        }
        String md5Password = this.passwordService.encryptPassword(newPassword, userEo.getSalt(), userEo.getTenantId(), userEo.getInstanceId());
        userEo.setPassword(md5Password);
        userEo.setModifyPasswordTime(new Date());
        this.userDas.update((BaseEo)userEo);
    }

    @Override
    public void resetPasswordByAdmin(Long userId, String newPassword) {
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        this.userExist(userEo);
        if (this.emptySaltGenerate) {
            userEo.setSalt(UUID.randomUUID().toString());
        }
        String md5Password = this.passwordService.encryptPassword(newPassword, userEo.getSalt(), userEo.getTenantId(), userEo.getInstanceId());
        userEo.setPassword(md5Password);
        userEo.setModifyPasswordTime(new Date());
        this.userDas.update((BaseEo)userEo);
    }

    private void userExist(UserEo userEo) {
        if (null == userEo) {
            logger.info("\u7528\u6237\u4e0d\u5b58\u5728");
            throw new BizException(UserExceptionCode.USER_NOTEXIST_FAIL.getCode(), UserExceptionCode.USER_NOTEXIST_FAIL.getMsg());
        }
    }

    private void instanceIdExist(AppInstanceEo appInstanceEo) {
        if (null == appInstanceEo) {
            logger.info("\u5b9e\u4f8bID\u4e0d\u5b58\u5728");
            throw new BizException(UserExceptionCode.INSTANCEID_NOTEXIST_FAIL.getCode(), UserExceptionCode.INSTANCEID_NOTEXIST_FAIL.getMsg());
        }
    }

    private String checkAndGetDomain(String domain, AppInstanceEo appInstanceEo, Long tenantId) {
        if (StringUtils.isBlank((CharSequence)domain)) {
            tenantId = tenantId == null ? appInstanceEo.getTenantId() : tenantId;
            AssertUtil.isTrue(null != tenantId, "\u7528\u6237\u6240\u5c5e\u7684\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appInstanceEo.getDefDomain()})) {
                return appInstanceEo.getDefDomain();
            }
            TenantEo tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId);
            AssertUtil.isTrue(null != tenantEo, "\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tenantEo.getDefDomain()}), "\u5e10\u53f7\u57df\u4fe1\u606f\u4e0d\u5b58\u5728");
            return tenantEo.getDomain();
        }
        Long instanceId = this.context.instanceId();
        HashSet domainList = Sets.newHashSet();
        AppInstanceEo eo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (eo == null) {
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)eo.getDefDomain())) {
            domainList.add(eo.getDefDomain());
        }
        if (StringUtils.isNotBlank((CharSequence)eo.getTrustDomain())) {
            String[] trustDomainArray = eo.getTrustDomain().split(",");
            domainList.addAll(Arrays.asList(trustDomainArray));
        }
        if (CollectionUtils.isNotEmpty((Collection)domainList) && !domainList.contains(domain)) {
            throw new BizException(UserExceptionCode.INVALID_USER_DOMAIN.getCode(), UserExceptionCode.INVALID_USER_DOMAIN.getMsg());
        }
        return domain;
    }
}

