/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.PersonalInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.condition.Criteria;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPersonalInfoService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserExtService;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.BillInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PersonalInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.TenantDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserExtDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PersonalInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.TenantEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class UserExtServiceImpl
implements IUserExtService {
    private Logger logger = LoggerFactory.getLogger(UserExtServiceImpl.class);
    @Resource
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Resource
    private UserExtDas userExtDas;
    @Autowired
    private IPersonalInfoService personalInfoService;
    @Autowired
    private PersonalInfoDas personalInfoDas;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private BillInfoDas billInfoDas;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private TenantDas tenantDas;
    @Resource
    private IContext context;

    @Override
    public PageInfo<Map<String, Object>> findUserList(Long orgId, String userName, Integer status, String phone, String realName, String userType, String domain, Integer pageNum, Integer pageSize) {
        domain = this.checkAndGetDomain(domain);
        String querySql = "SELECT t3.id as userId, t3.id, t3.create_person, t3.create_time, t3.dr, t3.update_person, t3.update_time, t3.channel_code, t3.email, t3.invite_code, t3.inviter_name, t3.password, t3.phone, t3.register_time, t3.status, t3.user_name, t3.user_type, t3.valid_end_date, t3.valid_start_date, t3.organization_info_id, t3.nick_name, t3.person_id, t3.user_id, t3.tenant_id, t3.instance_id, t3.active_state, t3.user_name_uni_value, t3.phone_uni_value, t3.email_uni_value, t4.address, t4.birthday, t4.city, t4.company, t4.district, t4.identity_card, t4.photo_url, t4.position, t4.province, t4.real_name, t4.sex, t4.avatar, t4.extension, t4.industry FROM us_user t3 inner join us_personal_info t4 on t3.person_id=t4.id";
        StringBuilder whereSb = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        whereSb.append(" AND t3.dr = 0 ");
        if (orgId != null) {
            whereSb.append("and t3.id in ( select t2.user_id from  us_employee t2 inner join us_r_employee_organization t1 on t2.id=t1.employee_id where t3.id=t2.user_id and t1.organization_id =:orgId )");
            params.put("orgId", orgId);
        } else {
            whereSb.append("and t3.id in ( select t2.user_id from  us_employee t2 inner join us_r_employee_organization t1 on t2.id=t1.employee_id where t3.id=t2.user_id )");
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            whereSb.append("AND t3.`user_name` like :userName ");
            params.put("userName", "%" + userName + "%");
        }
        if (status != null) {
            whereSb.append("AND t3.`status` = :status ");
            params.put("status", status);
        }
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            whereSb.append("AND t3.`phone` like :phone ");
            params.put("phone", "%" + phone + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)realName)) {
            whereSb.append("AND t4.`real_name` like :realName ");
            params.put("realName", "%" + realName + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)userType)) {
            whereSb.append("AND t3.`user_type` = :userType ");
            params.put("userType", Integer.parseInt(userType));
        }
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            whereSb.append("AND t3.`domain` = :domain ");
            params.put("domain", domain);
        }
        String whereSql = whereSb.toString();
        if (pageNum < 1) {
            pageNum = 1;
        }
        querySql = querySql + whereSql + " order by t3.id desc limit " + (pageNum - 1) * pageSize + "," + (pageSize + 1);
        this.logger.info("SQL:{}", (Object)querySql);
        List list = this.namedParameterJdbcTemplate.queryForList(querySql, params);
        Boolean hashNext = false;
        if (list.size() > pageSize) {
            hashNext = true;
            list.remove(list.size() - 1);
        }
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setHasNextPage(hashNext.booleanValue());
        pageInfo.setIsLastPage(hashNext == false);
        return pageInfo;
    }

    @Override
    public PageInfo<Map<String, Object>> findUserInfoList(Long orgId, String userName, Integer status, String phone, String realName, String userType, String filter, Integer pageNum, Integer pageSize) {
        Criteria criteria = (Criteria)ObjectHelper.Json2Bean((String)filter, Criteria.class);
        String querySql = "SELECT t3.id as userId, t3.id, t3.tenant_id, t3.instance_id, t3.user_id, t3.person_id, t3.password, t3.user_type, t5.name as `user_name`, t5.nick_name, t5.phone_num as `phone`, t5.email, t3.active_state, t3.status, t3.invite_code, t3.inviter_name, t3.register_time, t3.channel_code, t5.device_id, t5.busicode, t5.register_time, t5.organization_id, t5.member_id, t3.valid_start_date, t3.valid_end_date, t3.organization_info_id,  t3.create_person, t3.create_time, t3.update_person, t3.update_time, t3.dr, t3.user_name_uni_value, t3.phone_uni_value, t3.email_uni_value, t4.address, t4.birthday, t4.city, t4.company, t4.district, t4.identity_card, t4.photo_url, t4.position, t4.province, t4.real_name, t4.sex, t4.avatar, t4.extension, t4.industry FROM us_user t3 inner join us_employee t5 on t5.user_id = t3.id inner join us_personal_info t4 on t4.id = t3.person_id  inner join us_r_employee_organization t1 on  t5.id = t1.employee_id and t1.organization_id = :orgId";
        StringBuilder whereSb = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        whereSb.append(" AND t3.dr = 0 ");
        params.put("orgId", orgId);
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            whereSb.append("AND t5.name like :userName ");
            params.put("userName", "%" + userName + "%");
        }
        if (status != null) {
            whereSb.append("AND t3.`status` = :status ");
            params.put("status", status);
        }
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            whereSb.append("AND t5.phone_num like :phone ");
            params.put("phone", "%" + phone + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)realName)) {
            whereSb.append("AND t4.`real_name` like :realName ");
            params.put("realName", "%" + realName + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)userType)) {
            whereSb.append("AND t3.`user_type` = :userType ");
            params.put("userType", Integer.parseInt(userType));
        }
        String domain = null;
        List<SqlFilter> sqlFilters = criteria.getFilters();
        for (SqlFilter sqlFilter : sqlFilters) {
            if (sqlFilter.getProperty().equals("batch")) {
                whereSb.append("AND t3.batch = :batch ");
                params.put("batch", sqlFilter.getValue().toString());
            }
            if (!sqlFilter.getProperty().equals("domain")) continue;
            domain = sqlFilter.getValue().toString();
        }
        if (StringUtils.isNotBlank((CharSequence)(domain = this.checkAndGetDomain(domain)))) {
            whereSb.append("AND t3.`domain` = :domain ");
            params.put("domain", domain);
        }
        String whereSql = whereSb.toString();
        if (pageNum < 1) {
            pageNum = 1;
        }
        querySql = querySql + whereSql + " order by t3.id desc limit " + (pageNum - 1) * pageSize + "," + (pageSize + 1);
        this.logger.info("SQL:{}", (Object)querySql);
        List list = this.namedParameterJdbcTemplate.queryForList(querySql, params);
        Boolean hashNext = false;
        if (list.size() > pageSize) {
            hashNext = true;
            list.remove(list.size() - 1);
        }
        PageInfo pageInfo = new PageInfo(list);
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setHasNextPage(hashNext.booleanValue());
        pageInfo.setIsLastPage(hashNext == false);
        return pageInfo;
    }

    private String checkAndGetDomain(String domain) {
        if (StringUtils.isBlank((CharSequence)domain)) {
            Long instanceId = this.context.instanceId();
            Long tenantId = this.context.tenantId();
            AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
            AssertUtil.isTrue(null != appInstanceEo, "\u5e94\u7528\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            tenantId = tenantId == null ? appInstanceEo.getTenantId() : tenantId;
            AssertUtil.isTrue(null != tenantId, "\u7528\u6237\u6240\u5c5e\u7684\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appInstanceEo.getDefDomain()})) {
                return appInstanceEo.getDefDomain();
            }
            TenantEo tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId);
            AssertUtil.isTrue(null != tenantEo, "\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tenantEo.getDefDomain()}), "\u5e10\u53f7\u57df\u4fe1\u606f\u4e0d\u5b58\u5728");
            return tenantEo.getDomain();
        }
        Long instanceId = this.context.instanceId();
        HashSet domainList = Sets.newHashSet();
        AppInstanceEo eo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (eo == null) {
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)eo.getDefDomain())) {
            domainList.add(eo.getDefDomain());
        }
        if (StringUtils.isNotBlank((CharSequence)eo.getTrustDomain())) {
            String[] trustDomainArray = eo.getTrustDomain().split(",");
            domainList.addAll(Arrays.asList(trustDomainArray));
        }
        if (CollectionUtils.isNotEmpty((Collection)domainList) && !domainList.contains(domain)) {
            throw new BizException(UserExceptionCode.INVALID_USER_DOMAIN.getCode(), UserExceptionCode.INVALID_USER_DOMAIN.getMsg());
        }
        return domain;
    }

    @Override
    public PageInfo<Map<String, Object>> findUserInfoList(String userName, Integer status, String realName, Long orgId, String orgName, String position, String domain, Long instanceId, Integer pageNum, Integer pageSize) {
        domain = this.checkAndGetDomain(domain);
        return this.userExtDas.queryUserInfoList(userName, status, realName, orgId, orgName, position, domain, instanceId, pageNum, pageSize);
    }

    @Override
    public UserDto queryUserByIdIgnoreDr(Long userId, String[] res) {
        UserEo userEo = this.userExtDas.queryByIdIgnoreDr(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        UserDto userDto = new UserDto();
        DtoHelper.eo2Dto((BaseEo)userEo, (BaseVo)userDto);
        if (res == null) {
            return userDto;
        }
        List<String> items = Arrays.asList(res);
        if (items.contains("address")) {
            List<AddressDto> addressDtos = this.personalInfoService.queryAddressByUserId(userId);
            userDto.setAddressList(addressDtos);
        }
        if (items.contains("personInfo") && userEo.getPersonId() != null) {
            PersonalInfoEo personalInfoEo = (PersonalInfoEo)this.personalInfoDas.selectByPrimaryKey(userEo.getPersonId());
            PersonalInfoDto personalInfoDto = null;
            if (personalInfoEo != null) {
                personalInfoDto = new PersonalInfoDto();
                DtoHelper.eo2Dto((BaseEo)personalInfoEo, (BaseVo)personalInfoDto);
                personalInfoDto.setUserId(userId);
            }
            userDto.setPersonalInfo(personalInfoDto);
        }
        if (items.contains("role")) {
            List<RoleDto> roleDtos = this.roleService.queryByUserId(userId);
            HashSet roleDtoSet = Sets.newHashSet();
            roleDtoSet.addAll(roleDtos);
            userDto.setRoleSet((Set)roleDtoSet);
        }
        if (items.contains("billInfo")) {
            List billInfoEo = this.billInfoDas.findByUserId(userId);
            ArrayList billInfoDto = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)billInfoEo)) {
                DtoHelper.eoList2DtoList((Collection)billInfoEo, billInfoDto, BillInfoDto.class);
            }
            userDto.setBillInfoList(billInfoDto);
        }
        return userDto;
    }

    @Override
    public List<UserRespDto> queryUserByUserNames(UserQueryReqDto userQueryReqDto) {
        if (CollectionUtils.isEmpty((Collection)userQueryReqDto.getUserNames())) {
            return Lists.newArrayList();
        }
        UserEo userEo = new UserEo();
        CubeBeanUtils.copyProperties((Object)userEo, (Object)userQueryReqDto, (String[])new String[]{"userName"});
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"user_name", (Object)userQueryReqDto.getUserNames()));
        userEo.setSqlFilters((List)sqlFilters);
        List userEos = this.userExtDas.select((BaseEo)userEo);
        ArrayList<UserRespDto> userRespDtos = new ArrayList<UserRespDto>();
        CubeBeanUtils.copyCollection(userRespDtos, (Collection)userEos, UserRespDto.class);
        return userRespDtos;
    }
}

