/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.Pair;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.cube.utils.bean.RegexUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.constant.InstanceChannelEnum;
import com.dtyunxi.yundt.cube.center.user.api.constant.ThirdPlatform;
import com.dtyunxi.yundt.cube.center.user.api.constant.ThirdQueryType;
import com.dtyunxi.yundt.cube.center.user.api.constant.ValidTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BillInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.BindingsDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ImportUsersDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.PersonalInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.TableExtraPropertyDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.TenantDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserEmployeeQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserGroupDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.GiveRolesReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.UserModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.request.UserQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.TenantManagerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.UserAppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.UserRoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ext.user.UserUniqueCheckDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.ext.user.UserUniqueCheckStrategyDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AddressQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.BindingsQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.TenantManagerCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ThirdBindingQueryReq;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ThirdPartyUserReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserEmployeeQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserInstanceRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.BindingsQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.ImportUserResult;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserVo;
import com.dtyunxi.yundt.cube.center.user.api.exception.UserExceptionCode;
import com.dtyunxi.yundt.cube.center.user.biz.condition.Criteria;
import com.dtyunxi.yundt.cube.center.user.biz.constant.IdentityConstants;
import com.dtyunxi.yundt.cube.center.user.biz.constant.UserConstants;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAbacAttrApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IInstanceRelationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPasswordService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IPersonalInfoService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.ITableExtraPropertyService;
import com.dtyunxi.yundt.cube.center.user.biz.service.ITenantService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserAppInstanceService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserRelationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.service.impl.TenantServiceImpl;
import com.dtyunxi.yundt.cube.center.user.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.biz.utils.PageInfoUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AddressDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ApplicationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.BillInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.BindingsDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ContactsInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.GroupUserRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.LoginConfigDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.PersonalInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RegisterConfigDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.TableExtraPropertyDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.TenantDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDomainDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserGroupDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AddressEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ApplicationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.BindingsEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ContactsInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.GroupUserRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.LoginConfigEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.PersonalInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RegisterConfigEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdBindingsEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdLoginConfigEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdUserDomainEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdUserRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.TableExtraPropertyEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.TenantEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserGroupEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.ext.user.IAfterAddUserExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IAfterBatchAddUserExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IAfterBatchDeleteUserExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IAfterDeleteUserExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IUserInfoVerificationExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IUserModifyRestrictExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IUserUniqueRestrictStrategyExt;
import com.dtyunxi.yundt.cube.center.user.ext.user.IUserUniquenessExt;
import com.dtyunxi.yundt.cube.center.user.param.AccountValidTimeParam;
import com.dtyunxi.yundt.cube.center.user.param.PasswordValidTimeParam;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.context.common.config.AppRecognitionConfig;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class UserServiceImpl
implements IUserService {
    @Value(value="${verify.username:true}")
    private Boolean verifyUserName;
    @Autowired
    private UserDas userDas;
    @Autowired
    private TenantDas tenantDas;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private BillInfoDas billInfoDas;
    @Autowired
    private ContactsInfoDas contactsInfoDas;
    @Autowired
    private IUserRelationService userRelationService;
    @Autowired
    private LoginConfigDas loginConfigDas;
    @Autowired
    private UserRoleRelationDas userRoleRelationDas;
    @Autowired
    private IPersonalInfoService personalInfoService;
    @Autowired
    private PersonalInfoDas personalInfoDas;
    @Autowired
    private ITableExtraPropertyService tableExtraPropertyService;
    @Autowired
    private ApplicationDas applicationDas;
    @Resource
    private BindingsDas bindingsDas;
    @Resource
    private GroupUserRelationDas groupUserRelationDas;
    @Resource
    private UserGroupDas userGroupDas;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Autowired
    private RoleDas roleDas;
    @Resource
    private UserDomainDas userDomainDas;
    @Autowired
    private RegisterConfigDas registerConfigDas;
    @Resource
    private IApplicationService applicationService;
    @Resource
    private IPasswordService passwordService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private TableExtraPropertyDas tableExtraPropertyDas;
    @Resource
    private IUserGroupService userGroupService;
    @Autowired
    private IUserInfoVerificationExt userInfoVerificationExt;
    @Resource
    private ITenantService tenantService;
    @Resource
    private IAccessService accessService;
    @Autowired
    private IUserUniquenessExt<Boolean, UserUniqueCheckDto> userUniquenessExt;
    @Autowired
    private IUserUniqueRestrictStrategyExt<Map<String, String>, UserUniqueCheckStrategyDto> userUniqueRestrictStrategyExt;
    @Autowired
    private IAfterDeleteUserExt<Boolean, UserEo> afterDeleteUserExt;
    @Autowired
    private IAfterBatchDeleteUserExt<Boolean, List<UserEo>> afterBatchDeleteUserExt;
    @Autowired
    private IAfterAddUserExt<Boolean, UserEo> afterAddUserExt;
    @Autowired
    private IAfterBatchAddUserExt<Boolean, Pair<List<UserEo>, List<ImportUsersDto>>> afterBatchAddUserExt;
    @Autowired
    private IUserModifyRestrictExt<UserEo, UserDto> userModifyRestrictExt;
    @Resource
    private IContext context;
    @Autowired
    private AddressDas addressDas;
    @Resource
    private IUserAppInstanceService userAppInstanceService;
    @CubeResource
    private AccountValidTimeParam accountValidTimeParam;
    @CubeResource
    private PasswordValidTimeParam passwordValidTimeParam;
    @Resource
    private IInstanceRelationService instanceRelationService;
    @Autowired
    private AppRecognitionConfig appRecognitionConfig;
    @Resource
    private IAbacAttrApplicationService abacAttrApplicationService;
    @Value(value="${user.empty.salt.generate.enabled:true}")
    private boolean emptySaltGenerate;
    @Value(value="${dtyunxi.user.password.masked:\u5bc6_\u7801_\u5df2_\u5c4f_\u853d}")
    private String maskPassword = "\u5bc6_\u7801_\u5df2_\u5c4f_\u853d";
    @Value(value="${dtyunxi.user.password.maskedAfterBase64:xn8BX/JfT989}")
    private String maskPasswordAfterBase64 = "xn8BX/JfT989";
    private static final String US_PERSON_INFO_ID = "US_PERSON_INFO_ID";
    private static final String US_USER_ID = "US_USER_ID";
    private static final String US_EMPLOYEE_ID = "US_EMPLOYEE_ID";
    private static final String DUPLICATED_EMPLOYEE_ID = "DUPLICATED_EMPLOYEE_ID";
    private static final String DUPLICATED_USER_ID = "DUPLICATED_USER_ID";
    private static final String OVERRIDE_TYPE = "overrideType";
    private static final int IMPORT_BATCH_USER_CHECK_FAILED = -1;
    private static final int IMPORT_BATCH_USER_CHECK_UPDATE = 0;
    private static final int IMPORT_BATCH_USER_CHECK_INSERT = 1;
    private static final String JSON_INSTANCE_ID = "instanceId";
    private Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean isValid(String loginStr, String password, Long instanceId, Long tenantId, String domain) {
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        AssertUtil.isTrue(null != appInstanceEo, "\u5e94\u7528\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        tenantId = tenantId == null ? appInstanceEo.getTenantId() : tenantId;
        AssertUtil.isTrue(null != tenantId, "\u7528\u6237\u6240\u5c5e\u7684\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        UserDto userDto = new UserDto();
        userDto.setDomain(domain);
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);
        domain = this.checkOrGetDomain(instanceId, userDto);
        List eoList = this.loginConfigDas.findByLoginKey(null, loginStr, tenantId, null, domain);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)eoList), "\u8be5\u767b\u5f55\u5b57\u6bb5\u4e0d\u5b58\u5728");
        List enabledEoList = eoList.stream().filter(loginConfigEo -> loginConfigEo.getStatus() != null && 1 == loginConfigEo.getStatus()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(enabledEoList)) {
            AssertUtil.isTrue(false, "\u8be5\u767b\u5f55\u5b57\u6bb5\u5df2\u88ab\u7981\u7528");
        }
        boolean isPasswordCorrect = false;
        for (LoginConfigEo loginConfigEo2 : enabledEoList) {
            UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(loginConfigEo2.getOwnerId());
            AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(1 == userEo.getStatus(), "\u8be5\u7528\u6237\u5df2\u88ab\u7981\u7528");
            if (!this.passwordService.encryptPassword(password, userEo.getSalt(), null, null).equals(userEo.getPassword())) continue;
            isPasswordCorrect = true;
        }
        return isPasswordCorrect;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public UserEo addUser(Long instanceId, UserDto userDto) {
        Set roleSet;
        UserEo inviteUser;
        String encryptPassWord = this.passwordService.RSAEncrypt(userDto.getPassword());
        userDto.setPassword(encryptPassWord);
        Long tenantId = userDto.getTenantId();
        if (null == tenantId) {
            tenantId = this.context.tenantId();
        }
        UserEo userEo = this.addUserSimple(instanceId, userDto, tenantId);
        String inviteCode = userDto.getInviteCode();
        Long userId = userEo.getId();
        if (StringUtils.isNotBlank((CharSequence)inviteCode) && instanceId != null && null != (inviteUser = this.userDas.findFirstByInviteCode(inviteCode))) {
            this.userRelationService.bindUserRelation(instanceId, inviteUser.getId(), userId, UserConstants.RelationType.INVITE.getCode());
        }
        if (userDto.getContactsInfo() != null) {
            ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
            DtoHelper.dto2Eo((BaseVo)userDto.getContactsInfo(), (BaseEo)contactsInfoEo);
            contactsInfoEo.setUserId(userId);
            contactsInfoEo.setTenantId(tenantId);
            contactsInfoEo.setInstanceId(instanceId);
            this.contactsInfoDas.insert((BaseEo)contactsInfoEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)userDto.getInstanceIds())) {
            UserInstanceRelationReqDto dto = new UserInstanceRelationReqDto();
            dto.setUserId(userId);
            dto.setInstanceIds(userDto.getInstanceIds());
            this.userAppInstanceService.addUserInstanceRelationAll(dto);
        }
        if ((roleSet = userDto.getRoleSet()) != null) {
            this.addUserRoles(userId, roleSet, instanceId, tenantId);
        }
        if (userDto.getPersonalInfo() != null) {
            PersonalInfoEo personalInfoEo = new PersonalInfoEo();
            DtoHelper.dto2Eo((BaseVo)userDto.getPersonalInfo(), (BaseEo)personalInfoEo);
            personalInfoEo.setInstanceId(instanceId);
            personalInfoEo.setTenantId(tenantId);
            this.personalInfoDas.insert((BaseEo)personalInfoEo);
            userEo.setPersonId(personalInfoEo.getId());
            UserEo updateUser = new UserEo();
            updateUser.setId(userEo.getId());
            updateUser.setPersonId(personalInfoEo.getId());
            this.userDas.updateSelective((BaseEo)updateUser);
        }
        this.addLoginConfig(userDto, userEo);
        this.afterAddUserExt.execute((Object)userEo);
        return userEo;
    }

    @Override
    public void addUserRoles(Long userId, Set<RoleDto> roleSet, Long instanceId, Long tenantId) {
        UserRoleRelationEo relateEo;
        RoleEo roleEo;
        ArrayList userRoleList = Lists.newArrayList();
        boolean appendMpcTenantAdmin = false;
        boolean appendBocTenantAdmin = false;
        AppInstanceDto appInstanceDto = this.applicationService.queryInstanceOne(instanceId);
        String appCode = appInstanceDto.getCode();
        for (RoleDto roleDto : roleSet) {
            if (roleDto == null) continue;
            UserRoleRelationEo userRoleEo = this.packRoleReqDto2Eo(roleDto, instanceId);
            userRoleEo.setUserId(userId);
            userRoleEo.setTenantId(tenantId);
            userRoleEo.setInstanceId(instanceId);
            userRoleEo.setExtension("");
            userRoleList.add(userRoleEo);
            if ("TENANT_ADMIN".equals(userRoleEo.getRoleCode())) {
                appendBocTenantAdmin = true;
            }
            if (!"BOCMANAGER".equals(userRoleEo.getRoleCode())) continue;
            appendMpcTenantAdmin = true;
        }
        if (appendMpcTenantAdmin) {
            roleEo = this.roleService.queryRole(tenantId, "MPC", "TENANT_ADMIN");
            relateEo = new UserRoleRelationEo();
            relateEo.setRoleCode(roleEo.getCode());
            relateEo.setRoleId(roleEo.getId());
            relateEo.setInstanceId(roleEo.getInstanceId());
            relateEo.setUserId(userId);
            relateEo.setTenantId(tenantId);
            relateEo.setExtension("");
            userRoleList.add(relateEo);
        }
        if (appendBocTenantAdmin) {
            roleEo = this.roleService.queryRole(tenantId, "BOC", "BOCMANAGER");
            relateEo = new UserRoleRelationEo();
            relateEo.setRoleCode(roleEo.getCode());
            relateEo.setRoleId(roleEo.getId());
            relateEo.setInstanceId(roleEo.getInstanceId());
            relateEo.setUserId(userId);
            relateEo.setTenantId(tenantId);
            relateEo.setExtension("");
            userRoleList.add(relateEo);
        }
        Map<Long, UserRoleRelationEo> code2EoMap = userRoleList.stream().distinct().collect(Collectors.toMap(StdUserRoleRelationEo::getRoleId, Function.identity()));
        UserAccessVo userAccessVo = this.accessService.queryUserAccess(instanceId, userId);
        userAccessVo.getRoleSet().stream().filter(source -> code2EoMap.containsKey(source.getId())).forEach(source -> code2EoMap.remove(source.getId()));
        this.accessService.beforeAddUserRoleExtHandle(instanceId, userId);
        this.addUserRole(code2EoMap);
        this.accessService.afterAddUserRoleExtHandle(instanceId, userId);
    }

    private void addUserRole(Map<Long, UserRoleRelationEo> code2EoMap) {
        if (CollectionUtil.isNotEmpty(code2EoMap)) {
            for (UserRoleRelationEo userRoleRelationEo : code2EoMap.values()) {
                this.userRoleRelationDas.insert((BaseEo)userRoleRelationEo);
            }
        }
    }

    private UserRoleRelationEo packRoleReqDto2Eo(RoleDto roleDto, Long instanceId) {
        RoleEo roleEo;
        Long roleId = roleDto.getId();
        String roleCode = roleDto.getCode();
        if (roleId == null && StringUtils.isBlank((CharSequence)roleCode)) {
            throw new BizException(UserExceptionCode.ROLE_ID_INPUT_EMPTY.getCode(), UserExceptionCode.ROLE_ID_INPUT_EMPTY.getMsg());
        }
        UserRoleRelationEo userRoleEo = new UserRoleRelationEo();
        if (roleId == null) {
            RoleEo roleEo2 = this.roleDas.findFirstByCodeAndInstanceId(roleDto.getCode(), instanceId);
            if (roleEo2 != null) {
                roleId = roleEo2.getId();
            }
        } else if (StringUtils.isBlank((CharSequence)roleCode) && (roleEo = (RoleEo)this.roleDas.selectByPrimaryKey(roleId)) != null) {
            roleCode = roleEo.getCode();
        }
        userRoleEo.setRoleId(roleId);
        userRoleEo.setRoleCode(roleCode);
        userRoleEo.setExtension("");
        return userRoleEo;
    }

    private UserEo addUserSimple(Long instanceId, UserDto userDto, Long tenantId) {
        String domain = this.checkOrGetDomain(instanceId, userDto);
        userDto.setDomain(domain);
        String userName = userDto.getUserName();
        userName = StringUtils.isNotBlank((CharSequence)userName) ? userName : this.generateUserName();
        Boolean isCheck = this.verifyUserName;
        if (null != userDto.getExtFields() && null != userDto.getExtFields().get("verifyUserName")) {
            isCheck = (Boolean)userDto.getExtFields().get("verifyUserName");
        }
        if (isCheck.booleanValue()) {
            this.validUserName(userName);
        }
        AssertUtil.isTrue(null != userName, "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        userDto.setUserName(userName);
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);
        userDto.setAccount(this.generateAccount());
        this.checkUserUnique(userDto);
        UserEo userEo = new UserEo();
        DtoHelper.dto2Eo((BaseVo)userDto, (BaseEo)userEo, (String[])new String[]{"inviteCode"});
        userEo.setInstanceId(instanceId);
        userEo.setDr(0);
        userEo.setStatus(Integer.valueOf(1));
        if (null != userEo.getPassword()) {
            if (StringUtils.isBlank((CharSequence)userEo.getSalt()) && this.emptySaltGenerate) {
                userEo.setSalt(UUID.randomUUID().toString());
            }
            String md5Password = this.passwordService.encryptPassword(userEo.getPassword(), userEo.getSalt(), tenantId, instanceId);
            userEo.setPassword(md5Password);
        }
        userEo.setTenantId(tenantId);
        userEo.setRegisterTime(new Date());
        this.setUserEo(userDto, userEo);
        this.userDas.insert((BaseEo)userEo);
        return userEo;
    }

    private void setUserEo(UserDto userDto, UserEo userEo) {
        if (ValidTypeEnum.TEMP.getCode().equals(userDto.getValidType())) {
            if ((userDto.getValidStartDate() == null || userDto.getValidEndDate() == null) && this.accountValidTimeParam.getValue() != null && (Integer)this.accountValidTimeParam.getValue() > 0) {
                Date validStartDate = new Date();
                Date validEndDate = DateUtil.addHours((Date)validStartDate, (int)((Integer)this.accountValidTimeParam.getValue()));
                userEo.setValidStartDate(validStartDate);
                userEo.setValidEndDate(validEndDate);
            }
        } else {
            userEo.setValidType(ValidTypeEnum.NORMAL.getCode());
        }
        userEo.setModifyPasswordTime(new Date());
    }

    private String checkOrGetDomain(Long instanceId, UserDto userDto) {
        String domain = userDto.getDomain();
        if (StringUtils.isBlank((CharSequence)domain) && null != userDto.getExtFields() && null != userDto.getExtFields().get("domain")) {
            domain = (String)userDto.getExtFields().get("domain");
        }
        return this.checkOrGetDomain(instanceId, userDto.getTenantId(), domain);
    }

    private String checkOrGetDomain(Long instanceId, Long tenantId, String domain) {
        instanceId = instanceId == null ? ServiceContext.getContext().getRequestInstanceId() : instanceId;
        Long l = tenantId = tenantId == null ? ServiceContext.getContext().getRequestTenantId() : tenantId;
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            Set<String> domainList = this.getAppInstanceAvailableDomain(instanceId);
            if (CollectionUtils.isNotEmpty(domainList) && !domainList.contains(domain)) {
                throw new BizException(UserExceptionCode.INVALID_USER_DOMAIN.getCode(), UserExceptionCode.INVALID_USER_DOMAIN.getMsg());
            }
        } else {
            AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
            String string = domain = appInstanceEo != null ? appInstanceEo.getDefDomain() : null;
            if (StringUtils.isBlank((CharSequence)domain)) {
                TenantEo tenantEo;
                if (null == tenantId) {
                    tenantId = appInstanceEo != null ? appInstanceEo.getTenantId() : this.context.tenantId();
                }
                domain = (tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId)) != null ? tenantEo.getDefDomain() : null;
                AssertUtil.isTrue(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{domain}), "\u5e10\u53f7\u57df\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
        }
        return domain;
    }

    private String checkOrGetDomainWithAppInstanceEo(AppInstanceEo appInstanceEo, UserDto userDto) {
        Long tenantId = userDto.getTenantId();
        String domain = userDto.getDomain();
        if (StringUtils.isBlank((CharSequence)domain) && null != userDto.getExtFields() && null != userDto.getExtFields().get("domain")) {
            domain = (String)userDto.getExtFields().get("domain");
        }
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            Set<String> domainList;
            Set<String> set = domainList = appInstanceEo != null ? this.getAppInstanceAvailableDomain(appInstanceEo) : this.getTenantAvailableDomain(tenantId);
            if (CollectionUtils.isNotEmpty(domainList) && !domainList.contains(domain)) {
                throw new BizException(UserExceptionCode.INVALID_USER_DOMAIN.getCode(), UserExceptionCode.INVALID_USER_DOMAIN.getMsg());
            }
        } else {
            String string = domain = appInstanceEo != null ? appInstanceEo.getDefDomain() : null;
            if (StringUtils.isBlank((CharSequence)domain)) {
                TenantEo tenantEo;
                if (tenantId == null) {
                    Long l = tenantId = appInstanceEo != null ? appInstanceEo.getTenantId() : this.context.tenantId();
                }
                if ((tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId)) != null) {
                    domain = tenantEo.getDefDomain();
                }
                if (StringUtils.isBlank((CharSequence)domain)) {
                    throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), "\u5e10\u53f7\u57df\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
            }
        }
        return domain;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public UserEo addUserWithSalt(Long instanceId, UserDto userDto) {
        return this.addUserWithEncryptedPasswd(instanceId, userDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public UserEo addUserWithEncryptedPasswd(Long instanceId, UserDto userDto) {
        UserEo inviteUser;
        String domain = this.checkOrGetDomain(instanceId, userDto);
        userDto.setDomain(domain);
        Long tenantId = userDto.getTenantId();
        String userName = userDto.getUserName();
        userName = StringUtils.isNotBlank((CharSequence)userName) ? userName : this.generateUserName();
        Boolean isCheck = this.verifyUserName;
        if (null != userDto.getExtFields() && null != userDto.getExtFields().get("verifyUserName")) {
            isCheck = (Boolean)userDto.getExtFields().get("verifyUserName");
        }
        if (isCheck.booleanValue()) {
            this.validUserName(userName);
        }
        AssertUtil.isTrue(null != userName, "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        userDto.setUserName(userName);
        userDto.setTenantId(tenantId);
        userDto.setInstanceId(instanceId);
        userDto.setAccount(this.generateAccount());
        UserEo userEo = new UserEo();
        DtoHelper.dto2Eo((BaseVo)userDto, (BaseEo)userEo, (String[])new String[]{"inviteCode"});
        if (userDto.getId() != null && this.userDas.selectByPrimaryKey(userDto.getId()) != null) {
            userEo.setId(userDto.getId());
            this.userDas.updateSelective((BaseEo)userEo);
            return userEo;
        }
        this.checkUserUnique(userDto);
        userEo.setInstanceId(instanceId);
        userEo.setDr(0);
        userEo.setStatus(Integer.valueOf(1));
        userEo.setTenantId(tenantId);
        if (userDto.getRegisterTime() == null) {
            userEo.setRegisterTime(new Date());
        }
        this.setUserEo(userDto, userEo);
        this.userDas.insert((BaseEo)userEo);
        String inviteCode = userDto.getInviteCode();
        if (StringUtils.isNotBlank((CharSequence)inviteCode) && instanceId != null && null != (inviteUser = this.userDas.findFirstByInviteCode(inviteCode))) {
            this.userRelationService.bindUserRelation(instanceId, inviteUser.getId(), userEo.getId(), UserConstants.RelationType.INVITE.getCode());
        }
        if (userDto.getContactsInfo() != null) {
            ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
            DtoHelper.dto2Eo((BaseVo)userDto.getContactsInfo(), (BaseEo)contactsInfoEo);
            contactsInfoEo.setUserId(userEo.getId());
            contactsInfoEo.setTenantId(tenantId);
            this.contactsInfoDas.insert((BaseEo)contactsInfoEo);
        }
        if (userDto.getRoleSet() != null) {
            ArrayList userRoleList = Lists.newArrayList();
            for (RoleDto roleDto : userDto.getRoleSet()) {
                UserRoleRelationEo userRoleEo = new UserRoleRelationEo();
                AssertUtil.isTrue(roleDto.getId() != null, UserExceptionCode.ROLE_ID_INPUT_EMPTY.getCode(), UserExceptionCode.ROLE_ID_INPUT_EMPTY.getMsg(), new Object[0]);
                userRoleEo.setUserId(userEo.getId());
                userRoleEo.setRoleId(roleDto.getId());
                userRoleEo.setTenantId(tenantId);
                userRoleEo.setInstanceId(instanceId);
                userRoleEo.setExtension("");
                userRoleList.add(userRoleEo);
            }
            this.userRoleRelationDas.insertBatch((List)userRoleList);
        }
        if (userDto.getPersonalInfo() != null) {
            PersonalInfoEo personalInfoEo = new PersonalInfoEo();
            personalInfoEo.setInstanceId(instanceId);
            personalInfoEo.setTenantId(tenantId);
            DtoHelper.dto2Eo((BaseVo)userDto.getPersonalInfo(), (BaseEo)personalInfoEo);
            this.personalInfoDas.insert((BaseEo)personalInfoEo);
            userEo.setPersonId(personalInfoEo.getId());
            this.userDas.update((BaseEo)userEo);
        }
        this.addLoginConfig(userDto, userEo);
        return userEo;
    }

    @Override
    public UserEo addTenantManager(TenantManagerCreateReqDto tenantManagerCreateReqDto) {
        return this.addTenantAdmin(tenantManagerCreateReqDto);
    }

    private UserEo addTenantAdmin(TenantManagerCreateReqDto tenantManagerCreateReqDto) {
        UserDto userDto = new UserDto();
        CubeBeanUtils.copyProperties((Object)userDto, (Object)tenantManagerCreateReqDto, (String[])new String[0]);
        userDto.setRoleSet(new HashSet());
        ApplicationEo applicationEo = this.applicationDas.selectByCode("BOC");
        AppInstanceEo boc = new AppInstanceEo();
        boc.setApplicationId(applicationEo.getId());
        boc.setTenantId(tenantManagerCreateReqDto.getTenantId());
        List bocApp = this.appInstanceDas.select((BaseEo)boc);
        if (CollectionUtils.isEmpty((Collection)bocApp)) {
            throw new BizException("\u5f53\u524d\u79df\u6237\u6ca1\u6709boc\u5e94\u7528, \u8bf7\u4e3a\u8be5\u79df\u6237\u521b\u5efaboc\u5e94\u7528");
        }
        boc = (AppInstanceEo)bocApp.get(0);
        RoleDto manger = new RoleDto();
        manger.setCode("BOCMANAGER");
        userDto.getRoleSet().add(manger);
        Long instanceId = boc.getId();
        UserEo userEo = this.addUser(instanceId, userDto);
        this.addTenantAdminRole(tenantManagerCreateReqDto.getTenantId(), userEo.getId());
        return userEo;
    }

    private void addTenantAdminRole(Long tenantId, Long userId) {
        AppInstanceEo queryEo = new AppInstanceEo();
        queryEo.setTenantId(tenantId);
        queryEo.setCode("MPC");
        queryEo.setStatus(Integer.valueOf(1));
        List list = this.appInstanceDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            AppInstanceEo mpc = (AppInstanceEo)list.get(0);
            RoleEo roleQueryEo = new RoleEo();
            roleQueryEo.setInstanceId(mpc.getId());
            roleQueryEo.setCode("TENANT_ADMIN");
            roleQueryEo.setStatus(Integer.valueOf(1));
            List roleList = this.roleDas.select((BaseEo)roleQueryEo);
            if (CollectionUtils.isNotEmpty((Collection)roleList)) {
                RoleEo roleEo = (RoleEo)roleList.get(0);
                ArrayList roleIdList = Lists.newArrayList();
                roleIdList.add(roleEo.getId());
                this.accessService.giveUserRole(mpc.getId(), userId, roleIdList);
            }
        }
    }

    private void validUserName(String userName) {
        if (userName == null) {
            return;
        }
        boolean valid = RegexUtils.isUsername((String)userName);
        AssertUtil.isTrue(valid, "\u7528\u6237\u540d\u683c\u5f0f\u4e0d\u6b63\u786e");
    }

    private void checkUserUnique(UserDto userDto) {
        String[][] checkColumnAy;
        Long instanceId = userDto.getInstanceId();
        if (!this.isIsolationByInstance(userDto.getTenantId())) {
            instanceId = null;
        } else {
            AssertUtil.isTrue(userDto.getInstanceId() != null, "\u6ce8\u518c\u7528\u6237\u6240\u5c5e\u7684\u5e94\u7528\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String[] checkColumn : checkColumnAy = new String[][]{{"userName", "\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c!"}, {"phone", "\u624b\u673a\u53f7\u7801\u5df2\u88ab\u6ce8\u518c!"}, {"email", "\u90ae\u4ef6\u5730\u5740\u5df2\u88ab\u6ce8\u518c!"}}) {
            String column = checkColumn[0];
            Object value = null;
            try {
                value = PropertyUtils.getProperty((Object)userDto, (String)column);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean exist = (Boolean)this.userUniquenessExt.execute((Object)UserUniqueCheckDto.initDomainAndWithoutTenantIsolation((Long)userDto.getTenantId(), (Long)instanceId, (Long)userDto.getId(), (String)column, (Object)value, (String)userDto.getDomain()));
            AssertUtil.isTrue(!exist, checkColumn[1]);
        }
    }

    @Override
    public boolean isIsolationByInstance(Long tenantId) {
        AssertUtil.isTrue(tenantId != null, "\u7528\u6237\u6240\u5c5e\u7684\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        RegisterConfigEo registerConfigEo = this.registerConfigDas.findConfigByTenantId(tenantId);
        return registerConfigEo != null && registerConfigEo.getIsolationType().equals(UserConstants.ISOLATION_TYPE_INSTANCE);
    }

    @Override
    public boolean checkUserUnique(String column, Object value) {
        return (Boolean)this.userUniquenessExt.execute((Object)UserUniqueCheckDto.initWithoutTenantIsolation(null, null, null, (String)column, (Object)value));
    }

    @Override
    public UserEo findByUserName(String userName, Long tenantId, Long instanceId) {
        AssertUtil.isTrue(null != userName, "userName \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.userDas.findByUserName(userName, tenantId, instanceId, null);
    }

    @Override
    public PageInfo<UserEo> query(UserEo queryEo, Integer pageNum, Integer pageSize) {
        return this.userDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
    }

    @Override
    public List<UserAppInstanceDto> queryInstanceByTenantId(Long tenantId, Long userId) {
        List<AppInstanceDto> appInstanceDtoList;
        ArrayList userAppInstanceDtoList = Lists.newArrayList();
        List<Object> userAuthInstanceList = Lists.newArrayList();
        if (userId != null) {
            userAuthInstanceList = this.queryUserAuthInstanceList(userId);
        }
        if (CollectionUtils.isNotEmpty(appInstanceDtoList = this.applicationService.queryAppInstanceByTenantId(tenantId))) {
            Set<Long> instanceIdSet;
            Map<Long, String> hostnameReplaceMap;
            String curReqSiteName;
            for (AppInstanceDto appInstanceDto : appInstanceDtoList) {
                if ("MPC".equals(appInstanceDto.getCode()) || ObjectUtil.equal((Object)InstanceChannelEnum.PARTNER.getKey(), (Object)appInstanceDto.getInstanceChannel())) continue;
                UserAppInstanceDto userAppInstanceDto = new UserAppInstanceDto();
                CubeBeanUtils.copyProperties((Object)userAppInstanceDto, (Object)appInstanceDto, (String[])new String[0]);
                userAppInstanceDto.setIsRelated(Integer.valueOf(0));
                if (ObjectUtil.equal((Object)InstanceChannelEnum.SELF_BUILT.getKey(), (Object)appInstanceDto.getInstanceChannel()) && userAuthInstanceList.contains(appInstanceDto.getId())) {
                    userAppInstanceDto.setIsRelated(Integer.valueOf(1));
                }
                userAppInstanceDtoList.add(userAppInstanceDto);
            }
            if (CollectionUtils.isNotEmpty((Collection)userAppInstanceDtoList) && StringUtils.isNotBlank((CharSequence)(curReqSiteName = this.instanceRelationService.getHostName())) && (hostnameReplaceMap = this.instanceRelationService.queryHostnameBySiteName(instanceIdSet = userAppInstanceDtoList.stream().filter(dto -> dto.getIsRelated().equals(1)).map(AppInstanceDto::getId).collect(Collectors.toSet()), curReqSiteName)) != null && hostnameReplaceMap.size() > 0) {
                Iterator iter = userAppInstanceDtoList.iterator();
                while (iter.hasNext()) {
                    UserAppInstanceDto dto2 = (UserAppInstanceDto)iter.next();
                    if (!dto2.getIsRelated().equals(1)) continue;
                    String newHostName = hostnameReplaceMap.get(dto2.getId());
                    if (newHostName == null) {
                        iter.remove();
                        continue;
                    }
                    dto2.setHostName(newHostName);
                }
            }
        }
        return userAppInstanceDtoList;
    }

    private UserAppInstanceDto toUserAppInstanceDto(AppInstanceDto dto, List<Long> userAuthInstanceList) {
        UserAppInstanceDto userAppInstanceDto = new UserAppInstanceDto();
        CubeBeanUtils.copyProperties((Object)userAppInstanceDto, (Object)dto, (String[])new String[0]);
        userAppInstanceDto.setIsRelated(Integer.valueOf(0));
        if (CollectionUtils.isNotEmpty(userAuthInstanceList) && userAuthInstanceList.contains(dto.getId())) {
            userAppInstanceDto.setIsRelated(Integer.valueOf(1));
        }
        return userAppInstanceDto;
    }

    @Override
    public List<Long> queryUserAuthInstanceList(Long userId) {
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        Assert.notNull((Object)userEo, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        ArrayList<Long> resultInstanceIds = new ArrayList(16);
        List<UserRoleRelationEo> relationEos = this.abacAttrApplicationService.getUserRoleRelationByUserAttr(userId, null);
        if (relationEos != null) {
            resultInstanceIds.addAll(relationEos.stream().map(BaseEo::getInstanceId).collect(Collectors.toList()));
        }
        ArrayList roleEoList = Lists.newArrayList();
        GroupUserRelationEo groupUserRelationEo = new GroupUserRelationEo();
        groupUserRelationEo.setUserId(userId);
        List groupUserRelationEoList = this.groupUserRelationDas.select((BaseEo)groupUserRelationEo);
        if (CollectionUtils.isNotEmpty((Collection)groupUserRelationEoList)) {
            for (GroupUserRelationEo eo : groupUserRelationEoList) {
                List userGroupRoleEoList;
                UserGroupEo userGroupEo = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(eo.getUserGroupId());
                if (userGroupEo == null || userGroupEo.getStatus() != null && userGroupEo.getStatus() != 1 || !CollectionUtils.isNotEmpty((Collection)(userGroupRoleEoList = this.roleDas.findByUserGroupId(userGroupEo.getId())))) continue;
                roleEoList.addAll(userGroupRoleEoList);
            }
        }
        resultInstanceIds.addAll(roleEoList.stream().map(BaseEo::getInstanceId).distinct().collect(Collectors.toList()));
        resultInstanceIds = resultInstanceIds.stream().distinct().collect(Collectors.toList());
        return resultInstanceIds;
    }

    @Override
    public PageInfo<UserDto> queryPage(String filter, Integer pageNum, Integer pageSize) {
        UserEo userCondition = QueryUtil.validateExampleAndReturn(filter, UserEo.class);
        if (userCondition.getTenantId() == null) {
            userCondition.setTenantId(ServiceContext.getContext().getRequestTenantId());
        }
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)userCondition.getUserName())) {
            filters.add(SqlFilter.like((String)"userName", (Object)("%" + userCondition.getUserName() + "%")));
            userCondition.setUserName(null);
        }
        if (StringUtils.isNotBlank((CharSequence)userCondition.getPhone())) {
            filters.add(SqlFilter.like((String)"phone", (Object)("%" + userCondition.getPhone() + "%")));
            userCondition.setPhone(null);
        }
        if (StringUtils.isNotBlank((CharSequence)userCondition.getEmail())) {
            filters.add(SqlFilter.like((String)"email", (Object)("%" + userCondition.getEmail() + "%")));
            userCondition.setEmail(null);
        }
        if (StringUtils.isNotBlank((CharSequence)userCondition.getNickName())) {
            filters.add(SqlFilter.like((String)"nickName", (Object)("%" + userCondition.getNickName() + "%")));
            userCondition.setNickName(null);
        }
        userCondition.setSqlFilters(filters);
        userCondition.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.userDas.selectPage((BaseEo)userCondition, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List eoList = eoPageInfo.getList();
        ArrayList<UserDto> userList = new ArrayList<UserDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, userList, UserDto.class);
        if (CollectionUtil.isEmpty((Collection)eoList)) {
            dtoPageInfo.setList(userList);
            return dtoPageInfo;
        }
        Set domainCodes = userList.stream().filter(e -> e.getDomain() != null).map(UserDto::getDomain).collect(Collectors.toSet());
        Map<String, String> domainMapping = this.userDomainDas.selectByCodes(domainCodes, userCondition.getTenantId()).stream().collect(Collectors.toMap(StdUserDomainEo::getCode, StdUserDomainEo::getName));
        userList.forEach(e -> {
            String domainName = (String)domainMapping.get(e.getDomain());
            if (StringUtils.isBlank((CharSequence)domainName) && "default".equals(e.getDomain())) {
                domainName = "\u5176\u5b83";
            }
            e.setDomainName(domainName);
            e.setPassword(null);
            e.setSalt(null);
        });
        Map<Long, PersonalInfoDto> personalInfoMap = this.getUserPersonalInfo(eoList);
        this.addUserPersonalInfo(userList, personalInfoMap);
        dtoPageInfo.setList(userList);
        return dtoPageInfo;
    }

    private Map<Long, PersonalInfoDto> getUserPersonalInfo(List<UserEo> eoList) {
        Map<Long, PersonalInfoDto> result = eoList.stream().filter(eo -> eo.getPersonId() != null).collect(Collectors.toMap(BaseEo::getId, eo -> {
            PersonalInfoEo personalInfoEo = (PersonalInfoEo)this.personalInfoDas.selectByPrimaryKey(eo.getPersonId());
            PersonalInfoDto personalInfoDto = new PersonalInfoDto();
            DtoHelper.eo2Dto((BaseEo)personalInfoEo, (BaseVo)personalInfoDto);
            return personalInfoDto;
        }));
        return result;
    }

    private void addUserPersonalInfo(List<UserDto> dtoList, Map<Long, PersonalInfoDto> personalInfoDtoMap) {
        dtoList.stream().filter(userDto -> personalInfoDtoMap.get(userDto.getId()) != null).forEach(userDto -> userDto.setPersonalInfo((PersonalInfoDto)personalInfoDtoMap.get(userDto.getId())));
    }

    @Override
    public PageInfo<UserDto> findByRoleCode(String filter, String roleCode, Integer pageNum, Integer pageSize) {
        List<UserEo> eoList;
        UserQueryReqDto userQueryReqDto = QueryUtil.validateExampleAndReturn(filter, UserQueryReqDto.class);
        List userIds = null;
        if (userQueryReqDto.getInstanceId() != null) {
            RoleDto roleDto = this.roleService.queryRoleByCodeOrName(userQueryReqDto.getInstanceId(), roleCode, null);
            List userEoList = this.userRoleRelationDas.selectUserByRoleId(roleDto.getId());
            if (CollectionUtils.isNotEmpty((Collection)userEoList)) {
                userIds = userEoList.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            }
            userQueryReqDto.setInstanceId(null);
        } else {
            userIds = this.userRoleRelationDas.queryUserIdsByRoleCode(roleCode);
        }
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            eoList = new ArrayList();
        } else {
            eoList = this.userDas.selectPageByRoleCode(userQueryReqDto, userIds, pageNum, pageSize);
            eoList.forEach(e -> {
                e.setPassword(null);
                e.setSalt(null);
            });
        }
        PageInfo eoPage = new PageInfo(eoList);
        PageInfo<UserDto> dtoPage = QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPage, UserDto.class);
        Map<Long, PersonalInfoDto> personalInfoMap = this.getUserPersonalInfo(eoList);
        this.addUserPersonalInfo(dtoPage.getList(), personalInfoMap);
        return dtoPage;
    }

    @Override
    public PageInfo<UserDto> findFuzzy(String filter, Integer pageNum, Integer pageSize) {
        UserDto userDto = QueryUtil.validateExampleAndReturn(filter, UserDto.class);
        List eoList = this.userDas.selectPageFuzzy(userDto, pageNum, pageSize);
        PageInfo eoPage = new PageInfo(eoList);
        PageInfo<UserDto> dtoPage = QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPage, UserDto.class);
        return dtoPage;
    }

    @Override
    public PageInfo<UserDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        Criteria criteria = (Criteria)ObjectHelper.Json2Bean((String)filter, Criteria.class);
        UserEo userEo = new UserEo();
        userEo.setSqlFilters(criteria.getFilters());
        userEo.setOrderBy(criteria.getOrderBy());
        userEo.setOrderByDesc(criteria.getOrderByDesc());
        List<SqlFilter> sqlFilters = criteria.getFilters();
        Long instanceId = this.context.instanceId();
        for (SqlFilter sqlFilter : sqlFilters) {
            if (!sqlFilter.getProperty().equals(JSON_INSTANCE_ID)) continue;
            instanceId = Long.valueOf(sqlFilter.getValue().toString());
        }
        for (SqlFilter sqlFilter : sqlFilters) {
            if (!sqlFilter.getProperty().equals("domain")) continue;
            UserDto userDto = new UserDto();
            userDto.setDomain(userEo.getDomain());
            String domain = this.checkOrGetDomain(instanceId, userDto);
            userEo.setDomain(domain);
        }
        if (StringUtils.isBlank((CharSequence)userEo.getOrderByDesc())) {
            userEo.setOrderByDesc("create_time");
        }
        PageInfo pageInfo = this.userDas.selectPage((BaseEo)userEo, pageNum, pageSize);
        PageInfo<UserDto> dtoPage = QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)pageInfo, UserDto.class);
        this.setUserResInfo(dtoPage.getList(), criteria.getReses());
        return dtoPage;
    }

    private void setUserResInfo(List<UserDto> userDtos, List<String> reses) {
        for (UserDto userDto : userDtos) {
            if (reses.contains("address")) {
                List<AddressDto> addressDtos = this.personalInfoService.queryAddressByUserId(userDto.getId());
                userDto.setAddressList(addressDtos);
            }
            if (reses.contains("personInfo")) {
                PersonalInfoDto personalInfoDto = this.personalInfoService.queryByPersonalInfoId(userDto.getPersonId());
                userDto.setPersonalInfo(personalInfoDto);
            }
            if (reses.contains("role")) {
                List<RoleDto> roleDtos = this.roleService.queryByUserId(userDto.getId());
                HashSet roleDtoSet = Sets.newHashSet();
                roleDtoSet.addAll(roleDtos);
                userDto.setRoleSet((Set)roleDtoSet);
            }
            if (!reses.contains("billInfo")) continue;
            List billInfoEo = this.billInfoDas.findByUserId(userDto.getId());
            ArrayList billInfoDto = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)billInfoEo)) {
                DtoHelper.eoList2DtoList((Collection)billInfoEo, billInfoDto, BillInfoDto.class);
            }
            userDto.setBillInfoList(billInfoDto);
        }
    }

    @Override
    public List<UserDto> queryByIdList(String ids) {
        String[] idAy = ids.split(",");
        AssertUtil.isTrue(idAy.length <= 1000, "ID \u4e2a\u6570\u4e0d\u80fd\u8d85\u8fc71000");
        HashSet idSet = Sets.newHashSet();
        for (String id : idAy) {
            idSet.add(Long.valueOf(id));
        }
        List list = this.userDas.findByIds((Set)idSet);
        ArrayList userDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)list, (Collection)userDtoList, UserDto.class);
        return userDtoList;
    }

    @Override
    public UserDto queryUser(Long userId) {
        AssertUtil.isTrue(null != userId, "userId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        UserDto userDto = new UserDto();
        DtoHelper.eo2Dto((BaseEo)userEo, (BaseVo)userDto);
        if (StringUtils.isNotBlank((CharSequence)this.maskPassword)) {
            userDto.setPassword(this.maskPassword);
        }
        userDto.setSalt(null);
        return userDto;
    }

    @Override
    public UserVo queryUserByIdAndRes(Long userId, String[] res, String filter) {
        PersonalInfoDto personalInfoDto;
        AssertUtil.isTrue(null != userId, "userId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        UserVo userDto = new UserVo();
        HashSet<String> respResSet = new HashSet<String>(Arrays.asList(res));
        String ignoreStr = "";
        if (respResSet.contains("address")) {
            List<AddressDto> addressDtos = this.personalInfoService.queryAddressByUserId(userId);
            userDto.setAddressList(addressDtos);
        }
        if (respResSet.contains("personInfo") && userEo.getPersonId() != null && (personalInfoDto = this.personalInfoService.queryPersonalInfo(userEo.getPersonId())) != null) {
            personalInfoDto.setUserId(userId);
            userDto.setPersonalInfo(personalInfoDto);
        }
        if (respResSet.contains("role")) {
            List<RoleDto> roleDtos = null;
            if (StringUtils.isNotEmpty((CharSequence)filter) && null != JSON.parseObject((String)filter) && null != JSON.parseObject((String)filter).getLong(JSON_INSTANCE_ID)) {
                Long instanceId = JSON.parseObject((String)filter).getLong(JSON_INSTANCE_ID);
                roleDtos = this.roleService.queryByUserIdAndInstanceId(userId, instanceId);
            } else {
                roleDtos = this.roleService.queryByUserId(userId);
            }
            HashSet roleDtoSet = Sets.newHashSet();
            roleDtoSet.addAll(roleDtos);
            userDto.setRoleSet((Set)roleDtoSet);
        }
        if (respResSet.contains("billInfo")) {
            List billInfoEo = this.billInfoDas.findByUserId(userId);
            ArrayList billInfoDto = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)billInfoEo)) {
                DtoHelper.eoList2DtoList((Collection)billInfoEo, billInfoDto, BillInfoDto.class);
            }
            userDto.setBillInfoList(billInfoDto);
        }
        DtoHelper.eo2Dto((BaseEo)userEo, (BaseVo)userDto);
        userDto.setPassword(null);
        return userDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(UserDto userDto) {
        Long userId = userDto.getId();
        AssertUtil.isTrue(null != userId, "userId \u4e0d\u80fd\u4e3a\u7a7a");
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        if (StringUtils.isNotEmpty((CharSequence)userDto.getUserName()) || StringUtils.isNotEmpty((CharSequence)userDto.getPhone()) || StringUtils.isNotEmpty((CharSequence)userDto.getEmail())) {
            if (userDto.getTenantId() == null) {
                userDto.setTenantId(userEo.getTenantId());
            }
            if (userDto.getInstanceId() == null) {
                userDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
            }
            String domain = this.checkOrGetDomain(userEo.getInstanceId(), userEo.getTenantId(), userDto.getDomain());
            userDto.setDomain(domain);
            this.checkUserUnique(userDto);
        }
        if (userDto.getPassword() != null && (userDto.getPassword().equals(this.maskPasswordAfterBase64) || userDto.getPassword().equals(this.maskPassword))) {
            userDto.setPassword(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)userDto.getRoleSet())) {
            Long instanceId = ServiceContext.getContext().getRequestInstanceId();
            List<Long> roleIds = userDto.getRoleSet().stream().map(RoleDto::getId).collect(Collectors.toList());
            this.accessService.addUserRoles(instanceId, userId, roleIds);
        }
        UserEo updateEo = (UserEo)this.userModifyRestrictExt.execute((Object)userDto);
        this.userDas.updateSelective((BaseEo)updateEo);
        this.updateLoginConfig(userDto, userEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePasswordPermitted(UserDto userDto) {
        Long userId;
        if (userDto.getInstanceId() == null) {
            userDto.setInstanceId(this.context.instanceId());
        }
        if (userDto.getTenantId() == null) {
            userDto.setTenantId(this.context.tenantId());
        }
        AssertUtil.isTrue(null != (userId = userDto.getId()), "userId \u4e0d\u80fd\u4e3a\u7a7a");
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        String encryptPassword = this.passwordService.RSAEncrypt(userDto.getPassword());
        userDto.setPassword(encryptPassword);
        Boolean isCheck = this.verifyUserName;
        if (null != userDto.getExtFields() && null != userDto.getExtFields().get("verifyUserName")) {
            isCheck = (Boolean)userDto.getExtFields().get("verifyUserName");
        }
        if (isCheck.booleanValue()) {
            this.validUserName(userDto.getUserName());
        }
        this.checkUserUnique(userDto);
        UserEo updateEo = new UserEo();
        DtoHelper.dto2Eo((BaseVo)userDto, (BaseEo)updateEo, (String[])new String[]{"account", "roleSet", "personalInfo", "organizationInfo", "addressList", "contactsInfo", "tenantId", JSON_INSTANCE_ID});
        if (null != updateEo.getPassword()) {
            if (StringUtils.isBlank((CharSequence)updateEo.getSalt()) && this.emptySaltGenerate) {
                updateEo.setSalt(UUID.randomUUID().toString());
            }
            String md5Password = this.passwordService.encryptPassword(updateEo.getPassword(), updateEo.getSalt(), userEo.getTenantId(), userEo.getInstanceId());
            updateEo.setPassword(md5Password);
        }
        this.userDas.updateSelective((BaseEo)updateEo);
        this.updateLoginConfig(userDto, userEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateLoginConfig(UserDto userDto, UserEo userEo) {
        this.updateAddLoginConfig(userEo.getUserName(), userDto.getUserName(), "name", userEo);
        this.updateAddLoginConfig(userEo.getPhone(), userDto.getPhone(), "phone", userEo);
        this.updateAddLoginConfig(userEo.getEmail(), userDto.getEmail(), "email", userEo);
        if (null != userDto.getStatus() && !userDto.getStatus().equals(userEo.getStatus())) {
            this.loginConfigDas.updateStatusByOwnerId(userDto.getStatus(), userEo.getId());
        }
    }

    private void updateAddLoginConfig(String oldValue, String newValue, String loginType, UserEo userEo) {
        if (null != newValue && !newValue.equals(oldValue)) {
            if (oldValue != null) {
                LoginConfigEo loginConfigEo = new LoginConfigEo();
                loginConfigEo.setOwnerId(userEo.getId());
                loginConfigEo.setLoginType(loginType);
                loginConfigEo.setLoginKey(oldValue);
                loginConfigEo = (LoginConfigEo)this.loginConfigDas.selectOne((BaseEo)loginConfigEo);
                if (null != loginConfigEo) {
                    LoginConfigEo deleteEo = new LoginConfigEo();
                    deleteEo.setId(loginConfigEo.getId());
                    deleteEo.setLoginKey(oldValue);
                    this.loginConfigDas.logicDelete((BaseEo)deleteEo);
                }
            }
            LoginConfigEo updateEo = new LoginConfigEo();
            updateEo.setStatus(Integer.valueOf(1));
            updateEo.setOwnerId(userEo.getId());
            updateEo.setLoginType(loginType);
            updateEo.setLoginKey(newValue);
            updateEo.setTenantId(userEo.getTenantId());
            updateEo.setInstanceId(userEo.getInstanceId());
            updateEo.setDomain(userEo.getDomain());
            this.loginConfigDas.insert((BaseEo)updateEo);
        }
    }

    private void addLoginConfig(UserDto userDto, UserEo userEo) {
        ArrayList eoList = Lists.newArrayList();
        LoginConfigEo loginConfig = this.getLoginConfigEo(userEo);
        loginConfig.setLoginType(IdentityConstants.LoginType.name.getCode());
        loginConfig.setLoginKey(userDto.getUserName());
        eoList.add(loginConfig);
        if (null != userDto.getAccount()) {
            loginConfig = this.getLoginConfigEo(userEo);
            loginConfig.setLoginType(IdentityConstants.LoginType.account.getCode());
            loginConfig.setLoginKey(userDto.getAccount());
            eoList.add(loginConfig);
        }
        if (null != userDto.getRegisterType()) {
            switch (userDto.getRegisterType()) {
                case 1: 
                case 2: {
                    loginConfig = this.getLoginConfigEo(userEo);
                    loginConfig.setLoginType(IdentityConstants.LoginType.phone.getCode());
                    loginConfig.setLoginKey(userDto.getPhone());
                    eoList.add(loginConfig);
                    break;
                }
                case 3: {
                    loginConfig = this.getLoginConfigEo(userEo);
                    loginConfig.setLoginType(IdentityConstants.LoginType.email.getCode());
                    loginConfig.setLoginKey(userDto.getEmail());
                    eoList.add(loginConfig);
                    break;
                }
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)userDto.getPhone())) {
                loginConfig = this.getLoginConfigEo(userEo);
                loginConfig.setLoginType(IdentityConstants.LoginType.phone.getCode());
                loginConfig.setLoginKey(userDto.getPhone());
                eoList.add(loginConfig);
            }
            if (StringUtils.isNotBlank((CharSequence)userDto.getEmail())) {
                loginConfig = this.getLoginConfigEo(userEo);
                loginConfig.setLoginType(IdentityConstants.LoginType.email.getCode());
                loginConfig.setLoginKey(userDto.getEmail());
                eoList.add(loginConfig);
            }
        }
        this.loginConfigDas.insertBatch((List)eoList);
    }

    private LoginConfigEo getLoginConfigEo(UserEo userEo) {
        LoginConfigEo loginConfig = new LoginConfigEo();
        loginConfig.setStatus(Integer.valueOf(1));
        loginConfig.setOwnerId(userEo.getId());
        loginConfig.setTenantId(userEo.getTenantId());
        loginConfig.setInstanceId(userEo.getInstanceId());
        loginConfig.setExtension("");
        loginConfig.setDomain(userEo.getDomain());
        return loginConfig;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePasswordPermittedWithSalt(UserDto userDto) {
        Long userId = userDto.getId();
        AssertUtil.isTrue(null != userId, "userId \u4e0d\u80fd\u4e3a\u7a7a");
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        String encryptPassword = this.passwordService.RSAEncrypt(userDto.getPassword());
        userDto.setPassword(encryptPassword);
        Boolean isCheck = this.verifyUserName;
        if (null != userDto.getExtFields() && null != userDto.getExtFields().get("verifyUserName")) {
            isCheck = (Boolean)userDto.getExtFields().get("verifyUserName");
        }
        if (isCheck.booleanValue()) {
            this.validUserName(userDto.getUserName());
        }
        this.checkUserUnique(userDto);
        UserEo updateEo = new UserEo();
        DtoHelper.dto2Eo((BaseVo)userDto, (BaseEo)updateEo, (String[])new String[]{"roleSet", "personalInfo", "organizationInfo", "addressList", "contactsInfo", "tenantId", JSON_INSTANCE_ID});
        this.userDas.updateSelective((BaseEo)updateEo);
        this.updateLoginConfig(userDto, userEo);
    }

    @Override
    public void enableTenantManager(Long userId) {
        AssertUtil.isTrue(null != userId, "\u79df\u6237\u7ba1\u7406\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u79df\u6237\u7ba1\u7406\u5458\u4fe1\u606f\u4e0d\u5b58\u5728 | tenantId = " + userId);
        AssertUtil.isTrue(2 - userEo.getStatus() == 0, "\u7528\u6237\u72b6\u6001\u4e0d\u6b63\u786e");
        UserEo updateEo = new UserEo();
        updateEo.setId(userId);
        updateEo.setStatus(Integer.valueOf(1));
        this.userDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void disableTenantManager(Long userId) {
        AssertUtil.isTrue(null != userId, "\u79df\u6237\u7ba1\u7406\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u79df\u6237\u7ba1\u7406\u5458\u4fe1\u606f\u4e0d\u5b58\u5728 | tenantId = " + userId);
        AssertUtil.isTrue(1 - userEo.getStatus() == 0, "\u7528\u6237\u72b6\u6001\u4e0d\u6b63\u786e");
        UserEo updateEo = new UserEo();
        updateEo.setId(userId);
        updateEo.setStatus(Integer.valueOf(2));
        this.userDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long userId) {
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        this.cacheService.delCache(userEo.getUserNameUniValue());
        this.cacheService.delCache(userEo.getPhoneUniValue());
        this.cacheService.delCache(userEo.getEmailUniValue());
        this.userDas.logicDeleteById(userId);
        LoginConfigEo loginConfigEo = new LoginConfigEo();
        loginConfigEo.setOwnerId(userId);
        this.loginConfigDas.logicDeleteByExample((BaseEo)loginConfigEo);
        this.afterDeleteUserExt.execute((Object)userEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(String batchNo) {
        UserEo param = new UserEo();
        LinkedList<SqlFilter> sqlFilters = new LinkedList<SqlFilter>();
        SqlFilter sqlFilter = new SqlFilter();
        sqlFilter.setProperty("batch");
        sqlFilter.setValue((Object)batchNo);
        sqlFilter.setOperator(SqlFilter.Operator.eq);
        sqlFilters.add(sqlFilter);
        param.setSqlFilters(sqlFilters);
        List list = this.userDas.select((BaseEo)param);
        AssertUtil.isTrue(!list.isEmpty(), "\u6279\u6b21\u4e0d\u5b58\u5728");
        param.setUserNameUniValue(null);
        param.setPhoneUniValue(null);
        param.setEmailUniValue(null);
        this.userDas.logicDelete((BaseEo)param);
        StringBuilder userIds = new StringBuilder();
        for (UserEo userEo2 : list) {
            userIds.append(userEo2.getId()).append(",");
            this.cacheService.delCache(userEo2.getUserNameUniValue());
            this.cacheService.delCache(userEo2.getPhoneUniValue());
            this.cacheService.delCache(userEo2.getEmailUniValue());
        }
        LinkedList<SqlFilter> updateSqlFilters = new LinkedList<SqlFilter>();
        SqlFilter updateSqlFilter = new SqlFilter();
        updateSqlFilter.setProperty("userId");
        updateSqlFilter.setValue((Object)userIds.deleteCharAt(userIds.length() - 1));
        updateSqlFilter.setOperator(SqlFilter.Operator.in);
        updateSqlFilters.add(updateSqlFilter);
        list.stream().forEach(userEo -> {
            LoginConfigEo loginConfigEo = new LoginConfigEo();
            loginConfigEo.setOwnerId(userEo.getId());
            this.loginConfigDas.logicDeleteByExample((BaseEo)loginConfigEo);
        });
        this.afterBatchDeleteUserExt.execute((Object)list);
    }

    @Override
    public Long registerDeveloper(UserDto userDto) {
        UserEo userEo = this.addUser(null, userDto);
        RoleEo roleEo = this.roleService.findByDeveloper();
        if (roleEo == null) {
            RoleDto roleDto = new RoleDto();
            roleDto.setCode("developer");
            roleDto.setName("\u5f00\u53d1\u8005");
            roleEo = this.roleService.save(roleDto);
        }
        UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
        userRoleRelationEo.setRoleId(roleEo.getId());
        userRoleRelationEo.setUserId(userEo.getId());
        this.userRoleRelationDas.insert((BaseEo)userRoleRelationEo);
        return userEo.getId();
    }

    @Override
    public Long registerTenant(UserDto userDto) {
        TenantEo tenantEo = new TenantEo();
        tenantEo.setUserId(userDto.getId());
        tenantEo.setStatus(Integer.valueOf(1));
        this.tenantDas.insert((BaseEo)tenantEo);
        UserEo userEo = this.addUser(null, userDto);
        RoleEo roleEo = this.roleService.findByTenant();
        if (roleEo == null) {
            RoleDto roleDto = new RoleDto();
            roleDto.setCode("tenant");
            roleDto.setName("\u79df\u6237");
            roleEo = this.roleService.save(roleDto);
        }
        UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
        userRoleRelationEo.setRoleId(roleEo.getId());
        userRoleRelationEo.setUserId(userEo.getId());
        this.userRoleRelationDas.insert((BaseEo)userRoleRelationEo);
        userEo.setTenantId(tenantEo.getId());
        this.userDas.update((BaseEo)userEo);
        return userEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableLogin(Long userId, String loginType, Integer status) {
        LoginConfigEo loginConfigEo = this.loginConfigDas.findFirstByOwnerIdAndLoginType(userId, loginType);
        AssertUtil.isTrue(null != loginConfigEo, "\u767b\u5f55\u914d\u7f6e\u4e0d\u5b58\u5728");
        LoginConfigEo loginConfigUpdateEo = new LoginConfigEo();
        loginConfigUpdateEo.setStatus(status);
        loginConfigUpdateEo.setId(loginConfigEo.getId());
        ArrayList sqlFilterList = Lists.newArrayList();
        sqlFilterList.add(SqlFilter.eq((String)"login_key", (Object)loginConfigEo.getLoginKey()));
        loginConfigUpdateEo.setSqlFilters((List)sqlFilterList);
        this.loginConfigDas.updateSelectiveSqlFilter((BaseEo)loginConfigUpdateEo);
        LoginConfigEo queryEo = new LoginConfigEo();
        queryEo.setOwnerId(userId);
        List list = this.loginConfigDas.select((BaseEo)queryEo);
        for (LoginConfigEo tmpEo : list) {
            if (tmpEo.getStatus() != 1) continue;
            status = 1;
        }
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        userEo.setStatus(status);
        this.userDas.update((BaseEo)userEo);
    }

    private Map<String, Boolean> returnResourceOrNot(String[] res) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("billInfo", false);
        map.put("address", false);
        map.put("role", false);
        map.put("personInfo", false);
        map.put("organizationInfo", false);
        if (res == null || res.length == 0) {
            return map;
        }
        for (String resource : res) {
            if ("billInfo".equals(resource)) {
                map.put("billInfo", true);
            }
            if ("address".equals(resource)) {
                map.put("address", true);
            }
            if ("role".equals(resource)) {
                map.put("role", true);
            }
            if ("personInfo".equals(resource)) {
                map.put("personInfo", true);
            }
            if (!"organizationInfo".equals(resource)) continue;
            map.put("organizationInfo", true);
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Map<String, String>> addBatchUsers(Long instanceId, List<ImportUsersDto> list) {
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(instanceId);
        ArrayList<Map<String, String>> errorList = new ArrayList<Map<String, String>>();
        LinkedList<UserEo> userEoList = new LinkedList<UserEo>();
        for (ImportUsersDto importUsersDto : list) {
            UserEo user = this.addImportUser(tenantId, instanceId, importUsersDto, errorList);
            if (user == null) continue;
            userEoList.add(user);
        }
        this.afterBatchAddUserExt.execute((Object)new Pair(userEoList, list));
        return errorList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ImportUserResult importUsers(Long instanceId, List<ImportUsersDto> list) {
        ImportUserResult result = new ImportUserResult();
        HashMap successData = Maps.newHashMap();
        ArrayList<Map<String, String>> errorList = new ArrayList<Map<String, String>>();
        AppInstanceEo instance = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        AssertUtil.isTrue(instance != null, UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg(), new Object[0]);
        Long tenantId = instance.getTenantId();
        LinkedList<UserEo> userEoList = new LinkedList<UserEo>();
        for (ImportUsersDto importUsersDto : list) {
            UserEo user = this.addImportUser(tenantId, instanceId, importUsersDto, errorList);
            if (user == null) continue;
            successData.put(user.getUserName(), user.getId());
            userEoList.add(user);
        }
        result.setSuccessData((Map)successData);
        result.setErrorData(errorList);
        this.afterBatchAddUserExt.execute((Object)new Pair(userEoList, list));
        return result;
    }

    private UserEo addImportUser(Long tenantId, Long instanceId, ImportUsersDto importUsersDto, List<Map<String, String>> errorList) {
        UserEo user = this.addImportUser(tenantId, instanceId, importUsersDto);
        if (null == user) {
            return null;
        }
        this.addImportUserExtraParam(importUsersDto, user);
        return user;
    }

    private UserEo addImportUser(Long tenantId, Long instanceId, ImportUsersDto importUsersDto) {
        PersonalInfoEo person;
        UserEo user;
        UserDto userDto;
        boolean personIsNew;
        block19: {
            personIsNew = true;
            userDto = importUsersDto.getUser();
            user = null;
            person = null;
            if (userDto.getId() != null) {
                user = (UserEo)this.userDas.selectByPrimaryKey(userDto.getId());
                if (user.getPersonId() != null) {
                    person = (PersonalInfoEo)this.personalInfoDas.selectByPrimaryKey(user.getPersonId());
                    personIsNew = false;
                } else {
                    person = new PersonalInfoEo();
                }
            } else {
                user = new UserEo();
                person = new PersonalInfoEo();
                if (StringUtils.isNotBlank((CharSequence)importUsersDto.getUser().getPhone())) {
                    BaseDto baseDto = new BaseDto();
                    baseDto.setInstanceId(instanceId);
                    baseDto.setTenantId(tenantId);
                    try {
                        UserDto dto = this.queryByPhone(importUsersDto.getUser().getPhone(), JSON.toJSONString((Object)baseDto));
                        if (dto == null) break block19;
                        if (UserConstants.UserType.GUEST.getCode().equals(dto.getUserType())) {
                            user.setId(dto.getId());
                            userDto.setId(dto.getId());
                            break block19;
                        }
                        this.logger.info("\u4f1a\u5458\u5df2\u5b58\u5728");
                        return null;
                    }
                    catch (BizException e) {
                        if (UserExceptionCode.USER_IDCHECK_FAIL.getCode().equals(e.getCode()) && "\u7528\u6237\u4e0d\u5b58\u5728".equals(e.getMessage())) {
                            this.logger.info("\u7528\u6237\u4e0d\u5b58\u5728");
                        }
                        throw e;
                    }
                }
            }
        }
        PersonalInfoDto personDto = importUsersDto.getPerson();
        DtoHelper.dto2Eo((BaseVo)personDto, (BaseEo)person);
        person.setInstanceId(instanceId);
        person.setTenantId(tenantId);
        if (personIsNew) {
            this.personalInfoDas.insert((BaseEo)person);
        } else {
            this.personalInfoDas.updateSelective((BaseEo)person);
        }
        UserEo updateUserEo = new UserEo();
        CubeBeanUtils.copyProperties((Object)updateUserEo, (Object)user, (String[])new String[0]);
        DtoHelper.dto2Eo((BaseVo)userDto, (BaseEo)user);
        String userName = userDto.getUserName();
        userName = StringUtils.isNotBlank((CharSequence)userName) ? userName : this.generateUserName();
        Boolean isCheck = this.verifyUserName;
        if (null != importUsersDto.getExtFields() && null != importUsersDto.getExtFields().get("verifyUserName")) {
            isCheck = (Boolean)importUsersDto.getExtFields().get("verifyUserName");
        }
        if (isCheck.booleanValue()) {
            this.validUserName(userName);
        }
        user.setUserName(userName);
        user.setPersonId(person.getId());
        user.setInstanceId(instanceId);
        user.setTenantId(tenantId);
        if (user.getPassword() != null) {
            if (StringUtils.isBlank((CharSequence)user.getSalt()) && this.emptySaltGenerate) {
                user.setSalt(UUID.randomUUID().toString());
            }
            String md5Password = this.passwordService.encryptPassword(user.getPassword(), user.getSalt(), user.getTenantId(), user.getInstanceId());
            user.setPassword(md5Password);
        }
        if (userDto.getId() != null) {
            this.userDas.updateSelective((BaseEo)user);
            this.updateLoginConfig(userDto, updateUserEo);
        } else {
            try {
                user.setRegisterTime(userDto.getRegisterTime() == null ? new Date() : userDto.getRegisterTime());
                List<String> uniCodes = this.addUserUniValue(user);
                this.userDas.insert((BaseEo)user);
                this.addLoginConfig(userDto, user);
                this.addUniValuesToCache(uniCodes);
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
                throw new BizException("\u53c2\u6570\u5f02\u5e38");
            }
        }
        return user;
    }

    private List<String> addUserUniValue(UserEo user) {
        ArrayList uniValues = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)user.getUserName())) {
            String userNameUniValue = MD5Util.getMd5ByString((String)(user.getTenantId() + user.getInstanceId() + user.getUserName()));
            user.setUserNameUniValue(userNameUniValue);
            uniValues.add(userNameUniValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)user.getPhone())) {
            String phoneUniValue = MD5Util.getMd5ByString((String)(user.getTenantId() + user.getInstanceId() + user.getPhone()));
            user.setPhoneUniValue(phoneUniValue);
            uniValues.add(phoneUniValue);
        }
        if (StringUtils.isNotEmpty((CharSequence)user.getEmail())) {
            String emailUniValue = MD5Util.getMd5ByString((String)(user.getTenantId() + user.getInstanceId() + user.getEmail()));
            user.setEmailUniValue(emailUniValue);
            uniValues.add(emailUniValue);
        }
        return uniValues;
    }

    private void addUniValuesToCache(List<String> uniValues) {
        uniValues.forEach(uniValue -> this.cacheService.setCache(uniValue, uniValue));
    }

    private void addImportUserExtraParam(ImportUsersDto importUsersDto, UserEo user) {
        boolean userIsNew = importUsersDto.getUser().getId() == null;
        String userExtraParams = importUsersDto.getUser().getExtraParams();
        String personExtraParams = importUsersDto.getPerson().getExtraParams();
        if (StringUtils.isNotBlank((CharSequence)userExtraParams)) {
            TableExtraPropertyDto dto = TableExtraPropertyDto.createTableExtraPropertyDto((String)"User", (Long)user.getId(), (String)userExtraParams, (Long)user.getInstanceId(), (Long)user.getTenantId());
            if (!userIsNew && this.tableExtraPropertyService.find("User", user.getId()) != null) {
                this.tableExtraPropertyService.update(dto);
            } else {
                this.tableExtraPropertyService.addTableExtraProperty(dto);
            }
        }
        Long personId = user.getPersonId();
        if (StringUtils.isNotBlank((CharSequence)personExtraParams) && personId != null) {
            TableExtraPropertyDto dto = TableExtraPropertyDto.createTableExtraPropertyDto((String)"Person", (Long)personId, (String)personExtraParams, (Long)user.getInstanceId(), (Long)user.getTenantId());
            if (!userIsNew && this.tableExtraPropertyService.find("Person", personId) != null) {
                this.tableExtraPropertyService.update(dto);
            } else {
                this.tableExtraPropertyService.addTableExtraProperty(dto);
            }
        }
    }

    private String generateImportBacthNo(String tabName, int tryTimes) {
        AssertUtil.isTrue(tryTimes < 3, "\u5c1d\u8bd5\u751f\u6210\u6279\u6b21\u53f7\u8d85\u8fc73\u6b21\uff0c\u751f\u6210\u5931\u8d25");
        String preBatchNo = System.currentTimeMillis() + "";
        ArrayList<Integer> existeBatchNo = this.cacheService.getList(tabName, preBatchNo, Integer.class);
        if (existeBatchNo == null) {
            existeBatchNo = new ArrayList<Integer>();
        }
        Integer maxNo = -1;
        for (Integer no : existeBatchNo) {
            if (maxNo >= no) continue;
            maxNo = no;
        }
        Integer n = maxNo;
        Integer n2 = maxNo = Integer.valueOf(maxNo + 1);
        if (maxNo > 99) {
            return this.generateImportBacthNo(tabName, ++tryTimes);
        }
        String batchNo = preBatchNo + (maxNo < 10 ? "0" + maxNo : maxNo);
        existeBatchNo.add(maxNo);
        this.cacheService.setCache(tabName, preBatchNo, existeBatchNo, 60);
        return batchNo;
    }

    private Long getId() {
        return IdGenrator.getDistributedId();
    }

    private int importPersonInfoBatch(List<ImportUsersDto> list) {
        ArrayList<PersonalInfoEo> eoList = new ArrayList<PersonalInfoEo>();
        for (ImportUsersDto importUsersDto : list) {
            PersonalInfoDto personDto = importUsersDto.getPerson();
            if (null == personDto) continue;
            PersonalInfoEo person = new PersonalInfoEo();
            personDto.setId((Long)importUsersDto.getExtFields().get(US_PERSON_INFO_ID));
            personDto.setInstanceId(importUsersDto.getUser().getInstanceId());
            personDto.setTenantId(importUsersDto.getUser().getTenantId());
            DtoHelper.dto2Eo((BaseVo)personDto, (BaseEo)person);
            if (person.getExtension() == null) {
                person.setExtension("");
            }
            eoList.add(person);
        }
        return this.personalInfoDas.insertBatch(eoList);
    }

    private List<UserEo> importUserBatch(List<ImportUsersDto> list, String batchNo) {
        ArrayList<UserEo> eoList = new ArrayList<UserEo>();
        for (ImportUsersDto importUsersDto : list) {
            UserDto userDto = importUsersDto.getUser();
            userDto.setId((Long)importUsersDto.getExtFields().get(US_USER_ID));
            userDto.setAccount(this.generateAccount());
            if (null == userDto.getRegisterTime()) {
                userDto.setRegisterTime(new Date());
            }
            if (null != importUsersDto.getPerson()) {
                userDto.setPersonId((Long)importUsersDto.getExtFields().get(US_PERSON_INFO_ID));
            }
            if (null != userDto.getPassword()) {
                if (StringUtils.isBlank((CharSequence)userDto.getSalt()) && this.emptySaltGenerate) {
                    userDto.setSalt(UUID.randomUUID().toString());
                }
                String md5Password = this.passwordService.encryptPassword(userDto.getPassword(), userDto.getSalt(), userDto.getTenantId(), userDto.getInstanceId());
                userDto.setPassword(md5Password);
            }
            UserEo user = new UserEo();
            DtoHelper.dto2Eo((BaseVo)userDto, (BaseEo)user);
            user.setBatch(batchNo);
            user.setUserName(this.generateUserName());
            user.setNickName(null);
            user.setPhone(null);
            user.setEmail(null);
            if (user.getExtension() == null) {
                user.setExtension("");
            }
            eoList.add(user);
        }
        this.userDas.insertBatch(eoList);
        return eoList;
    }

    private int importExtraPropertyBatch(List<ImportUsersDto> list) {
        ArrayList<TableExtraPropertyEo> eoList = new ArrayList<TableExtraPropertyEo>();
        for (ImportUsersDto importUsersDto : list) {
            String userExtraParams = importUsersDto.getUser().getExtraParams();
            Long userId = (Long)importUsersDto.getExtFields().get(US_USER_ID);
            Long personId = (Long)importUsersDto.getExtFields().get(US_PERSON_INFO_ID);
            Long instanceId = importUsersDto.getUser().getInstanceId();
            Long tenantId = importUsersDto.getUser().getTenantId();
            if (StringUtils.isNotBlank((CharSequence)userExtraParams)) {
                TableExtraPropertyDto tableExtraPropertyDto = TableExtraPropertyDto.createTableExtraPropertyDto((String)"User", (Long)userId, (String)userExtraParams, (Long)instanceId, (Long)tenantId);
                TableExtraPropertyEo eo = new TableExtraPropertyEo();
                DtoHelper.dto2Eo((BaseVo)tableExtraPropertyDto, (BaseEo)eo);
                eo.setCreateTime(new Date());
                eoList.add(eo);
            }
            String personExtraParams = null;
            if (null != importUsersDto.getPerson()) {
                personExtraParams = importUsersDto.getPerson().getExtraParams();
            }
            if (!StringUtils.isNotBlank(personExtraParams) || personId == null) continue;
            TableExtraPropertyDto tableExtraPropertyDto = TableExtraPropertyDto.createTableExtraPropertyDto((String)"Person", (Long)personId, (String)personExtraParams, (Long)instanceId, (Long)tenantId);
            TableExtraPropertyEo eo = new TableExtraPropertyEo();
            DtoHelper.dto2Eo((BaseVo)tableExtraPropertyDto, (BaseEo)eo);
            eo.setCreateTime(new Date());
            if (eo.getExtension() == null) {
                eo.setExtension("");
            }
            eoList.add(eo);
        }
        return this.tableExtraPropertyDas.insertBatch(eoList);
    }

    private void updateUserBatch(ImportUsersDto importUsersDto, String batchNo) {
        UserEo eo = (UserEo)this.userDas.selectByPrimaryKey((Long)importUsersDto.getExtFields().get(DUPLICATED_USER_ID));
        if (eo == null) {
            return;
        }
        UserEo update = new UserEo();
        CubeBeanUtils.copyProperties((Object)update, (Object)eo, (String[])new String[0]);
        UserDto userDto = importUsersDto.getUser();
        if (null != userDto.getPassword()) {
            if (StringUtils.isBlank((CharSequence)userDto.getSalt()) && this.emptySaltGenerate) {
                update.setSalt(UUID.randomUUID().toString());
            }
            String md5Password = this.passwordService.encryptPassword(userDto.getPassword(), update.getSalt(), eo.getTenantId(), eo.getInstanceId());
            update.setPassword(md5Password);
        }
        update.setUserType(userDto.getUserType());
        update.setAvatar(userDto.getAvatar());
        update.setActiveState(userDto.getActiveState());
        update.setStatus(userDto.getStatus());
        update.setInviteCode(userDto.getInviteCode());
        update.setInviterName(userDto.getInviterName());
        update.setRegisterTime(userDto.getRegisterTime());
        update.setNickName(null);
        update.setPhone(null);
        update.setEmail(null);
        update.setChannelCode(userDto.getChannelCode());
        update.setValidStartDate(userDto.getValidStartDate());
        update.setValidEndDate(userDto.getValidEndDate());
        update.setBatch(batchNo);
        Map extFields = importUsersDto.getExtFields();
        if (UserConstants.OverrideType.PART_OVERRIDE.getCode().equals((Integer)extFields.get(OVERRIDE_TYPE))) {
            List<String> ignoredFieldsList = this.getOverrideScope(update, extFields, "user");
            if (null != ignoredFieldsList) {
                UserEo partEo = new UserEo();
                CubeBeanUtils.copyProperties((Object)partEo, (Object)update, (String[])ignoredFieldsList.toArray(new String[ignoredFieldsList.size()]));
                this.userDas.updateSelective((BaseEo)partEo);
            }
        } else {
            this.userDas.updateSelective((BaseEo)update);
        }
        importUsersDto.getPerson().setId(eo.getPersonId());
    }

    private void updatePersonInfoBatch(ImportUsersDto importUsersDto) {
        PersonalInfoDto personDto = importUsersDto.getPerson();
        if (null != personDto) {
            PersonalInfoEo person = new PersonalInfoEo();
            DtoHelper.dto2Eo((BaseVo)personDto, (BaseEo)person);
            person.setInstanceId(importUsersDto.getUser().getInstanceId());
            person.setTenantId(importUsersDto.getUser().getTenantId());
            Map extFields = importUsersDto.getExtFields();
            if (UserConstants.OverrideType.PART_OVERRIDE.getCode().equals((Integer)extFields.get(OVERRIDE_TYPE))) {
                List<String> ignoredFieldsList = this.getOverrideScope(person, extFields, "personalInfo");
                if (null != ignoredFieldsList) {
                    PersonalInfoEo partEo = new PersonalInfoEo();
                    CubeBeanUtils.copyProperties((Object)partEo, (Object)person, (String[])ignoredFieldsList.toArray(new String[ignoredFieldsList.size()]));
                    this.personalInfoDas.updateSelective((BaseEo)partEo);
                }
            } else {
                this.personalInfoDas.updateSelective((BaseEo)person);
            }
        }
    }

    private void updateExtraPropertyBatch(ImportUsersDto importUsersDto) {
        Long userId = (Long)importUsersDto.getExtFields().get(DUPLICATED_USER_ID);
        Long instanceId = importUsersDto.getUser().getInstanceId();
        Long tenantId = importUsersDto.getUser().getTenantId();
        Map extFields = importUsersDto.getExtFields();
        String userExtraParams = importUsersDto.getUser().getExtraParams();
        if (StringUtils.isNotBlank((CharSequence)userExtraParams)) {
            TableExtraPropertyDto tableExtraPropertyDto = TableExtraPropertyDto.createTableExtraPropertyDto((String)"User", (Long)userId, (String)userExtraParams, (Long)instanceId, (Long)tenantId);
            TableExtraPropertyEo eo = new TableExtraPropertyEo();
            DtoHelper.dto2Eo((BaseVo)tableExtraPropertyDto, (BaseEo)eo);
            eo.setExtraParams(null);
            TableExtraPropertyEo tmp = (TableExtraPropertyEo)this.tableExtraPropertyDas.selectOne((BaseEo)eo);
            if (null != tmp) {
                eo.setId(tmp.getId());
                eo.setExtraParams(userExtraParams);
                if (UserConstants.OverrideType.PART_OVERRIDE.getCode().equals((Integer)extFields.get(OVERRIDE_TYPE))) {
                    List<String> ignoredFieldsList = this.getOverrideScope(eo, extFields, "extraProperty");
                    if (null != ignoredFieldsList) {
                        TableExtraPropertyEo partEo = new TableExtraPropertyEo();
                        CubeBeanUtils.copyProperties((Object)partEo, (Object)eo, (String[])ignoredFieldsList.toArray(new String[ignoredFieldsList.size()]));
                        this.tableExtraPropertyDas.updateSelective((BaseEo)partEo);
                    }
                } else {
                    this.tableExtraPropertyDas.updateSelective((BaseEo)eo);
                }
            }
        }
        String personExtraParams = null;
        Long personId = null;
        if (null != importUsersDto.getPerson()) {
            personExtraParams = importUsersDto.getPerson().getExtraParams();
            personId = importUsersDto.getPerson().getId();
        }
        if (StringUtils.isNotBlank(personExtraParams) && personId != null) {
            TableExtraPropertyDto tableExtraPropertyDto = TableExtraPropertyDto.createTableExtraPropertyDto((String)"Person", (Long)personId, (String)personExtraParams, (Long)instanceId, (Long)tenantId);
            TableExtraPropertyEo eo = new TableExtraPropertyEo();
            DtoHelper.dto2Eo((BaseVo)tableExtraPropertyDto, (BaseEo)eo);
            eo.setExtraParams(null);
            TableExtraPropertyEo tmp = (TableExtraPropertyEo)this.tableExtraPropertyDas.selectOne((BaseEo)eo);
            if (null != tmp) {
                eo.setId(tmp.getId());
                eo.setExtraParams(personExtraParams);
                if (UserConstants.OverrideType.PART_OVERRIDE.getCode().equals((Integer)extFields.get(OVERRIDE_TYPE))) {
                    List<String> ignoredFieldsList = this.getOverrideScope(eo, extFields, "extraProperty");
                    if (null != ignoredFieldsList) {
                        TableExtraPropertyEo partEo = new TableExtraPropertyEo();
                        CubeBeanUtils.copyProperties((Object)partEo, (Object)eo, (String[])ignoredFieldsList.toArray(new String[ignoredFieldsList.size()]));
                        this.tableExtraPropertyDas.updateSelective((BaseEo)partEo);
                    }
                } else {
                    this.tableExtraPropertyDas.updateSelective((BaseEo)eo);
                }
            }
        }
    }

    private List<String> getOverrideScope(Object bean, Map<String, Object> extFields, String table) {
        PropertyDescriptor[] pds;
        if (null == extFields.get(table) || CollectionUtils.sizeIsEmpty((Object)extFields.get(table))) {
            return null;
        }
        List updateFieldsList = JSONObject.parseArray((String)((JSONArray)extFields.get(table)).toJSONString(), String.class);
        updateFieldsList.add("id");
        ArrayList<String> allFieldsList = new ArrayList<String>();
        for (PropertyDescriptor pd : pds = PropertyUtils.getPropertyDescriptors(bean.getClass())) {
            allFieldsList.add(pd.getName());
        }
        return allFieldsList.stream().filter(field -> !updateFieldsList.contains(field)).collect(Collectors.toList());
    }

    @Override
    public UserDto queryByLoginStr(String loginStr, Long instanceId, String filter) {
        JSONObject jsonObject;
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        AssertUtil.isTrue(null != appInstanceEo, "\u5b9e\u4f8bID\u4e0d\u5b58\u5728");
        Long filterInstanceId = null;
        if (this.isIsolationByInstance(appInstanceEo.getTenantId())) {
            filterInstanceId = instanceId;
        }
        String domain = null;
        if (StringUtils.isNotBlank((CharSequence)filter) && (jsonObject = JSONObject.parseObject((String)filter)).get((Object)"domain") != null) {
            domain = jsonObject.get((Object)"domain").toString();
        }
        UserDto userDto = new UserDto();
        userDto.setDomain(domain);
        domain = this.checkOrGetDomainWithAppInstanceEo(appInstanceEo, userDto);
        List loginConfigEoList = this.loginConfigDas.findByLoginKey(null, loginStr, appInstanceEo.getTenantId(), filterInstanceId, domain);
        if (CollectionUtils.isEmpty((Collection)loginConfigEoList)) {
            throw new BizException(UserExceptionCode.USER_IDCHECK_FAIL.getCode(), "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (loginConfigEoList.stream().map(StdLoginConfigEo::getOwnerId).collect(Collectors.toSet()).size() > 1) {
            throw new BizException(UserExceptionCode.USER_IDCHECK_FAIL.getCode(), "\u7528\u6237\u8bb0\u5f55\u6df7\u6dc6,key=" + loginStr);
        }
        return this.findUserDtoById(((LoginConfigEo)loginConfigEoList.get(0)).getOwnerId());
    }

    private UserDto findUserDtoById(Long userId) {
        if (null == userId) {
            return null;
        }
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        if (null == userEo) {
            throw new BizException(UserExceptionCode.USER_IDCHECK_FAIL.getCode(), "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        UserDto userDto = new UserDto();
        DtoHelper.eo2Dto((BaseEo)userEo, (BaseVo)userDto, (String[])new String[]{"password"});
        return userDto;
    }

    @Override
    public UserDto queryByPhone(String phone, String filter) {
        UserDto userDto;
        Long filterInstanceId = null;
        Long filterTenantId = null;
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            BaseDto filterDto = (BaseDto)JSON.parseObject((String)filter, BaseDto.class);
            if (filterDto.getInstanceId() != null) {
                filterInstanceId = filterDto.getInstanceId();
            }
            if (filterDto.getTenantId() != null) {
                filterTenantId = filterDto.getTenantId();
            }
        }
        if (filterInstanceId == null) {
            filterInstanceId = ServiceContext.getContext().getRequestInstanceId();
        }
        if (null == (userDto = this.queryByLoginStr(phone, filterInstanceId, filter)) || !phone.equals(userDto.getPhone())) {
            throw new BizException(UserExceptionCode.USER_IDCHECK_FAIL.getCode(), "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return userDto;
    }

    @Override
    public UserDto queryByLoginNameAndType(String loginName, Integer loginNameTypeCode, Long tenantId, Long instanceId, String domain) {
        return this.queryByLoginNameAndType(loginName, loginNameTypeCode, tenantId, instanceId, domain, null);
    }

    @Override
    public UserDto queryByLoginNameAndType(String loginName, Integer loginNameType, Long tenantId, Long instanceId, String domain, String password) {
        List loginConfigEoList;
        String loginType = null;
        switch (loginNameType) {
            case 1: {
                loginType = "name";
                break;
            }
            case 2: {
                loginType = "phone";
                break;
            }
            case 3: {
                loginType = "email";
                break;
            }
        }
        if (null == loginType) {
            return null;
        }
        AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        UserDto checkDto = new UserDto();
        checkDto.setDomain(domain);
        checkDto.setTenantId(tenantId);
        checkDto.setInstanceId(instanceId);
        domain = this.checkOrGetDomainWithAppInstanceEo(appInstanceEo, checkDto);
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            instanceId = null;
        }
        if (CollectionUtils.isEmpty((Collection)(loginConfigEoList = this.loginConfigDas.findByLoginKey(loginType, loginName, tenantId, instanceId, domain)))) {
            return null;
        }
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(((LoginConfigEo)loginConfigEoList.get(0)).getOwnerId());
        if (null == userEo || 2 == userEo.getStatus()) {
            return null;
        }
        UserDto userDto = new UserDto();
        DtoHelper.eo2Dto((BaseEo)userEo, (BaseVo)userDto, (String[])new String[]{"password"});
        userDto.setValid(true);
        List enabledEoList = loginConfigEoList.stream().filter(loginConfigEo -> loginConfigEo.getStatus() != null && 1 == loginConfigEo.getStatus()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(enabledEoList)) {
            userDto.setIllegalReason("\u767b\u5f55\u5b57\u6bb5\u5df2\u88ab\u7981\u7528");
            userDto.setValid(false);
        }
        if (userDto.isValid() && 2 == userEo.getStatus()) {
            userDto.setIllegalReason("\u8be5\u7528\u6237\u5df2\u88ab\u7981\u7528");
            userDto.setValid(false);
        }
        if (userDto.isValid() && StringUtils.isNotBlank((CharSequence)password) && !this.passwordService.encryptPassword(password, userEo.getSalt(), null, null).equals(userEo.getPassword())) {
            userDto.setIllegalReason("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            userDto.setValid(false);
        }
        return userDto;
    }

    @Override
    public List<UserRespDto> queryByGroupType(Integer type, Long tenantId) {
        List<UserGroupDto> userGroupDtoList = this.userGroupService.queryByGroupType(type, tenantId);
        ArrayList userGroupEoList = new ArrayList();
        DtoHelper.dtoList2EoList(userGroupDtoList, userGroupEoList, UserGroupEo.class);
        if (CollectionUtils.isNotEmpty(userGroupEoList)) {
            GroupUserRelationEo groupUserRelationEo = new GroupUserRelationEo();
            HashSet<Long> userIds = new HashSet<Long>();
            for (UserGroupEo userGroupEo : userGroupEoList) {
                groupUserRelationEo.setUserGroupId(userGroupEo.getId());
                List groupUserRelationEoList = this.groupUserRelationDas.select((BaseEo)groupUserRelationEo);
                for (GroupUserRelationEo groupUserRelationEoo : groupUserRelationEoList) {
                    userIds.add(groupUserRelationEoo.getUserId());
                }
            }
            List userEoList = this.userDas.findByIds(userIds).stream().distinct().collect(Collectors.toList());
            ArrayList<UserRespDto> userRespDtoList = new ArrayList<UserRespDto>();
            DtoHelper.eoList2DtoList(userEoList, userRespDtoList, UserRespDto.class);
            return userRespDtoList;
        }
        return null;
    }

    @Override
    public List<UserDto> queryUserByGroupId(Long groupId) {
        GroupUserRelationEo groupUserRelationEo = new GroupUserRelationEo();
        groupUserRelationEo.setUserGroupId(groupId);
        List groupUserRelationEoList = this.groupUserRelationDas.select((BaseEo)groupUserRelationEo);
        ArrayList<UserDto> userRespDtoList = new ArrayList<UserDto>();
        for (GroupUserRelationEo groupUserRelationEoo : groupUserRelationEoList) {
            userRespDtoList.add(this.queryUser(groupUserRelationEoo.getUserId()));
        }
        return userRespDtoList.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public TenantManagerRespDto queryTenantOverview(Long userId) {
        UserDto userDto = this.queryUser(userId);
        Long tenantId = userDto.getTenantId();
        TenantDto tenantDto = this.tenantService.queryById(tenantId);
        try {
            TenantManagerRespDto tenantManagerRespDto = new TenantManagerRespDto();
            tenantManagerRespDto.setTenantManagerAccount(userDto.getUserName());
            tenantManagerRespDto.setPhone(userDto.getPhone());
            tenantManagerRespDto.setTenantName(tenantDto.getTenantName());
            tenantManagerRespDto.setTenantCode(tenantDto.getTenantCode());
            return tenantManagerRespDto;
        }
        catch (Exception e) {
            throw new BizException("\u6570\u636e\u5b57\u6bb5\u7f3a\u5931, \u8bf7\u786e\u8ba4\u6570\u636e\u5b8c\u6574\u6027");
        }
    }

    @Override
    public void batchDelete(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Long id : ids) {
                this.delete(id);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createUserAndGiveRoles(UserDto userDto, List<GiveRolesReqDto> giveRoleReqList) {
        userDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        RoleDto roleDto = this.roleService.queryRoleByCodeOrName(ServiceContext.getContext().getRequestInstanceId(), "APPMANAGER", null);
        if (null == userDto.getRoleSet()) {
            userDto.setRoleSet(new HashSet());
        }
        userDto.getRoleSet().add(roleDto);
        UserEo user = this.addUser(ServiceContext.getContext().getRequestInstanceId(), userDto);
        for (GiveRolesReqDto giveRolesReqDto : giveRoleReqList) {
            this.accessService.giveUserRole(giveRolesReqDto.getInstanceId(), userDto.getId(), giveRolesReqDto.getRoleIdList());
        }
        return user.getId();
    }

    @Override
    public PageInfo<UserDto> queryUser(Long tenantId, String account, String userName, String phone, String email, Integer pageNum, Integer pageSize) {
        Criteria criteria = this.getCriteria(account, userName, phone, email);
        criteria.setTenantId(tenantId);
        String filter = String.valueOf(JSONObject.toJSON((Object)criteria));
        return this.queryByPage(filter, pageNum, pageSize);
    }

    private Criteria getCriteria(String account, String userName, String phone, String email) {
        Criteria criteria = new Criteria();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)account)) {
            SqlFilter accountSqlFilter = new SqlFilter();
            accountSqlFilter.setProperty("account");
            accountSqlFilter.setOperator(SqlFilter.Operator.like);
            accountSqlFilter.setValue((Object)("%" + account + "%"));
            sqlFilterList.add(accountSqlFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            SqlFilter userNameSqlFilter = new SqlFilter();
            userNameSqlFilter.setProperty("userName");
            userNameSqlFilter.setOperator(SqlFilter.Operator.like);
            userNameSqlFilter.setValue((Object)("%" + userName + "%"));
            sqlFilterList.add(userNameSqlFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            SqlFilter phoneSqlFilter = new SqlFilter();
            phoneSqlFilter.setProperty("phone");
            phoneSqlFilter.setOperator(SqlFilter.Operator.eq);
            phoneSqlFilter.setValue((Object)phone);
            sqlFilterList.add(phoneSqlFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            SqlFilter emailSqlFilter = new SqlFilter();
            emailSqlFilter.setProperty("email");
            emailSqlFilter.setOperator(SqlFilter.Operator.like);
            emailSqlFilter.setValue((Object)("%" + email + "%"));
            sqlFilterList.add(emailSqlFilter);
        }
        criteria.setFilters(sqlFilterList);
        return criteria;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyUserAndGiveRoles(Long userId, UserModifyReqDto userModifyReqDto) {
        UserDto userDto = new UserDto();
        BeanUtils.copyProperties((Object)userModifyReqDto, (Object)userDto);
        userDto.setId(userId);
        this.update(userDto);
        if (CollectionUtils.isNotEmpty((Collection)userModifyReqDto.getGiveRolesReqDtoList())) {
            for (GiveRolesReqDto giveRolesReqDto : userModifyReqDto.getGiveRolesReqDtoList()) {
                this.accessService.addUserRoles(giveRolesReqDto.getInstanceId(), userId, giveRolesReqDto.getRoleIdList());
            }
        }
    }

    @Override
    public PageInfo<UserRoleDto> queryByPageAndRoleId(Long roleId, UserQueryDto userQueryReqDto, Integer pageNum, Integer pageSize) {
        UserDto userDto = new UserDto();
        CubeBeanUtils.copyProperties((Object)userDto, (Object)userQueryReqDto, (String[])new String[0]);
        Criteria criteria = this.getCriteria(userDto.getAccount(), userDto.getUserName(), userDto.getPhone(), userDto.getEmail());
        ArrayList reses = Lists.newArrayList();
        reses.add("role");
        criteria.setReses(reses);
        criteria.setTenantId(ServiceContext.getContext().getRequestTenantId());
        PageInfo<UserDto> userDtoPageInfo = this.queryByPage(JSONObject.toJSONString((Object)criteria), 1, 1000);
        ArrayList userRoleDtoList = Lists.newArrayList();
        List userDtoList = userDtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)userDtoList)) {
            for (UserDto dto : userDtoList) {
                List roleIdList;
                Set roleDtoSet = dto.getRoleSet();
                if (null == roleDtoSet || roleDtoSet.stream().allMatch(roleDto -> roleDto.getCode().equalsIgnoreCase("BOCMANAGER") || roleDto.getCode().equalsIgnoreCase("SUPER_ADMIN"))) continue;
                UserRoleDto userRoleDto = new UserRoleDto();
                CubeBeanUtils.copyProperties((Object)userRoleDto, (Object)dto, (String[])new String[0]);
                userRoleDto.setIsRoleRelated(Integer.valueOf(0));
                if (CollectionUtils.isNotEmpty((Collection)roleDtoSet) && CollectionUtils.isNotEmpty(roleIdList = roleDtoSet.stream().map(RoleDto::getId).distinct().collect(Collectors.toList())) && roleIdList.contains(roleId)) {
                    userRoleDto.setIsRoleRelated(Integer.valueOf(1));
                }
                userRoleDtoList.add(userRoleDto);
            }
        }
        return PageInfoUtil.doPage(userRoleDtoList, pageNum, pageSize);
    }

    @Override
    public Long addBinding(Long userId, BindingsDto bindingsDto) {
        Long tenantId = bindingsDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : bindingsDto.getTenantId();
        Long instanceId = bindingsDto.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : bindingsDto.getInstanceId();
        String domain = this.checkOrGetDomain(instanceId, tenantId, bindingsDto.getUserDomain());
        bindingsDto.setUserDomain(domain);
        BindingsEo bindedEo = null;
        String errTip = null;
        if (StringUtils.isNotEmpty((CharSequence)bindingsDto.getOpenId())) {
            bindedEo = this.bindingsDas.findBinding(bindingsDto.getOpenId(), bindingsDto.getThirdparyType(), instanceId, tenantId, domain);
            errTip = "openId";
        } else if (StringUtils.isNotEmpty((CharSequence)bindingsDto.getUnionId())) {
            bindedEo = this.bindingsDas.findBindingByUnionId(bindingsDto.getUnionId(), bindingsDto.getThirdparyType(), instanceId, tenantId, domain);
            errTip = "unionId";
        } else {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "openId\u548cunionId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (bindedEo != null) {
            if (bindedEo.getUserId().equals(userId)) {
                return userId;
            }
            throw new BizException(UserExceptionCode.EXIST_FAIL.getCode(), errTip + "\u4e4b\u524d\u5df2\u5173\u8054\u5176\u4ed6\u8d26\u53f7");
        }
        BindingsEo bindingsEo = new BindingsEo();
        DtoHelper.dto2Eo((BaseVo)bindingsDto, (BaseEo)bindingsEo);
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        bindingsEo.setUserId(userId);
        this.bindingsDas.insert((BaseEo)bindingsEo);
        return bindingsEo.getId();
    }

    @Override
    public void removeBinding(Long userId, BindingsDto bindingsDto) {
        BindingsEo eo = new BindingsEo();
        DtoHelper.dto2Eo((BaseVo)bindingsDto, (BaseEo)eo);
        eo.setUserId(userId);
        this.bindingsDas.logicDelete((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer unbinding(BindingsDto bindingsDto) {
        Long userId;
        if (StringUtils.isBlank((CharSequence)bindingsDto.getPhone()) && null == bindingsDto.getUserId()) {
            throw new BusinessRuntimeException(UserExceptionCode.EMPTY_PHONE_USERID.getCode(), UserExceptionCode.EMPTY_PHONE_USERID.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)bindingsDto.getOpenId())) {
            bindingsDto.setOpenId(null);
        }
        if (StringUtils.isBlank((CharSequence)bindingsDto.getUnionId())) {
            bindingsDto.setUnionId(null);
        }
        if (null == bindingsDto.getThirdparyType() && null == bindingsDto.getThirdpartyType()) {
            throw new BusinessRuntimeException(UserExceptionCode.EMPTY_THIRDPARTYTYPE.getCode(), UserExceptionCode.EMPTY_THIRDPARTYTYPE.getMsg());
        }
        if (null == bindingsDto.getThirdparyType() && null != bindingsDto.getThirdpartyType()) {
            bindingsDto.setThirdparyType(bindingsDto.getThirdpartyType());
        }
        if (null == bindingsDto.getThirdpartyType() && null != bindingsDto.getThirdparyType()) {
            bindingsDto.setThirdpartyType(bindingsDto.getThirdparyType());
        }
        if (null == bindingsDto.getTenantId()) {
            bindingsDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        }
        if (null == bindingsDto.getInstanceId()) {
            bindingsDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        }
        if (null != (userId = bindingsDto.getUserId())) {
            if (null == this.userDas.selectByPrimaryKey(userId)) {
                throw new BusinessRuntimeException(UserExceptionCode.USER_IDCHECK_FAIL.getCode(), UserExceptionCode.USER_IDCHECK_FAIL.getMsg());
            }
        } else {
            BaseDto baseDto = new BaseDto();
            baseDto.setTenantId(bindingsDto.getTenantId());
            baseDto.setInstanceId(bindingsDto.getInstanceId());
            userId = this.queryByPhone(bindingsDto.getPhone(), JSON.toJSONString((Object)baseDto)).getId();
            bindingsDto.setUserId(userId);
        }
        if (StringUtils.isBlank((CharSequence)bindingsDto.getOpenId()) && StringUtils.isBlank((CharSequence)bindingsDto.getUnionId())) {
            return this.deleteBindings(bindingsDto);
        }
        if (StringUtils.isNotBlank((CharSequence)bindingsDto.getOpenId())) {
            bindingsDto.setUnionId(null);
            return this.deleteBindings(bindingsDto);
        }
        if (StringUtils.isNotBlank((CharSequence)bindingsDto.getUnionId())) {
            return this.deleteBindings(bindingsDto);
        }
        return 0;
    }

    private int deleteBindings(BindingsDto bindingsDto) {
        if (null == bindingsDto) {
            return 0;
        }
        BindingsEo bindingsEo = new BindingsEo();
        DtoHelper.dto2Eo((BaseVo)bindingsDto, (BaseEo)bindingsEo);
        List list = this.bindingsDas.select((BaseEo)bindingsEo);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.bindingsDas.delete((BaseEo)bindingsEo);
            return list.size();
        }
        return 0;
    }

    @Override
    public UserDto queryBindingUser(String openId, Integer thirdparyType) {
        AssertUtil.isTrue(null != openId, UserExceptionCode.OPENID_NON_EXIST_FAIL.getCode(), UserExceptionCode.OPENID_NON_EXIST_FAIL.getMsg(), new Object[0]);
        BindingsEo bindingEo = this.bindingsDas.findByOpenIdAndThirdparyType(openId, thirdparyType);
        if (bindingEo == null) {
            return null;
        }
        Long userId = bindingEo.getUserId();
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        UserDto userDto = new UserDto();
        DtoHelper.eo2Dto((BaseEo)userEo, (BaseVo)userDto);
        return userDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUserToGroup(Long userId, Long groupId) {
        Set<String> domainList;
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "id\u4e3a" + userId + "\u7684\u7528\u6237\u4e0d\u5b58\u5728");
        UserGroupEo userGroupEo = (UserGroupEo)this.userGroupDas.selectByPrimaryKey(groupId);
        AssertUtil.isTrue(null != userGroupEo, "id\u4e3a" + groupId + "\u7528\u6237\u7ec4\u4e0d\u5b58\u5728");
        if (StringUtils.isNotBlank((CharSequence)userEo.getDomain()) && CollectionUtils.isNotEmpty(domainList = this.getAppInstanceAvailableDomain(userGroupEo.getInstanceId())) && !domainList.contains(userEo.getDomain())) {
            throw new BizException(UserExceptionCode.INVALID_USER_DOMAIN.getCode(), UserExceptionCode.INVALID_USER_DOMAIN.getMsg());
        }
        if (this.groupUserRelationDas.findByUserIdAndGroupId(userId, groupId) == null) {
            GroupUserRelationEo groupUserRelationEo = new GroupUserRelationEo();
            groupUserRelationEo.setUserId(userId);
            groupUserRelationEo.setUserGroupId(groupId);
            this.groupUserRelationDas.insert((BaseEo)groupUserRelationEo);
        }
    }

    private Set<String> getAppInstanceAvailableDomain(Long instanceId) {
        HashSet domainList = Sets.newHashSet();
        AppInstanceEo eo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(instanceId);
        if (eo == null) {
            throw new BizException(UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getCode(), UserExceptionCode.APPINSTANCE_IDCHECKE_FAIL.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)eo.getDefDomain())) {
            domainList.add(eo.getDefDomain());
        }
        if (StringUtils.isNotBlank((CharSequence)eo.getTrustDomain())) {
            String[] trustDomain;
            for (String domian : trustDomain = eo.getTrustDomain().split(",")) {
                domainList.add(domian);
            }
        }
        return domainList;
    }

    private Set<String> getAppInstanceAvailableDomain(AppInstanceEo appInstanceEo) {
        HashSet domainList = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)appInstanceEo.getDefDomain())) {
            domainList.add(appInstanceEo.getDefDomain());
        }
        if (StringUtils.isNotBlank((CharSequence)appInstanceEo.getTrustDomain())) {
            String[] trustDomain = appInstanceEo.getTrustDomain().split(",");
            Collections.addAll(domainList, trustDomain);
        }
        return domainList;
    }

    private Set<String> getTenantAvailableDomain(Long tenantId) {
        HashSet domainList = Sets.newHashSet();
        TenantEo tenantEo = (TenantEo)this.tenantDas.selectByPrimaryKey(tenantId);
        if (tenantEo == null) {
            throw new BizException(UserExceptionCode.NON_EXIST_FAIL.getCode(), "\u79df\u6237\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotBlank((CharSequence)tenantEo.getDefDomain())) {
            domainList.add(tenantEo.getDefDomain());
        }
        if (StringUtils.isNotBlank((CharSequence)tenantEo.getAvailableDomain())) {
            String[] availableDomain = tenantEo.getAvailableDomain().split(",");
            Collections.addAll(domainList, availableDomain);
        }
        return domainList;
    }

    @Override
    public void removeUserRoles(Long userId, Long[] roleIds) {
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "id\u4e3a" + userId + "\u7684\u7528\u6237\u4e0d\u5b58\u5728");
        Long tenantId = userEo.getTenantId();
        RoleEo tenantAdminRole = this.roleService.queryRole(tenantId, "MPC", "TENANT_ADMIN");
        RoleEo BocManagerRole = this.roleService.queryRole(tenantId, "BOC", "BOCMANAGER");
        Long tenantAdminRoleId = tenantAdminRole.getId();
        Long bocManagerRoleId = BocManagerRole.getId();
        HashSet<Long> roleIdSet = new HashSet<Long>(Arrays.asList(roleIds));
        if (roleIdSet.contains(tenantAdminRoleId)) {
            roleIdSet.add(bocManagerRoleId);
        }
        if (roleIdSet.contains(bocManagerRoleId)) {
            roleIdSet.add(tenantAdminRoleId);
        }
        for (Long roleId : roleIdSet) {
            RoleEo role = (RoleEo)this.roleDas.selectByPrimaryKey(roleId);
            AssertUtil.isTrue(null != role, "id\u4e3a" + roleId + "\u7684\u89d2\u8272\u4e0d\u5b58\u5728");
            UserRoleRelationEo userRoleRelationEo = new UserRoleRelationEo();
            userRoleRelationEo.setUserId(userId);
            userRoleRelationEo.setRoleId(roleId);
            this.userRoleRelationDas.delete((BaseEo)userRoleRelationEo);
            this.accessService.afterDeleteUserRoleExtHandle(role.getInstanceId(), userId);
        }
    }

    @Override
    public void setTenantRegisterConfig(Long tenantId, Integer isolationType) {
        RegisterConfigEo registerConfigEo = this.registerConfigDas.findConfigByTenantId(tenantId);
        if (registerConfigEo == null) {
            registerConfigEo = new RegisterConfigEo();
            registerConfigEo.setTenantId(tenantId);
            registerConfigEo.setIsolationType(isolationType);
            this.registerConfigDas.insert((BaseEo)registerConfigEo);
        } else {
            registerConfigEo.setIsolationType(isolationType);
            this.registerConfigDas.update((BaseEo)registerConfigEo);
        }
        this.cacheService.delCache(TenantServiceImpl.REDIS_KEY_PREFIX + tenantId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public UserEo addThirdPartyUser(Long instanceId, ThirdPartyUserReqDto thirdPartyUserReqDto) {
        UserEo userEo = this.addUser(instanceId, thirdPartyUserReqDto.getUserDto());
        this.addBinding(userEo.getId(), thirdPartyUserReqDto.getBindingsDto());
        return userEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeUserPhone(Long userId) {
        UserEo user = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(user != null, UserExceptionCode.USER_IDCHECK_FAIL.getCode(), UserExceptionCode.USER_IDCHECK_FAIL.getMsg(), new Object[0]);
        String phone = user.getPhone();
        user.setPhone("");
        this.userDas.update((BaseEo)user);
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            LoginConfigEo tmpEo = new LoginConfigEo();
            tmpEo.setLoginType("phone");
            tmpEo.setLoginKey(phone);
            tmpEo.setOwnerId(userId);
            this.loginConfigDas.logicDelete((BaseEo)tmpEo);
        }
    }

    @Override
    public UserDto queryBindingUserMultiInstanceTenant(String openId, Integer thirdparyType, Long instanceId, Long tenantId) {
        AssertUtil.isTrue(null != openId, UserExceptionCode.OPENID_NON_EXIST_FAIL.getCode(), UserExceptionCode.OPENID_NON_EXIST_FAIL.getMsg(), new Object[0]);
        BindingsEo bindingEo = this.bindingsDas.findBinding(openId, thirdparyType, instanceId, tenantId);
        if (bindingEo == null) {
            return null;
        }
        Long userId = bindingEo.getUserId();
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        UserDto userDto = new UserDto();
        DtoHelper.eo2Dto((BaseEo)userEo, (BaseVo)userDto);
        return userDto;
    }

    @Override
    public UserDto queryBindingUserByThirdId(ThirdBindingQueryReq queryReq) {
        ThirdQueryType queryType;
        Long tenantId = queryReq.getTenantId();
        if (tenantId == null) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u7f3a\u5c11\u53c2\u6570(tenantId)");
        }
        Long filterInstanceId = queryReq.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : queryReq.getInstanceId();
        String domain = this.checkOrGetDomain(filterInstanceId, tenantId, queryReq.getDomain());
        if (!this.isIsolationByInstance(tenantId)) {
            filterInstanceId = null;
        }
        if ((queryType = ThirdQueryType.fromCode((int)queryReq.getQueryType())) == null) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u67e5\u8be2\u7c7b\u578b(queryType)\u5c1a\u4e0d\u652f\u6301");
        }
        int thirdparyType = queryReq.getThirdType();
        BindingsEo bindingEo = null;
        if (ThirdQueryType.DEFAULT == queryType) {
            if (StringUtils.isNotEmpty((CharSequence)queryReq.getOpenId())) {
                bindingEo = this.bindingsDas.findBinding(queryReq.getOpenId(), Integer.valueOf(thirdparyType), filterInstanceId, tenantId, domain);
            }
            if (bindingEo == null && StringUtils.isNotEmpty((CharSequence)queryReq.getUnionId())) {
                bindingEo = this.bindingsDas.findBindingByUnionId(queryReq.getUnionId(), Integer.valueOf(thirdparyType), filterInstanceId, tenantId, domain);
            }
        } else if (ThirdQueryType.OPENID_ONLY == queryType) {
            if (StringUtils.isNotEmpty((CharSequence)queryReq.getOpenId())) {
                bindingEo = this.bindingsDas.findBinding(queryReq.getOpenId(), Integer.valueOf(thirdparyType), filterInstanceId, tenantId, domain);
            }
        } else if (ThirdQueryType.UNIONID_ONLY == queryType) {
            if (StringUtils.isNotEmpty((CharSequence)queryReq.getUnionId())) {
                bindingEo = this.bindingsDas.findBindingByUnionId(queryReq.getUnionId(), Integer.valueOf(thirdparyType), filterInstanceId, tenantId, domain);
            }
        } else if (ThirdQueryType.UNIONID_FIRST == queryType) {
            if (StringUtils.isNotEmpty((CharSequence)queryReq.getUnionId())) {
                bindingEo = this.bindingsDas.findBindingByUnionId(queryReq.getUnionId(), Integer.valueOf(thirdparyType), filterInstanceId, tenantId, domain);
            }
            if (bindingEo == null && StringUtils.isNotEmpty((CharSequence)queryReq.getOpenId())) {
                bindingEo = this.bindingsDas.findBinding(queryReq.getOpenId(), Integer.valueOf(thirdparyType), filterInstanceId, tenantId, domain);
            }
        } else {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u67e5\u8be2\u7c7b\u578b(queryType)\u5c1a\u4e0d\u652f\u6301");
        }
        if (bindingEo == null) {
            return null;
        }
        Long userId = bindingEo.getUserId();
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        UserDto userDto = new UserDto();
        DtoHelper.eo2Dto((BaseEo)userEo, (BaseVo)userDto);
        return userDto;
    }

    @Override
    public List<BindingsQueryRespDto> queryBindingByUserId(BindingsQueryReqDto bindingsQueryReqDto) {
        if (bindingsQueryReqDto.getUserId() == null && StrUtil.isBlank((CharSequence)bindingsQueryReqDto.getUserIds())) {
            throw new BizException(UserExceptionCode.REQ_PARAM_ERROR.getCode(), "\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BindingsEo bindingsEo = new BindingsEo();
        DtoHelper.dto2Eo((BaseVo)bindingsQueryReqDto, (BaseEo)bindingsEo);
        ArrayList<Long> userIdList = new ArrayList<Long>();
        if (bindingsQueryReqDto.getUserId() != null) {
            userIdList.add(bindingsQueryReqDto.getUserId());
            bindingsEo.setUserId(null);
        }
        if (StrUtil.isNotBlank((CharSequence)bindingsQueryReqDto.getUserIds())) {
            List<String> ids = Arrays.asList(bindingsQueryReqDto.getUserIds().split(","));
            userIdList.addAll(ids.stream().map(Long::valueOf).collect(Collectors.toList()));
        }
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"user_id", userIdList));
        bindingsEo.setSqlFilters(sqlFilterList);
        List eoList = this.bindingsDas.selectList((BaseEo)bindingsEo);
        ArrayList<BindingsQueryRespDto> dtoList = new ArrayList<BindingsQueryRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, dtoList, BindingsQueryRespDto.class);
        return dtoList;
    }

    @Override
    public String generateUserName() {
        int A = 65;
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        char N = (char)(A + hour);
        String dateFormat = DateUtil.getDateFormat((Date)calendar.getTime(), (String)"yyMMdd-mm");
        String key = N + dateFormat;
        Long i = this.cacheService.incr(key);
        return key + i;
    }

    @Override
    public String generateAccount() {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        String key = DateUtil.getDateFormat((Date)calendar.getTime(), (String)"yyMMddmm");
        Long i = this.cacheService.incr(key);
        return key + i;
    }

    @Override
    public PageInfo<UserEmployeeQueryRespDto> queryPageByUserAndEmployeeInfo(String filter, Integer pageNum, Integer pageSize) {
        Assert.hasLength((String)filter, (String)"\u67e5\u8be2\u6761\u4ef6filter\u4e0d\u80fd\u4e3a\u7a7a");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        UserEmployeeQueryReqDto queryReqDto = QueryUtil.validateExampleAndReturn(filter, UserEmployeeQueryReqDto.class);
        Assert.notNull((Object)queryReqDto.getInstanceId(), (String)"\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        List eoList = this.userDas.selectPageByUserAndEmployeeInfo(queryReqDto);
        PageInfo eoPage = new PageInfo(eoList);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPage, UserEmployeeQueryRespDto.class);
    }

    @Override
    public PageInfo<AddressDto> queryAddress(AddressQueryReqDto addressQueryReqDto, Integer pageNum, Integer pageSize) {
        AddressEo addressEo = new AddressEo();
        DtoHelper.dto2Eo((BaseVo)addressQueryReqDto, (BaseEo)addressEo);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List eoList = this.addressDas.selectAddressList(addressEo);
        PageInfo eoPageInfo = new PageInfo(eoList);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPageInfo, AddressDto.class);
    }

    @Override
    public Boolean isNeedModifyPassword(Long userId) {
        Date date;
        AssertUtil.isTrue(null != userId, "userId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UserEo userEo = (UserEo)this.userDas.selectByPrimaryKey(userId);
        AssertUtil.isTrue(null != userEo, "\u7528\u6237\u4e0d\u5b58\u5728");
        if (userEo.getModifyPasswordTime() != null && this.passwordValidTimeParam.getValue() != null && (Integer)this.passwordValidTimeParam.getValue() > 0 && (date = DateUtil.addHours((Date)userEo.getModifyPasswordTime(), (int)((Integer)this.passwordValidTimeParam.getValue()))).before(new Date())) {
            return true;
        }
        return false;
    }

    @Override
    public List<String> queryThirdUserId(ThirdPlatform thirdPlatform) {
        BindingsEo query = new BindingsEo();
        query.setUserId(this.context.userId());
        query.setThirdparyType(Integer.valueOf(thirdPlatform.getCode()));
        query.addSqlOrderBy("create_time", SortOrder.ASC);
        List select = this.bindingsDas.select((BaseEo)query);
        if (CollectionUtils.isEmpty((Collection)select)) {
            return Lists.newLinkedList();
        }
        return select.stream().map(StdBindingsEo::getOpenId).collect(Collectors.toList());
    }

    @Override
    public AddressDto queryDefaultAddress(Long userId) {
        AssertUtil.isTrue(null != userId, "userId \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AddressEo queryEo = new AddressEo();
        queryEo.setUserId(userId);
        queryEo.setStatus(Integer.valueOf(1));
        AddressEo addressEo = (AddressEo)this.addressDas.selectOne((BaseEo)queryEo);
        if (addressEo == null) {
            return null;
        }
        AddressDto dto = new AddressDto();
        DtoHelper.eo2Dto((BaseEo)addressEo, (BaseVo)dto);
        return dto;
    }

    @Override
    public PageInfo<AddressDto> queryUserAddress(AddressQueryReqDto addressQueryReqDto, Integer pageNum, Integer pageSize) {
        AddressEo addressEo = new AddressEo();
        DtoHelper.dto2Eo((BaseVo)addressQueryReqDto, (BaseEo)addressEo);
        PageInfo eoPageInfo = this.addressDas.selectPage((BaseEo)addressEo, pageNum, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPageInfo, AddressDto.class);
    }

    @Override
    public PageInfo<UserRoleDto> queryNotRelateRoleUser(Long roleId, UserQueryDto userQueryDto, Integer pageNum, Integer pageSize) {
        List userEoList = this.userRoleRelationDas.selectUserByRoleId(roleId);
        List userIdList = null;
        if (CollectionUtils.isNotEmpty((Collection)userEoList)) {
            userIdList = userEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        }
        UserEo userEo = new UserEo();
        CubeBeanUtils.copyProperties((Object)userEo, (Object)userQueryDto, (String[])new String[0]);
        userEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List eoList = this.userDas.selectListNotInIdsAndUserInfo(userEo, userIdList);
        PageInfo eoPageInfo = new PageInfo(eoList);
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPageInfo, UserRoleDto.class);
    }
}

