/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.dao.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceResourceDto;
import com.dtyunxi.yundt.cube.center.user.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.ButtonEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.ButtonMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ButtonDas
extends AbstractBaseDas<ButtonEo, String> {
    public List<ButtonEo> findByIds(List<Long> ids) {
        ButtonMapper buttonMapper = (ButtonMapper)this.getMapper();
        return buttonMapper.findByIds(ids);
    }

    public List<ButtonEo> findByApplicationId(Long applicationId) {
        ButtonMapper buttonMapper = (ButtonMapper)this.getMapper();
        return buttonMapper.findByApplicationId(applicationId);
    }

    public List<ButtonEo> selectByInstanceId(Long instanceId) {
        ButtonMapper buttonMapper = (ButtonMapper)this.getMapper();
        return buttonMapper.selectByInstanceId(instanceId);
    }

    public List<ButtonEo> selectByInstanceIdAndMenuCode(Long instanceId, String menuCode) {
        ButtonMapper buttonMapper = (ButtonMapper)this.getMapper();
        return buttonMapper.selectByInstanceIdAndMenuCode(instanceId, menuCode);
    }

    public ButtonEo selectByInstanceIdAndCode(Long instanceId, String code) {
        ButtonMapper buttonMapper = (ButtonMapper)this.getMapper();
        List<ButtonEo> list = buttonMapper.selectByInstanceIdAndCode(instanceId, code);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new BusinessRuntimeException("\u6570\u636e\u5f02\u5e38:code\u4e3a" + code + "\u7684\u6570\u636e\u6709" + list.size() + "\u6761(\u8d85\u8fc7\u4e00\u6761)");
    }

    public void deleteBatch(List<Long> ids) {
        ids.forEach(e -> this.getMapper().deleteLogicById(ButtonEo.class, e));
    }

    public Integer updateParentByInstanceIdAndCodes(String parentCode, Long parentId, List<String> buttonCodes) {
        ButtonMapper buttonMapper = (ButtonMapper)this.getMapper();
        return buttonMapper.updateParentByInstanceIdAndCodes(parentCode, parentId, buttonCodes);
    }

    public List<ButtonEo> selectByCodes(List<String> codes, Long instanceId) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<ButtonEo>();
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(codes, (String)",")));
        ButtonEo buttonEo = new ButtonEo();
        buttonEo.setSqlFilters(sqlFilters);
        buttonEo.setInstanceId(instanceId);
        return this.select((BaseEo)buttonEo, 1, 5000);
    }

    public List<ButtonEo> selectByMenuId(Long menuId, AppInstanceResourceDto appInstanceResourceDto) {
        if (menuId == null) {
            return new ArrayList<ButtonEo>();
        }
        ButtonEo buttonEo = new ButtonEo();
        buttonEo.setMenuId(menuId);
        String name = appInstanceResourceDto.getButtonName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + name + "%")));
            buttonEo.setSqlFilters(sqlFilters);
        }
        return this.select((BaseEo)buttonEo, 1, 5000);
    }

    public void deleteByMenuIds(List<Long> menuIds) {
        if (CollectionUtils.isEmpty(menuIds)) {
            return;
        }
        ButtonEo buttonEo = new ButtonEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"menu_id", (Object)StringUtils.join(menuIds, (String)",")));
        buttonEo.setSqlFilters(sqlFilters);
        this.deleteByExample((BaseEo)buttonEo);
    }
}

