-- abac 属性项

CREATE TABLE IF NOT EXISTS  `us_abac_attr` (
  `id` bigint(20) NOT NULL COMMENT '属性id',
  `name` varchar(128) DEFAULT NULL COMMENT '名称',
  `field_name` varchar(64) DEFAULT NULL COMMENT '添加到us_user_role的字段名称',
  `entity_code` varchar(100) DEFAULT NULL COMMENT '实体编码',
  `entity_id` bigint(20) DEFAULT NULL COMMENT '实体id',
  `attr_config` text COMMENT '属性项的详细配置，为JSON格式的字符串，参见AbacAttrConfigDto类',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_person` varchar(50) DEFAULT NULL COMMENT '创建人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_person` varchar(50) DEFAULT NULL COMMENT '更新人',
  `dr` tinyint(4) DEFAULT NULL COMMENT '逻辑删除标志 0未删除 1已删除',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户id',
  `instance_id` bigint(20) DEFAULT NULL COMMENT '实例id',
  `extension` varchar(1024) DEFAULT NULL COMMENT '扩展信息',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='abac 属性项';

-- abac 属性项与应用关联连
CREATE TABLE IF NOT EXISTS `us_abac_attr_application` (
  `id` bigint(20) NOT NULL COMMENT '属性id',
  `app_id` bigint(64) DEFAULT NULL COMMENT '应用id\r\n',
  `app_name` varchar(200) DEFAULT NULL COMMENT '用户名称',
  `attr_ids` varchar(1024) DEFAULT NULL COMMENT '属性项id,支持多个以“，”分隔',
  `attr_names` varchar(1024) DEFAULT NULL COMMENT '属性项名称，支持多个以“，”分隔',
  `status` tinyint(1) DEFAULT NULL COMMENT '状态： 1 ：启用  0：禁用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_person` varchar(50) DEFAULT NULL COMMENT '创建人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_person` varchar(50) DEFAULT NULL COMMENT '更新人',
  `dr` tinyint(4) DEFAULT NULL COMMENT '逻辑删除标志 0未删除 1已删除',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户id',
  `instance_id` bigint(20) DEFAULT NULL COMMENT '实例id',
  `extension` varchar(1024) DEFAULT NULL COMMENT '扩展信息',
  PRIMARY KEY (`id`),
  KEY `idx_app_id` (`app_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='abac 属性项与应用关联连';


ALTER TABLE us_r_user_role MODIFY COLUMN user_id bigint(20) DEFAULT -128 COMMENT '用户id';
ALTER TABLE us_r_user_role ADD post_id bigint(20) DEFAULT -128 COMMENT '岗位id' after user_id;
ALTER TABLE us_r_user_role ADD org_id bigint(20) DEFAULT -128 COMMENT '组织id' AFTER user_id;

