
-- 新增字段权限规则明细表
CREATE TABLE IF NOT EXISTS `us_field_limit_detail` (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `rule_id` bigint(20) NOT NULL COMMENT '规则id',
  `code` varchar(64) NOT NULL COMMENT '属性编码',
  `name` varchar(64) DEFAULT NULL COMMENT '属性名称',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态，0受限，1可见',
  `limit_way` tinyint(4) DEFAULT NULL COMMENT '限制方式，1完全隐藏，2脱敏',
  `desen_rule` tinyint(4) DEFAULT NULL COMMENT '脱敏规则，1星号替换，2姓名脱敏，3手机号脱敏，4邮箱脱敏，5身份证脱敏',
  `field_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '字段类型，1通用字段，2自定义字段',
  `domain_code` varchar(50) DEFAULT NULL COMMENT '领域编码',
  `entity_code` varchar(50) DEFAULT NULL COMMENT '实体编码',
  `entity_name` varchar(64) DEFAULT NULL COMMENT '实体名称',
  `extension` varchar(1024) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '租户ID',
  `dr` tinyint(2) NOT NULL DEFAULT '0' COMMENT '逻辑删除标记',
  `create_person` varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50) NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  PRIMARY KEY (`id`),
  KEY `idx_rule_id` (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='字段权限规则明细';