/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IResourceApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.ButtonDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RegisterChannelDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserGroupDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceBaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceCreateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceImportReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceRegisterDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceUpdateReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ResourceValidateDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.SortReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.MenuQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ResourceImportRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.ResourceQueryResDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IResourceQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="ResourceRest")
@RequestMapping(value={"/v1/resource"})
public class ResourceRest
implements IResourceApi,
IResourceQueryApi {
    @Resource(name="iResourceApi")
    IResourceApi resourceApi;
    @Resource(name="iResourceQueryApi")
    IResourceQueryApi resourceQueryApi;

    public RestResponse<Long> addResource(@RequestBody ResourceCreateReqDto reqDto) {
        return this.resourceApi.addResource(reqDto);
    }

    public RestResponse<Void> modifyResource(@RequestBody ResourceUpdateReqDto reqDto) {
        return this.resourceApi.modifyResource(reqDto);
    }

    public RestResponse<Void> removeResource(@PathVariable(value="ids") String ids) {
        return this.resourceApi.removeResource(ids);
    }

    public RestResponse<Void> sortResourceMenu(SortReqDto sortReqDto) {
        return this.resourceApi.sortResourceMenu(sortReqDto);
    }

    public RestResponse<ResourceImportRespDto> importResources(@RequestBody @Valid List<ResourceImportReqDto> dtoList) {
        return this.resourceApi.importResources(dtoList);
    }

    public RestResponse<Void> registerResources(@RequestBody @Valid ResourceRegisterDto resourceRegisterDto) {
        return this.resourceApi.registerResources(resourceRegisterDto);
    }

    public RestResponse<ResourceQueryResDto> queryResourceByCode(@RequestParam(value="code") String code, @RequestParam(value="res", required=false) List<String> res, @SpringQueryMap ResourceBaseDto resourceDto) {
        return this.resourceQueryApi.queryResourceByCode(code, res, resourceDto);
    }

    public RestResponse<MenuQueryResDto> queryMenuByInstanceIdAndCode(Long instanceId, String code) {
        return this.resourceQueryApi.queryMenuByInstanceIdAndCode(instanceId, code);
    }

    public RestResponse<List<ResourceQueryResDto>> queryResourceParentsByCode(String code) {
        return this.resourceQueryApi.queryResourceParentsByCode(code);
    }

    public RestResponse<PageInfo<ResourceQueryResDto>> queryByPage(@RequestParam(value="filter") String filter, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.resourceQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    public RestResponse<Boolean> checkResourceExist(@RequestBody @Valid ResourceValidateDto resourceValidateDto) {
        return this.resourceQueryApi.checkResourceExist(resourceValidateDto);
    }

    public RestResponse<List<Long>> addRegisterChannel(@RequestParam(value="instanceId") Long instanceId, @PathVariable(value="userId") Long userId, @RequestBody List<RegisterChannelDto> channelDtoList) {
        return this.resourceApi.addRegisterChannel(instanceId, userId, channelDtoList);
    }

    public RestResponse<Long> updateRegisterChannel(@PathVariable(value="channelId") Long channelId, @RequestBody RegisterChannelDto registerChannelDto) {
        return this.resourceApi.updateRegisterChannel(channelId, registerChannelDto);
    }

    public RestResponse<Long> deleteRegisterChannel(@PathVariable(value="channelId") Long channelId) {
        return this.resourceApi.deleteRegisterChannel(channelId);
    }

    public RestResponse<RegisterChannelDto> queryChannelById(@PathVariable(value="id") Long id, @RequestParam(value="filter") String filter) {
        return this.resourceQueryApi.queryChannelById(id, filter);
    }

    public RestResponse<List<RegisterChannelDto>> queryChannelsByApplicationKey(@NotNull @RequestParam(value="instanceId") Long instanceId) {
        return this.resourceQueryApi.queryChannelsByApplicationKey(instanceId);
    }

    public RestResponse<PageInfo<RegisterChannelDto>> queryChannelByExample(@RequestParam(name="example", required=false) String example, @RequestParam(value="filter") String filter, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(name="sort", required=false) String sort) {
        return this.resourceQueryApi.queryChannelByExample(example, filter, pageNum, pageSize, sort);
    }

    public RestResponse<Long> addUserGroup(@RequestParam(value="instanceId") Long instanceId, @PathVariable(value="userId") Long userId, @RequestBody UserGroupDto userGroupDto) {
        return this.resourceApi.addUserGroup(instanceId, userId, userGroupDto);
    }

    public RestResponse<Long> updateUserGroup(@PathVariable(value="groupId") Long groupId, @RequestBody UserGroupDto userGroupDto) {
        return this.resourceApi.updateUserGroup(groupId, userGroupDto);
    }

    public RestResponse<Long> deleteUserGroup(@PathVariable(value="groupId") Long groupId) {
        return this.resourceApi.deleteUserGroup(groupId);
    }

    public RestResponse<UserGroupDto> queryUserGroupByApplicationKey(@NotNull @RequestParam(value="instanceId") Long instanceId) {
        return this.resourceQueryApi.queryUserGroupByApplicationKey(instanceId);
    }

    public RestResponse<List<ButtonDto>> queryButtonsByMenuId(@PathVariable(value="menuId") Long menuId, @RequestParam(value="filter") String filter) {
        return this.resourceQueryApi.queryButtonsByMenuId(menuId, filter);
    }

    @Deprecated
    public RestResponse<Long> addButton(@RequestParam(value="instanceId") Long instanceId, @PathVariable(value="menuId") Long menuId, @RequestBody ButtonDto buttonDto) {
        return this.resourceApi.addButton(instanceId, menuId, buttonDto);
    }

    public RestResponse<Long> modifyButton(@PathVariable(value="id") Long id, @RequestBody ButtonDto buttonDto) {
        return this.resourceApi.modifyButton(id, buttonDto);
    }

    public RestResponse<Void> removeButton(@RequestParam(value="instanceId") Long instanceId, @PathVariable(value="id") Long id) {
        return this.resourceApi.removeButton(instanceId, id);
    }

    @Deprecated
    public RestResponse<Long> addMenu(@RequestParam(value="instanceId") Long instanceId, @RequestBody MenuDto menuDto) {
        return this.resourceApi.addMenu(instanceId, menuDto);
    }

    public RestResponse<Long> modifyMenu(@PathVariable(value="id") Long id, @RequestBody MenuDto menuDto) {
        return this.resourceApi.modifyMenu(id, menuDto);
    }

    public RestResponse<Void> remove(@RequestParam(value="instanceId") Long instanceId, @PathVariable(value="id") Long id) {
        return this.resourceApi.remove(instanceId, id);
    }

    public RestResponse<Void> removeUserRoles(@PathVariable(value="groupId") Long groupId, @PathVariable(value="roleIds") Long[] roleIds) {
        return this.resourceApi.removeUserRoles(groupId, roleIds);
    }
}

