/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.apiimpl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.IAreaApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.biz.service.IAreaService;
import com.dtyunxi.yundt.cube.center.data.biz.service.IAreaSyncService;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaEo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service(value="areaApi")
@Validated
public class AreaApiImpl
implements IAreaApi {
    @Autowired
    IAreaService iAreaService;
    @Autowired
    IAreaSyncService areaSyncService;

    public RestResponse<Void> removeById(Long areaId) {
        if (this.iAreaService.removeById(areaId)) {
            return RestResponse.VOID;
        }
        return RestResponse.FAIL;
    }

    public RestResponse<Long> saveArea(AreaDto areaDto) {
        AreaEo areaEo = new AreaEo();
        DtoHelper.dto2Eo((BaseVo)areaDto, (BaseEo)areaEo);
        this.setCaCode(areaDto, areaEo);
        return new RestResponse((Object)this.iAreaService.saveArea(areaEo));
    }

    private void setCaCode(AreaDto areaDto, AreaEo areaEo) {
        if (StringUtils.isNotEmpty((CharSequence)areaDto.getCode()) && areaDto.getCode().length() >= 6) {
            areaEo.setCaCode(areaDto.getCode().substring(0, 6));
        } else {
            areaEo.setCaCode(areaDto.getCode());
        }
    }

    public RestResponse<Void> modifyArea(AreaDto areaDto) {
        AreaEo areaEo = new AreaEo();
        DtoHelper.dto2Eo((BaseVo)areaDto, (BaseEo)areaEo);
        this.setCaCode(areaDto, areaEo);
        if (this.iAreaService.modifyArea(areaEo)) {
            return RestResponse.VOID;
        }
        return RestResponse.FAIL;
    }

    public RestResponse<Void> sync() {
        this.areaSyncService.sync();
        return RestResponse.VOID;
    }
}

