/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.apiimpl.query;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaComparisionDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaComparisionQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaComparisionQueryApi;
import com.dtyunxi.yundt.cube.center.data.biz.service.IAreaComparisionService;
import com.dtyunxi.yundt.cube.center.data.biz.service.IAreaService;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaComparisionEo;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;

@Service(value="areaComparisionQueryApi")
@Validated
public class AreaComparisionQueryApiImpl
implements IAreaComparisionQueryApi {
    @Autowired
    IAreaComparisionService iAreaComparisionService;
    @Autowired
    IAreaService iAreaService;

    public RestResponse<PageInfo<AreaComparisionDto>> queryByPage(AreaComparisionQueryReqDto areaComparisionQueryReqDto) {
        AreaComparisionEo areaComparisionEo = new AreaComparisionEo();
        DtoHelper.dto2Eo((BaseVo)areaComparisionQueryReqDto, (BaseEo)areaComparisionEo);
        Integer pageNum = areaComparisionQueryReqDto.getPageNum();
        Integer pageSize = areaComparisionQueryReqDto.getPageSize();
        PageInfo<AreaComparisionEo> pageInfoEo = this.iAreaComparisionService.queryByPage(areaComparisionEo, pageNum, pageSize);
        if (!CollectionUtils.isEmpty((Collection)pageInfoEo.getList())) {
            List<AreaComparisionDto> areaComparisionDtoList = this.setAreaName(pageInfoEo.getList());
            pageInfoEo.setList(areaComparisionDtoList);
        }
        return new RestResponse(pageInfoEo);
    }

    public RestResponse<List<AreaComparisionDto>> queryAreaComparisionByThirdArea(String thirdArea, String thirdPlanformCode) {
        AreaComparisionEo areaComparisionEo = new AreaComparisionEo();
        areaComparisionEo.setThirdArea(thirdArea);
        areaComparisionEo.setThirdPlanformCode(thirdPlanformCode);
        List<AreaComparisionEo> areaComparisionEoList = this.iAreaComparisionService.queryAreaByCondition(areaComparisionEo);
        List<AreaComparisionDto> areaComparisionDtoList = this.setAreaName(areaComparisionEoList);
        return new RestResponse(areaComparisionDtoList);
    }

    public RestResponse<List<AreaComparisionDto>> queryAreaComparisionByThirdAreaV3(String thirdArea, String thirdPlanformCode) {
        return this.queryAreaComparisionByThirdArea(thirdArea, thirdPlanformCode);
    }

    public RestResponse<List<AreaComparisionDto>> queryAreaComparision(String areaCode, String thirdPlanformCode) {
        AreaComparisionEo areaComparisionEo = new AreaComparisionEo();
        areaComparisionEo.setAreaCode(areaCode);
        areaComparisionEo.setThirdPlanformCode(thirdPlanformCode);
        List<AreaComparisionEo> areaComparisionEoList = this.iAreaComparisionService.queryAreaByCondition(areaComparisionEo);
        List<AreaComparisionDto> areaComparisionDtoList = this.setAreaName(areaComparisionEoList);
        return new RestResponse(areaComparisionDtoList);
    }

    public RestResponse<List<AreaComparisionDto>> queryAreaComparisionV3(String areaCode, String thirdPlanformCode) {
        return this.queryAreaComparision(areaCode, thirdPlanformCode);
    }

    private List<AreaComparisionDto> setAreaName(List<AreaComparisionEo> areaComparisionEoList) {
        ArrayList<AreaComparisionDto> areaComparisionRespDtoList = new ArrayList<AreaComparisionDto>(areaComparisionEoList.size());
        if (CollectionUtils.isEmpty(areaComparisionEoList)) {
            return areaComparisionRespDtoList;
        }
        DtoHelper.eoList2DtoList(areaComparisionEoList, areaComparisionRespDtoList, AreaComparisionDto.class);
        HashSet<String> codeSet = new HashSet<String>();
        for (AreaComparisionEo areaComparisionEo : areaComparisionEoList) {
            codeSet.add(areaComparisionEo.getProvinceCode());
            codeSet.add(areaComparisionEo.getCityCode());
            codeSet.add(areaComparisionEo.getAreaCode());
        }
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.addAll(codeSet);
        ArrayList<AreaEo> areaEoList = new ArrayList<AreaEo>();
        int times = codeList.size() % Constants.BATCH_MAX_NUMBER == 0 ? codeList.size() / Constants.BATCH_MAX_NUMBER : codeList.size() / Constants.BATCH_MAX_NUMBER + 1;
        for (int i = 0; i < times; ++i) {
            List<String> subCodeList = codeList.subList(i * Constants.BATCH_MAX_NUMBER, (i + 1) * Constants.BATCH_MAX_NUMBER > codeList.size() ? codeList.size() : (i + 1) * Constants.BATCH_MAX_NUMBER);
            List<AreaEo> areaEos = this.iAreaService.queryByCodes(subCodeList);
            if (areaEos == null) continue;
            areaEoList.addAll(areaEos);
        }
        for (AreaComparisionDto areaComparisionDto : areaComparisionRespDtoList) {
            for (AreaEo areaEo : areaEoList) {
                if (areaEo.getCode().equals(areaComparisionDto.getProvinceCode())) {
                    areaComparisionDto.setProvince(areaEo.getName());
                }
                if (areaEo.getCode().equals(areaComparisionDto.getCityCode())) {
                    areaComparisionDto.setCity(areaEo.getName());
                }
                if (!areaEo.getCode().equals(areaComparisionDto.getAreaCode())) continue;
                areaComparisionDto.setArea(areaEo.getName());
            }
        }
        return areaComparisionRespDtoList;
    }
}

