/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.data.api.constants.RedisKeyConstants;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.WeChatAreaQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.data.biz.service.IAreaService;
import com.dtyunxi.yundt.cube.center.data.dao.das.AreaDas;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaEo;
import com.dtyunxi.yundt.cube.center.data.dao.eo.StdAreaEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AreaServiceImpl
implements IAreaService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AreaDas areaDas;
    @Resource
    private ICacheService cacheService;

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public Long saveArea(AreaEo areaEo) {
        if (areaEo.getCode().equals(areaEo.getParentCode())) {
            throw new BizException(CenterDataExceptionCode.CODE_IS_REPEATED_PARENT_CODE.getCode(), CenterDataExceptionCode.CODE_IS_REPEATED_PARENT_CODE.getMsg());
        }
        AreaEo tempEo = this.queryByCodeForJudge(areaEo.getCode());
        if (null != tempEo) {
            throw new BizException(CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getCode(), CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)areaEo.getParentCode())) {
            areaEo.setParentCode("0");
        }
        if ("0".equals(areaEo.getParentCode())) {
            areaEo.setLevelId(Integer.valueOf(0));
        } else {
            AreaEo parentArea = this.queryByCode(areaEo.getParentCode());
            if (null == parentArea) {
                throw new BizException(CenterDataExceptionCode.AREA_PARENTCODE_NOT_EXISTS.getCode(), CenterDataExceptionCode.AREA_PARENTCODE_NOT_EXISTS.getMsg());
            }
            areaEo.setLevelId(Integer.valueOf((null == parentArea.getLevelId() ? 0 : parentArea.getLevelId()) + 1));
        }
        int flag = this.areaDas.insert((BaseEo)areaEo);
        if (flag != 0) {
            String key = RedisKeyConstants.combineKey((String)"queryByParentCode", (Object[])new Object[]{areaEo.getParentCode()});
            this.cacheService.delCache(key);
            if (areaEo.getLevelId() != null) {
                this.cacheService.delCache(RedisKeyConstants.combineKey((String)"areaCache", (Object[])new Object[]{areaEo.getLevelId() + 1}));
            }
            return areaEo.getId();
        }
        this.logger.info("\u65b0\u589e\u5931\u8d25");
        throw new BizException(CenterDataExceptionCode.AREA_ADD_DEFULT.getCode(), CenterDataExceptionCode.AREA_ADD_DEFULT.getMsg());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public boolean removeById(Long areaId) {
        if (areaId == null) {
            this.logger.info("\u5220\u9664\u533a\u57df\u4fe1\u606f\u5931\u8d25\uff1aID\u4e3a\u7a7a");
            throw new BizException(CenterDataExceptionCode.AREA_DELETE_DEFULT.getCode(), CenterDataExceptionCode.AREA_DELETE_DEFULT.getMsg());
        }
        AreaEo areaEo = this.queryAreaByKey(areaId);
        if (areaEo != null) {
            this.areaDas.deleteById(areaId);
            this.delCache(areaEo, true);
            AreaEo deleteChildrenArea = new AreaEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"parentCode", (Object)areaEo.getCode()));
            deleteChildrenArea.setSqlFilters(sqlFilterList);
            this.delCacheBatch(deleteChildrenArea);
            this.areaDas.delete((BaseEo)deleteChildrenArea);
            return true;
        }
        return false;
    }

    private void delCacheBatch(AreaEo deleteChildrenArea) {
        List areaEoList = this.areaDas.select((BaseEo)deleteChildrenArea);
        if (CollectionUtils.isNotEmpty((Collection)areaEoList)) {
            for (AreaEo eo : areaEoList) {
                this.delCache(eo, false);
            }
            Set levelIdSet = areaEoList.stream().filter(areaEo -> areaEo.getLevelId() != null).map(StdAreaEo::getLevelId).collect(Collectors.toSet());
            for (Integer levelId : levelIdSet) {
                this.cacheService.delCache(RedisKeyConstants.combineKey((String)"areaCache", (Object[])new Object[]{levelId + 1}));
            }
        }
    }

    private void delCache(AreaEo areaEo, boolean delLevelIdCache) {
        this.cacheService.delCache("queryByCode", areaEo.getCode());
        this.cacheService.delCache("queryByParentCode", areaEo.getParentCode());
        if (areaEo.getLevelId() != null && delLevelIdCache) {
            this.cacheService.delCache(RedisKeyConstants.combineKey((String)"areaCache", (Object[])new Object[]{areaEo.getLevelId() + 1}));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public boolean modifyArea(AreaEo areaEo) {
        Long id = areaEo.getId();
        if (id == null) {
            this.logger.info("\u66f4\u65b0\u533a\u57df\u4fe1\u606f\u5931\u8d25\uff1aID\u4e3a\u7a7a");
            throw new BizException(CenterDataExceptionCode.AREA_UPDATE_DEFULT.getCode(), CenterDataExceptionCode.AREA_UPDATE_DEFULT.getMsg());
        }
        AreaEo oldArea = this.queryAreaByKey(id);
        if (oldArea == null) {
            this.logger.info("\u66f4\u65b0\u533a\u57df\u4fe1\u606f\u5931\u8d25\uff1a\u627e\u4e0d\u5230\u5bf9\u5e94ID\u5b9e\u4f53");
            throw new BizException(CenterDataExceptionCode.AREA_UPDATE_DEFULT.getCode(), CenterDataExceptionCode.AREA_UPDATE_DEFULT.getMsg());
        }
        if (!oldArea.getCode().equals(areaEo.getCode())) {
            AreaEo temp = this.queryByCodeForJudge(areaEo.getCode());
            if (null != temp) {
                throw new BizException(CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getCode(), CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg());
            }
            AreaEo updateArea = new AreaEo();
            updateArea.setParentCode(areaEo.getCode());
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"parentCode", (Object)oldArea.getParentCode()));
            updateArea.setSqlFilters(sqlFilterList);
            this.areaDas.updateSelectiveSqlFilter((BaseEo)updateArea);
            this.delCacheBatch(updateArea);
        }
        if (null == areaEo.getParentCode()) {
            areaEo.setLevelId(oldArea.getLevelId());
        } else if (StringUtils.isEmpty((CharSequence)areaEo.getParentCode())) {
            areaEo.setParentCode("0");
            areaEo.setLevelId(Integer.valueOf(0));
        } else if (!oldArea.getParentCode().equals(areaEo.getParentCode())) {
            if ("0".equals(areaEo.getParentCode()) || StringUtils.isEmpty((CharSequence)areaEo.getParentCode())) {
                areaEo.setLevelId(Integer.valueOf(0));
                areaEo.setParentCode("0");
            } else {
                AreaEo parentArea = this.queryByCode(areaEo.getParentCode());
                if (null == parentArea) {
                    throw new BizException(CenterDataExceptionCode.AREA_PARENTCODE_NOT_EXISTS.getCode(), CenterDataExceptionCode.AREA_PARENTCODE_NOT_EXISTS.getMsg());
                }
                areaEo.setLevelId(Integer.valueOf((null == parentArea.getLevelId() ? 0 : parentArea.getLevelId()) + 1));
            }
        } else {
            areaEo.setLevelId(oldArea.getLevelId());
        }
        this.areaDas.updateSelective((BaseEo)areaEo);
        this.delCache(areaEo, true);
        return true;
    }

    @Override
    public AreaEo queryAreaByKey(Long id) {
        AreaEo temp = new AreaEo();
        temp.setId(id);
        return (AreaEo)this.areaDas.selectOne((BaseEo)temp);
    }

    @Override
    public PageInfo<AreaEo> queryByPage(AreaEo areaEo, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = this.areaDas.selectPage((BaseEo)areaEo, pageNum, pageSize);
        if (pageInfo == null) {
            return new PageInfo();
        }
        return pageInfo;
    }

    @Override
    public AreaEo queryByCode(String code) {
        String key = RedisKeyConstants.combineKey((String)"queryByCode", (Object[])new Object[]{code});
        String value = (String)this.cacheService.getCache(key, String.class);
        AreaEo areaEo = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (!"EMPTY_OR_NULL".equals(value)) {
                areaEo = (AreaEo)JSON.parseObject((String)value, AreaEo.class);
            }
        } else {
            AreaEo selectAreaEo = new AreaEo();
            selectAreaEo.setCode(code);
            areaEo = (AreaEo)this.areaDas.selectOne((BaseEo)selectAreaEo);
            if (areaEo == null) {
                this.cacheService.setCache(key, (Object)"EMPTY_OR_NULL");
            } else {
                this.cacheService.setCache(key, (Object)JSON.toJSONString((Object)areaEo));
            }
        }
        return areaEo;
    }

    @Override
    public List<AreaDto> queryByParentCode(String parentCode) {
        String key = RedisKeyConstants.combineKey((String)"queryByParentCode", (Object[])new Object[]{parentCode});
        String value = (String)this.cacheService.getCache(key, String.class);
        ArrayList areaDtoList = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            areaDtoList = JSON.parseArray((String)value, AreaDto.class);
        }
        if (CollectionUtils.isEmpty(areaDtoList)) {
            AreaEo areaEo = new AreaEo();
            areaEo.setParentCode(parentCode);
            areaEo.setOrderBy("id");
            List areaEoList = this.areaDas.select((BaseEo)areaEo);
            if (CollectionUtils.isEmpty((Collection)areaEoList)) {
                return new LinkedList<AreaDto>();
            }
            areaDtoList = new ArrayList(areaEoList.size());
            DtoHelper.eoList2DtoList((Collection)areaEoList, areaDtoList, AreaDto.class);
            ArrayList codeList = new ArrayList(areaEoList.size());
            areaDtoList.forEach(areaDto -> codeList.add(areaDto.getCode()));
            List list = this.areaDas.countChild(codeList);
            block0: for (AreaDto areaDto2 : areaDtoList) {
                areaDto2.setHasChildren(Boolean.valueOf(false));
                for (Map map : list) {
                    if (!areaDto2.getCode().equals(String.valueOf(map.get("parentCode")))) continue;
                    areaDto2.setHasChildren(Boolean.valueOf(true));
                    continue block0;
                }
            }
            if (CollectionUtils.isNotEmpty(areaDtoList)) {
                this.cacheService.setCache(key, (Object)JSON.toJSONString(areaDtoList));
            }
        }
        return areaDtoList;
    }

    @Override
    public AreaEo queryByCodeForJudge(String code) {
        AreaEo selectAreaEo = new AreaEo();
        selectAreaEo.setCode(code);
        return (AreaEo)this.areaDas.selectOne((BaseEo)selectAreaEo);
    }

    @Override
    public List<AreaEo> queryByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return new ArrayList<AreaEo>();
        }
        if (codeList.size() > Constants.BATCH_MAX_NUMBER) {
            throw new BizException(CenterDataExceptionCode.BATCH_MORE_THAN_TWO_HUNDRED_ERROR.getCode(), CenterDataExceptionCode.BATCH_MORE_THAN_TWO_HUNDRED_ERROR.getMsg());
        }
        AreaEo areaEo = new AreaEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"code", (Object)("'" + StringUtils.join(codeList, (String)"','") + "'")));
        areaEo.setSqlFilters(sqlFilterList);
        List areaEoList = this.areaDas.select((BaseEo)areaEo);
        return areaEoList;
    }

    @Override
    public List<AreaTreeRespDto> queryForTree() {
        AreaEo temp = new AreaEo();
        List areaEoList = this.areaDas.select((BaseEo)temp);
        if (CollectionUtils.isEmpty((Collection)areaEoList)) {
            return null;
        }
        ArrayList<AreaTreeRespDto> areaTreeRespDtoList = new ArrayList<AreaTreeRespDto>();
        Map<String, List<AreaEo>> areaMap = areaEoList.stream().collect(Collectors.groupingBy(areaEo -> StringUtils.isEmpty((CharSequence)areaEo.getParentCode()) ? "0" : areaEo.getParentCode()));
        DtoHelper.eoList2DtoList((Collection)areaMap.get("0"), areaTreeRespDtoList, AreaTreeRespDto.class);
        areaMap.remove("0");
        this.getChildArea(areaTreeRespDtoList, areaMap, 10);
        return areaTreeRespDtoList;
    }

    private void getChildArea(List<AreaTreeRespDto> areaTreeRespDtoList, Map<String, List<AreaEo>> areaMap, Integer level) {
        if (level == 0) {
            return;
        }
        areaTreeRespDtoList.forEach(areaTreeDto -> {
            List areaEoList = (List)areaMap.get(areaTreeDto.getCode());
            if (CollectionUtils.isNotEmpty((Collection)areaEoList)) {
                ArrayList<AreaTreeRespDto> areaChildrenDtoList = new ArrayList<AreaTreeRespDto>(areaEoList.size());
                DtoHelper.eoList2DtoList((Collection)areaEoList, areaChildrenDtoList, AreaTreeRespDto.class);
                areaTreeDto.setChildren(areaChildrenDtoList);
                areaMap.remove(areaTreeDto.getCode());
                this.getChildArea(areaChildrenDtoList, areaMap, level - 1);
            }
        });
    }

    @Override
    public List<AreaTreeRespDto> queryForTree(Integer level) {
        List areaEoList = this.areaDas.selectAppointColumn();
        if (CollectionUtils.isEmpty((Collection)areaEoList)) {
            return null;
        }
        ArrayList<AreaTreeRespDto> areaTreeRespDtoList = new ArrayList<AreaTreeRespDto>();
        Map<String, List<AreaEo>> areaMap = areaEoList.stream().collect(Collectors.groupingBy(areaEo -> StringUtils.isEmpty((CharSequence)areaEo.getParentCode()) ? "0" : areaEo.getParentCode()));
        DtoHelper.eoList2DtoList((Collection)areaMap.get("0"), areaTreeRespDtoList, AreaTreeRespDto.class);
        if (level == 1) {
            return areaTreeRespDtoList;
        }
        areaMap.remove("0");
        this.getChildArea(areaTreeRespDtoList, areaMap, level > 1 ? level - 1 : 10);
        return areaTreeRespDtoList;
    }

    @Override
    @Caching(cacheable={@Cacheable(cacheNames={"areaCache"}, key="#level")})
    public List<AreaTreeRespDto> queryByLevelForTree(Integer level) {
        if (level > 3) {
            this.logger.info("\u53ea\u80fd\u67e5\u8be2\u7701\u5e02\u533a\u533a\u57df\u4fe1\u606f\uff0c\u5165\u53c2\u67e5\u8be2\u8857\u9053: {} \u65e0\u6548", (Object)level);
            return new ArrayList<AreaTreeRespDto>();
        }
        if (level == 0) {
            level = 3;
        }
        ArrayList<AreaTreeRespDto> areaTreeRespDtoList = new ArrayList<AreaTreeRespDto>();
        if (level == 1) {
            List areaEos = this.areaDas.selectByParentCodeAppointColumn("0");
            if (CollectionUtils.isNotEmpty((Collection)areaEos)) {
                DtoHelper.eoList2DtoList((Collection)areaEos, areaTreeRespDtoList, AreaTreeRespDto.class);
            }
            return areaTreeRespDtoList;
        }
        List areaEos = new ArrayList();
        if (level == 2) {
            areaEos = this.areaDas.selectByLevelAppointColumn(Integer.valueOf(level - 1));
        } else if (level == 3) {
            areaEos = this.areaDas.selectByLevelAppointColumn(Integer.valueOf(level - 2));
        }
        if (CollectionUtils.isEmpty(areaEos)) {
            return areaTreeRespDtoList;
        }
        Map<String, List<AreaEo>> areaMap = areaEos.stream().collect(Collectors.groupingBy(areaEo -> StringUtils.isEmpty((CharSequence)areaEo.getParentCode()) ? "0" : areaEo.getParentCode()));
        DtoHelper.eoList2DtoList((Collection)areaMap.get("0"), areaTreeRespDtoList, AreaTreeRespDto.class);
        if (level == 3) {
            areaTreeRespDtoList.sort(Comparator.comparing(AreaTreeRespDto::getCode));
            String provinceCode = ((AreaTreeRespDto)areaTreeRespDtoList.get(0)).getCode();
            List<AreaEo> cities = areaMap.get(provinceCode);
            Set cityCodes = cities.stream().map(StdAreaEo::getCode).collect(Collectors.toSet());
            AreaEo queryEo = new AreaEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"parent_code", (Object)StringUtils.join(cityCodes, (String)",")));
            queryEo.setSqlFilters(sqlFilters);
            List countyList = this.areaDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1000));
            Map<String, List<AreaEo>> city2county = countyList.stream().collect(Collectors.groupingBy(StdAreaEo::getParentCode));
            for (String key : city2county.keySet()) {
                areaMap.put(key, city2county.get(key));
            }
        }
        areaMap.remove("0");
        this.getChildArea(areaTreeRespDtoList, areaMap, level > 1 ? level - 1 : 10);
        return areaTreeRespDtoList;
    }

    @Override
    public AreaDto queryByWeChatAreaInfo(WeChatAreaQueryReqDto queryReqDto) {
        Assert.hasText((String)queryReqDto.getCountry(), (String)"\u56fd\u5bb6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue((boolean)"\u4e2d\u56fd".equals(queryReqDto.getCountry()), (String)(queryReqDto.getCountry() + "\u5730\u533a\u4fe1\u606f\u67e5\u8be2\u4e0d\u652f\u6301\uff01"));
        Assert.hasText((String)queryReqDto.getProvince(), (String)"\u7701\u4efd\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)queryReqDto.getCity(), (String)"\u57ce\u5e02\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AreaEo provinceQueryAreaEo = new AreaEo();
        provinceQueryAreaEo.setLevelId(Integer.valueOf(0));
        provinceQueryAreaEo.setWeChatName(queryReqDto.getProvince());
        AreaEo provinceAreaEo = (AreaEo)this.areaDas.selectOne((BaseEo)provinceQueryAreaEo);
        if (provinceAreaEo == null) {
            return null;
        }
        AreaEo cityAreaEo = this.getAreaEo(provinceAreaEo.getCode(), 1, queryReqDto.getCity());
        if (cityAreaEo == null) {
            AreaEo areaEo = this.getAreaEo(provinceAreaEo.getCode());
            if (areaEo == null) {
                return null;
            }
            cityAreaEo = this.getAreaEo(areaEo.getCode(), 2, queryReqDto.getCity());
        }
        AreaDto areaDto = new AreaDto();
        DtoHelper.eo2Dto((BaseEo)cityAreaEo, (BaseVo)areaDto);
        return areaDto;
    }

    private AreaEo getAreaEo(String parentCode) {
        AreaEo queryAreaEo = new AreaEo();
        queryAreaEo.setParentCode(parentCode);
        queryAreaEo.setLevelId(Integer.valueOf(1));
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"name", (Object)StringUtils.join((Iterable)Constants.SKIP_NAME_LIST, (String)",")));
        queryAreaEo.setSqlFilters(sqlFilters);
        return (AreaEo)this.areaDas.selectOne((BaseEo)queryAreaEo);
    }

    private AreaEo getAreaEo(String parentCode, int levelId, String city) {
        AreaEo cityQueryAreaEo = new AreaEo();
        cityQueryAreaEo.setParentCode(parentCode);
        cityQueryAreaEo.setLevelId(Integer.valueOf(levelId));
        cityQueryAreaEo.setWeChatName(city);
        return (AreaEo)this.areaDas.selectOne((BaseEo)cityQueryAreaEo);
    }

    @Override
    public List<AreaTreeRespDto> queryWeChatAreaForTree() {
        ArrayList<AreaTreeRespDto> areaTreeRespDtoList = new ArrayList<AreaTreeRespDto>();
        AreaEo queryAreaEo = new AreaEo();
        List<Integer> weChatLevel = Arrays.asList(0, 1);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"wechat_level", (Object)StringUtils.join(weChatLevel, (String)",")));
        queryAreaEo.setSqlFilters(sqlFilters);
        List areaEoList = this.areaDas.select((BaseEo)queryAreaEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtils.isEmpty((Collection)areaEoList)) {
            return areaTreeRespDtoList;
        }
        List<AreaEo> processedAreaEoList = this.getProcessedAreaEoList(areaEoList);
        Map<String, List<AreaEo>> areaMap = processedAreaEoList.stream().collect(Collectors.groupingBy(areaEo -> StringUtils.isEmpty((CharSequence)areaEo.getParentCode()) ? "0" : areaEo.getParentCode()));
        DtoHelper.eoList2DtoList((Collection)areaMap.get("0"), areaTreeRespDtoList, AreaTreeRespDto.class);
        areaMap.remove("0");
        this.getChildArea(areaTreeRespDtoList, areaMap, 1);
        return areaTreeRespDtoList;
    }

    private List<AreaEo> getProcessedAreaEoList(List<AreaEo> areaEoList) {
        ArrayList<AreaEo> processedAreaEoList = new ArrayList<AreaEo>();
        areaEoList.forEach(areaEo -> {
            if (Constants.SKIP_NAME_LIST.contains(areaEo.getName())) {
                List childAreaEoList = this.areaDas.selectByParentCode(areaEo.getCode());
                if (CollectionUtils.isNotEmpty((Collection)childAreaEoList)) {
                    childAreaEoList.forEach(childAreaEo -> {
                        childAreaEo.setParentCode(areaEo.getParentCode());
                        childAreaEo.setLevelId(Integer.valueOf(2));
                    });
                    processedAreaEoList.addAll(childAreaEoList);
                }
            } else {
                processedAreaEoList.add((AreaEo)areaEo);
            }
        });
        return processedAreaEoList;
    }
}

