/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.data.dao.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.data.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.data.dao.eo.AreaEo;
import com.dtyunxi.yundt.cube.center.data.dao.mapper.AreaMapper;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AreaDas
extends AbstractBaseDas<AreaEo, String> {
    public static final int INSERT_BATCH_SIZE = 1000;

    public List<Map<String, Object>> countChild(List<String> codes) {
        AreaMapper areaMapper = (AreaMapper)this.getMapper();
        return areaMapper.countChild(codes);
    }

    public void updateBatch(List<AreaEo> list) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            for (AreaEo eo : list) {
                this.updateSelective((BaseEo)eo);
            }
        }
    }

    public void deleteBatch(List<AreaEo> list) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            for (AreaEo eo : list) {
                this.delete((BaseEo)eo);
            }
        }
    }

    public List<AreaEo> selectByParentCode(String parentCode) {
        AreaEo queryEo = new AreaEo();
        queryEo.setParentCode(parentCode);
        return this.select((BaseEo)queryEo);
    }

    @Transactional(rollbackFor={Exception.class})
    public void handleAreaSyncData(List<AreaEo> insertAreaEoList, List<AreaEo> updateAreaEoList, List<AreaEo> deleteAreaEoList) {
        this.deleteBatch(deleteAreaEoList);
        if (!CollectionUtils.isEmpty(insertAreaEoList)) {
            int size = insertAreaEoList.size();
            if (size > 1000) {
                for (int i = 0; i < size; i += 1000) {
                    if (i + 1000 > size) {
                        this.insertBatch(insertAreaEoList.subList(i, size));
                        continue;
                    }
                    this.insertBatch(insertAreaEoList.subList(i, i + 1000));
                }
            } else {
                this.insertBatch(insertAreaEoList);
            }
        }
        this.updateBatch(updateAreaEoList);
    }

    public List<AreaEo> selectAppointColumn() {
        AreaMapper areaMapper = (AreaMapper)this.getMapper();
        return areaMapper.selectAppointColumn();
    }

    public List<AreaEo> selectByParentCodeAppointColumn(String parentCode) {
        AreaMapper areaMapper = (AreaMapper)this.getMapper();
        return areaMapper.selectByParentCodeAppointColumn(parentCode);
    }

    public List<AreaEo> selectByLevelAppointColumn(Integer level) {
        AreaMapper areaMapper = (AreaMapper)this.getMapper();
        return areaMapper.selectByLevelAppointColumn(level);
    }
}

