/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.starter.extension.BizIdContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.ConfigQueryReq;
import com.dtyunxi.yundt.cube.center.data.dto.RespPermissionRespDto;
import com.dtyunxi.yundt.cube.center.data.dto.RespPropPermissionReqDto;
import com.dtyunxi.yundt.cube.center.data.enums.PermissionHolderTypeEnum;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.constants.RedisKeyConstants;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.permissions.ApiPropPermissionGrantReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.permissions.ApiPropPermissionReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.permissions.ApiPropPermissionSingleGrantReqDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IApiPropPermissionService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizIdService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizSpaceService;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.func.dao.das.ApiPropPermissionDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ApiPropPermissionEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiPropPermissionServiceImpl
implements IApiPropPermissionService {
    @Resource
    private ApiPropPermissionDas apiPropPermissionDas;
    @Resource
    private IBizSpaceService bizSpaceService;
    @Resource
    private IBizIdService bizIdService;
    @Resource
    private ICacheService cacheService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantBatch(List<ApiPropPermissionGrantReqDto> apiPropPermissionGrantList) {
        if (CollectionUtils.isNotEmpty(apiPropPermissionGrantList)) {
            LinkedList insertList = Lists.newLinkedList();
            apiPropPermissionGrantList.forEach(addReqDto -> {
                ApiPropPermissionEo deleteParam = new ApiPropPermissionEo();
                deleteParam.setDtoCode(addReqDto.getDtoCode());
                deleteParam.setHolderType(addReqDto.getHolderType());
                deleteParam.setHolderCode(addReqDto.getHolderCode());
                this.apiPropPermissionDas.delete((BaseEo)deleteParam);
                insertList.addAll(this.collectPropPermission((ApiPropPermissionGrantReqDto)addReqDto, addReqDto.getPropertyPermissions(), null));
            });
            if (CollectionUtils.isNotEmpty((Collection)insertList)) {
                this.apiPropPermissionDas.insertBatch((List)insertList);
            }
            apiPropPermissionGrantList.forEach(addReqDto -> this.cacheService.delCache(RedisKeyConstants.combineKey((String)"API_PERMISSION", (Object[])new Object[]{addReqDto.getDtoCode(), addReqDto.getHolderType(), addReqDto.getHolderCode()})));
        }
    }

    private List<ApiPropPermissionEo> collectPropPermission(ApiPropPermissionGrantReqDto addReqDto, List<ApiPropPermissionGrantReqDto.PropertyPermission> propertyPermissions, ApiPropPermissionEo parent) {
        LinkedList list = Lists.newLinkedList();
        list.addAll(propertyPermissions.stream().map(propertyPermission -> {
            ApiPropPermissionEo apiPropPermissionEo = new ApiPropPermissionEo();
            BeanUtils.copyProperties((Object)propertyPermission, (Object)apiPropPermissionEo);
            if (propertyPermission.getStatus() == null) {
                apiPropPermissionEo.setStatus(Constants.ENABLE);
            }
            if (parent == null) {
                apiPropPermissionEo.setParentId(Long.valueOf(0L));
                apiPropPermissionEo.setHierarchy(Integer.valueOf(1));
            } else {
                apiPropPermissionEo.setParentId(parent.getId());
                apiPropPermissionEo.setHierarchy(Integer.valueOf(parent.getHierarchy() + 1));
            }
            apiPropPermissionEo.setId(this.apiPropPermissionDas.getId());
            apiPropPermissionEo.setDtoCode(addReqDto.getDtoCode());
            apiPropPermissionEo.setHolderType(addReqDto.getHolderType());
            apiPropPermissionEo.setHolderCode(addReqDto.getHolderCode());
            apiPropPermissionEo.setRemark(addReqDto.getRemark());
            apiPropPermissionEo.setExtension("");
            if (CollectionUtils.isNotEmpty((Collection)propertyPermission.getChildren())) {
                list.addAll(this.collectPropPermission(addReqDto, propertyPermission.getChildren(), apiPropPermissionEo));
            }
            if (parent != null) {
                if (apiPropPermissionEo.getStatus().compareTo(Constants.ENABLE) == 0) {
                    parent.setStatus(Constants.ENABLE);
                }
                if (Constants.ENABLE.equals(apiPropPermissionEo.getCreateOp())) {
                    parent.setCreateOp(Constants.ENABLE);
                }
                if (Constants.ENABLE.equals(apiPropPermissionEo.getReadOp())) {
                    parent.setReadOp(Constants.ENABLE);
                }
                if (Constants.ENABLE.equals(apiPropPermissionEo.getUpdateOp())) {
                    parent.setUpdateOp(Constants.ENABLE);
                }
                if (Constants.ENABLE.equals(apiPropPermissionEo.getDeleteOp())) {
                    parent.setDeleteOp(Constants.ENABLE);
                }
            }
            return apiPropPermissionEo;
        }).collect(Collectors.toList()));
        return list;
    }

    private void setHeirarchy(Long parentId, ApiPropPermissionEo apiPropPermissionEo) {
        ApiPropPermissionEo parent = (ApiPropPermissionEo)this.apiPropPermissionDas.selectByPrimaryKey(parentId);
        if (parent == null) {
            apiPropPermissionEo.setHierarchy(Integer.valueOf(0));
        } else {
            if (parent.getHierarchy() == null) {
                apiPropPermissionEo.setHierarchy(Integer.valueOf(1));
                return;
            }
            apiPropPermissionEo.setHierarchy(Integer.valueOf(parent.getHierarchy() + 1));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void grantSingle(ApiPropPermissionSingleGrantReqDto apiPropPermissionReqDto) {
        AssertUtil.isTrue((apiPropPermissionReqDto.getParentId() != null ? 1 : 0) != 0, (String)"\u7236\u5c5e\u6027\u6743\u9650id\u4e0d\u80fd\u4e3a\u7a7a");
        ApiPropPermissionEo deleteParam = new ApiPropPermissionEo();
        deleteParam.setPropertyCode(apiPropPermissionReqDto.getPropertyCode());
        deleteParam.setDtoCode(apiPropPermissionReqDto.getDtoCode());
        deleteParam.setHolderType(apiPropPermissionReqDto.getHolderType());
        deleteParam.setHolderCode(apiPropPermissionReqDto.getHolderCode());
        deleteParam.setParentId(apiPropPermissionReqDto.getParentId());
        this.apiPropPermissionDas.delete((BaseEo)deleteParam);
        ApiPropPermissionEo apiPropPermissionEo = new ApiPropPermissionEo();
        BeanUtils.copyProperties((Object)apiPropPermissionReqDto, (Object)apiPropPermissionEo);
        this.setHeirarchy(apiPropPermissionReqDto.getParentId(), apiPropPermissionEo);
        if (apiPropPermissionEo.getStatus() == null) {
            apiPropPermissionEo.setStatus(Constants.ENABLE);
        }
        this.apiPropPermissionDas.insert((BaseEo)apiPropPermissionEo);
        this.cacheService.delCache(RedisKeyConstants.combineKey((String)"API_PERMISSION", (Object[])new Object[]{apiPropPermissionReqDto.getDtoCode(), apiPropPermissionReqDto.getHolderType(), apiPropPermissionReqDto.getHolderCode()}));
    }

    @Override
    public void remove(String ids) {
        String[] removeIds = ids.split(",");
        ApiPropPermissionEo selectParam = new ApiPropPermissionEo();
        selectParam.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("id", Arrays.asList(removeIds)).get());
        List list = this.apiPropPermissionDas.select((BaseEo)selectParam);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.removeFromDb(removeIds);
            list.forEach(apiPropPermissionEo -> this.cacheService.delCache(RedisKeyConstants.combineKey((String)"API_PERMISSION", (Object[])new Object[]{apiPropPermissionEo.getDtoCode(), apiPropPermissionEo.getHolderType(), apiPropPermissionEo.getHolderCode()})));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeFromDb(String[] ids) {
        for (String id : ids) {
            this.apiPropPermissionDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ApiPropPermissionReqDto queryById(Long id) {
        ApiPropPermissionEo apiPropPermissionEo = (ApiPropPermissionEo)this.apiPropPermissionDas.selectByPrimaryKey(id);
        ApiPropPermissionReqDto apiPropPermissionReqDto = new ApiPropPermissionReqDto();
        DtoHelper.eo2Dto((BaseEo)apiPropPermissionEo, (BaseVo)apiPropPermissionReqDto);
        return apiPropPermissionReqDto;
    }

    @Override
    public PageInfo<ApiPropPermissionReqDto> queryByPage(ApiPropPermissionReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        ApiPropPermissionEo apiPropPermissionEo = new ApiPropPermissionEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)apiPropPermissionEo);
        PageInfo eoPageInfo = this.apiPropPermissionDas.selectPage((BaseEo)apiPropPermissionEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ApiPropPermissionReqDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public RespPermissionRespDto list4Holder(RespPropPermissionReqDto respPropPermissionReqDto) {
        if (respPropPermissionReqDto.getBizIdContext() == null) {
            respPropPermissionReqDto.setBizIdContext(new BizIdContext());
        }
        if (respPropPermissionReqDto.getBizIdContext().getReqInstanceId() == null) {
            respPropPermissionReqDto.getBizIdContext().setReqInstanceId(ServiceContext.getContext().getRequestInstanceId());
        }
        ConfigQueryReq configQueryReq = new ConfigQueryReq();
        configQueryReq.setBizIdContext(respPropPermissionReqDto.getBizIdContext());
        configQueryReq.setCode(respPropPermissionReqDto.getDtoCode());
        configQueryReq.setBizObjs(respPropPermissionReqDto.getBizObjs());
        respPropPermissionReqDto.setType(PermissionHolderTypeEnum.BUSINESS_ID.getValue());
        RespPropPermissionReqDto application = new RespPropPermissionReqDto();
        application.setCode(respPropPermissionReqDto.getBizIdContext().getReqInstanceId() == null ? null : respPropPermissionReqDto.getBizIdContext().getReqInstanceId() + "");
        application.setType(PermissionHolderTypeEnum.APPLICATION.getValue());
        RespPropPermissionReqDto bizSpace = new RespPropPermissionReqDto();
        bizSpace.setType(PermissionHolderTypeEnum.BUSINESS_SPACE.getValue());
        String bizSpaceCode = this.bizSpaceService.readBizSpaceCode(configQueryReq);
        if (StringUtils.isNotEmpty((CharSequence)bizSpaceCode)) {
            respPropPermissionReqDto.setCode(this.bizIdService.queryBizIdCode(configQueryReq, bizSpaceCode));
            bizSpace.setCode(bizSpaceCode);
        }
        RespPermissionRespDto respPermissionRespDto = this.searchPermissions(respPropPermissionReqDto, application, bizSpace);
        return respPermissionRespDto;
    }

    protected RespPermissionRespDto searchPermissions(RespPropPermissionReqDto bizId, RespPropPermissionReqDto application, RespPropPermissionReqDto bizSpace) {
        RespPermissionRespDto result = this.search0(bizId, "API_PERMISSION", bizId.getDtoCode());
        if ((result == null || CollectionUtils.isEmpty((Collection)result.getProperties())) && ((result = this.search0(application, "API_PERMISSION", bizId.getDtoCode())) == null || CollectionUtils.isEmpty((Collection)result.getProperties()))) {
            result = this.search0(bizSpace, "API_PERMISSION", bizId.getDtoCode());
        }
        return result;
    }

    protected RespPermissionRespDto search0(RespPropPermissionReqDto permissionReqDto, String keyPrefix, String dtoCode) {
        String key;
        RespPermissionRespDto result = null;
        if (StringUtils.isNotEmpty((CharSequence)permissionReqDto.getCode()) && (result = (RespPermissionRespDto)this.cacheService.getCache(key = RedisKeyConstants.combineKey((String)keyPrefix, (Object[])new Object[]{dtoCode, permissionReqDto.getType(), permissionReqDto.getCode()}), RespPermissionRespDto.class)) == null) {
            List<ApiPropPermissionEo> eoList = StringUtils.isEmpty((CharSequence)permissionReqDto.getCode()) ? null : this.searchFromDb(dtoCode, permissionReqDto.getCode(), permissionReqDto.getType());
            result = this.collectionAndCache(permissionReqDto.getDtoCode(), key, eoList);
        }
        return result;
    }

    protected List<ApiPropPermissionEo> searchFromDb(String dtoCode, String holderCode, int holderType) {
        ApiPropPermissionEo apiPropPermissionEo = new ApiPropPermissionEo();
        apiPropPermissionEo.setDtoCode(dtoCode);
        apiPropPermissionEo.setHolderCode(holderCode);
        apiPropPermissionEo.setHolderType(Integer.valueOf(holderType));
        apiPropPermissionEo.setStatus(Constants.ENABLE);
        apiPropPermissionEo.setOrderBy("hierarchy");
        return this.apiPropPermissionDas.select((BaseEo)apiPropPermissionEo, Integer.valueOf(0), Integer.valueOf(1000));
    }

    protected RespPermissionRespDto collectionAndCache(String dtoCode, String key, List<ApiPropPermissionEo> eoList) {
        HashMap parents = Maps.newHashMap();
        RespPermissionRespDto respPermissionRespDto = new RespPermissionRespDto();
        if (CollectionUtils.isNotEmpty(eoList)) {
            LinkedList properties = new LinkedList();
            eoList.forEach(eo -> {
                RespPermissionRespDto.Property property = new RespPermissionRespDto.Property();
                property.setPropertyCode(eo.getPropertyCode());
                property.setPermissions(new boolean[]{Constants.ENABLE.equals(eo.getCreateOp()), Constants.ENABLE.equals(eo.getReadOp()), Constants.ENABLE.equals(eo.getUpdateOp()), Constants.ENABLE.equals(eo.getDeleteOp())});
                RespPermissionRespDto.Property parent = (RespPermissionRespDto.Property)parents.get(eo.getParentId());
                if (parent != null) {
                    if (parent.getChildrens() == null) {
                        parent.setChildrens((List)Lists.newArrayList());
                    }
                    parent.getChildrens().add(property);
                } else {
                    properties.add(property);
                }
                parents.put(eo.getId(), property);
            });
            respPermissionRespDto.setProperties(properties);
            respPermissionRespDto.setDtoCode(dtoCode);
            this.cacheService.setCache(key, (Object)respPermissionRespDto, 300);
            return respPermissionRespDto;
        }
        this.cacheService.setCache(key, (Object)respPermissionRespDto, 300);
        return null;
    }
}

