/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.starter.extension.BizIdContext;
import com.dtyunxi.cube.starter.extension.config.SettingLocalCache;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.ConfigQueryReq;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BizExtImplQueryResp;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BizParamQueryResp;
import com.dtyunxi.yundt.cube.center.func.api.dto.conf.BizConfOption;
import com.dtyunxi.yundt.cube.center.func.api.dto.conf.BizConfQueryResp;
import com.dtyunxi.yundt.cube.center.func.api.dto.conf.BizConfigBatchQueryReq;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizConfService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizIdService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizSpaceService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISettingService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISettingValueService;
import com.dtyunxi.yundt.cube.center.func.biz.service.domain.SettingCandidateValue;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingOptionDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtImplEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingOptionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingOptionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingValueEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;

@Service
public class BizConfService
implements IBizConfService {
    private static final Logger logger = LoggerFactory.getLogger(BizConfService.class);
    @Resource
    private SettingOptionDas settingOptionDas;
    @Resource
    private ISettingService settingService;
    @Resource
    private IBizSpaceService bizSpaceService;
    @Resource
    private IBizIdService bizIdService;
    @Resource
    private BizExtImplDas bizExtImplDas;
    @Resource
    private ISettingValueService settingValueService;

    @Override
    @Caching(cacheable={@Cacheable(cacheNames={"idConfCache"}, keyGenerator="idKeyGenerator", unless="#result?.bizCodeId == null || #result?.idValues?.size()==0"), @Cacheable(cacheNames={"spaceConfCache"}, keyGenerator="spaceKeyGenerator", unless="#result?.spaceValues?.size()==0"), @Cacheable(cacheNames={"tenantConfCache"}, keyGenerator="tenantKeyGenerator", unless="#result?.tenantValues?.size()==0"), @Cacheable(cacheNames={"globalConfCache"}, keyGenerator="globalKeyGenerator", unless="#result?.globalValues?.size()==0")})
    public BizParamQueryResp queryValue(ConfigQueryReq configQueryReq) {
        this.logBizEnv(configQueryReq.getCode(), "\u4e1a\u52a1\u53c2\u6570");
        String bizIdCode = configQueryReq.getBidIdCode();
        String bizSpaceCode = this.bizSpaceService.readBizSpaceCode(configQueryReq);
        String settingCode = configQueryReq.getCode();
        if (this.needIdentity(bizIdCode, bizSpaceCode)) {
            bizIdCode = this.bizIdService.queryBizIdCode(configQueryReq, bizSpaceCode);
        }
        SettingCandidateValue candidateValue = this.settingValueService.queryCandidateValue(settingCode);
        SettingCandidateValue.Value resultValue = candidateValue.readValues(bizIdCode, bizSpaceCode);
        BizParamQueryResp resp = new BizParamQueryResp();
        resp.setBizCodeId(resultValue.getBizIdCode());
        resp.setIdValues(this.afterSortOptionValues(settingCode, resultValue.getIdValueEos()));
        resp.setSpaceValues(this.afterSortOptionValues(settingCode, resultValue.getSpaceValueEos()));
        resp.setTenantValues(this.afterSortOptionValues(settingCode, resultValue.getTenantValueEos()));
        resp.setGlobalValues(this.afterSortOptionValues(settingCode, resultValue.getGlobalValueEos()));
        List values = resp.readValues();
        if (CollectionUtils.isNotEmpty((Collection)values)) {
            resp.setValue((String)values.get(0));
        }
        SettingLocalCache.putIntoServiceContext((String)resp.getBizCodeId());
        return resp;
    }

    private ServiceContext logBizEnv(String confCode, String confType) {
        ServiceContext context = ServiceContext.getContext();
        logger.info("{}code:{},ServiceContext : tenantId={},appId={},instanceId={}", new Object[]{confType, confCode, context.getRequestTenantId(), context.getRequestApplicationId(), context.getRequestInstanceId()});
        return context;
    }

    @Override
    @Caching(cacheable={@Cacheable(cacheNames={"idConfCache"}, keyGenerator="idKeyGenerator", unless="#result?.bizCodeId == null || #result?.idValues?.size()==0"), @Cacheable(cacheNames={"spaceConfCache"}, keyGenerator="spaceKeyGenerator", unless="#result?.spaceValues?.size()==0"), @Cacheable(cacheNames={"tenantConfCache"}, keyGenerator="tenantKeyGenerator", unless="#result?.tenantValues?.size()==0"), @Cacheable(cacheNames={"globalConfCache"}, keyGenerator="globalKeyGenerator", unless="#result?.globalValues?.size()==0")})
    public BizExtImplQueryResp queryImpl(ConfigQueryReq configQueryReq) {
        this.logBizEnv(configQueryReq.getCode(), "\u6269\u5c55\u70b9");
        String bizSpaceCode = this.bizSpaceService.readBizSpaceCode(configQueryReq);
        String settingCode = configQueryReq.getCode();
        String bizIdCode = configQueryReq.getBidIdCode();
        if (this.needIdentity(bizIdCode, bizSpaceCode)) {
            bizIdCode = this.bizIdService.queryBizIdCode(configQueryReq, bizSpaceCode);
        }
        SettingCandidateValue candidateValue = this.settingValueService.queryCandidateValue(settingCode);
        SettingCandidateValue.Value resultValue = candidateValue.readValues(bizIdCode, bizSpaceCode);
        BizExtImplQueryResp resp = new BizExtImplQueryResp();
        resp.setBizCodeId(resultValue.getBizIdCode());
        resp.setIdValues(resultValue.getIdValues());
        resp.setSpaceValues(resultValue.getSpaceValues());
        resp.setTenantValues(resultValue.getTenantValues());
        resp.setGlobalValues(resultValue.getGlobalValues());
        resp.setIdValues(this.afterSortOptionValues(settingCode, resultValue.getIdValueEos()));
        resp.setSpaceValues(this.afterSortOptionValues(settingCode, resultValue.getSpaceValueEos()));
        resp.setTenantValues(this.afterSortOptionValues(settingCode, resultValue.getTenantValueEos()));
        resp.setGlobalValues(this.afterSortOptionValues(settingCode, resultValue.getGlobalValueEos()));
        SettingLocalCache.putIntoServiceContext((String)resp.getBizCodeId());
        return resp;
    }

    private boolean needIdentity(String bizIdCode, String bizSpaceCode) {
        return ("DEFAULT_BID_ID_CODE".equals(bizIdCode) || StringUtils.isBlank((CharSequence)bizIdCode)) && null != bizSpaceCode;
    }

    private List<String> afterSortOptionValues(String settingCode, List<SettingValueEo> settingValueEos) {
        if (CollectionUtils.isEmpty(settingValueEos)) {
            return new ArrayList<String>();
        }
        Map optionCode2Value = settingValueEos.stream().filter(valueEo -> StringUtils.isNotBlank((CharSequence)valueEo.getOptionCode())).collect(Collectors.toMap(StdSettingValueEo::getOptionCode, Function.identity(), (k1, k2) -> k1));
        if (CollectionUtils.isNotEmpty(optionCode2Value.keySet())) {
            SettingOptionEo queryOptionEo = new SettingOptionEo();
            queryOptionEo.setSettingCode(settingCode);
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(optionCode2Value.keySet(), (String)",")));
            queryOptionEo.setSqlFilters(sqlFilters);
            List resultOptions = this.settingOptionDas.select((BaseEo)queryOptionEo);
            ArrayList<String> values = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty((Collection)resultOptions)) {
                resultOptions.sort(Comparator.comparing(StdSettingOptionEo::getSort, Comparator.nullsLast(Integer::compareTo)).thenComparing(StdSettingOptionEo::getCode, String.CASE_INSENSITIVE_ORDER));
                resultOptions.forEach(optionEo -> {
                    SettingValueEo valueEo = (SettingValueEo)optionCode2Value.get(optionEo.getCode());
                    values.add(valueEo.getSettingValue());
                });
                return values;
            }
        }
        return settingValueEos.stream().map(StdSettingValueEo::getSettingValue).collect(Collectors.toList());
    }

    @Override
    public RestResponse<List<BizConfQueryResp>> queryConfOptionsByCodes(BizConfigBatchQueryReq configQueryReq) {
        List<Object> resultList = new ArrayList();
        Set codes = configQueryReq.getCodes();
        if (CollectionUtils.isEmpty((Collection)codes)) {
            resultList = new ArrayList();
        } else {
            HashSet<String> resultCodes = new HashSet<String>();
            for (String code : codes) {
                if (!BizConfService.validCode(code)) continue;
                resultCodes.add(code);
            }
            if (CollectionUtils.isNotEmpty(resultCodes)) {
                codes.removeAll(resultCodes);
                BizIdContext bizIdContext = configQueryReq.getBizIdContext();
                if (bizIdContext == null) {
                    bizIdContext = BizIdContext.build();
                }
                List<BizConfQueryResp> settingOptionList = this.querySettingByCode(resultCodes, bizIdContext);
                resultList = this.getBizConfQueryResp(resultCodes, settingOptionList);
            }
            if (CollectionUtils.isNotEmpty((Collection)codes)) {
                logger.info("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4e0d\u7b26\u5408\u89c4\u8303\u7684\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)codes));
            }
        }
        return new RestResponse(resultList);
    }

    private static boolean validCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[\\w-.]*$");
        return pattern.matcher(code).matches();
    }

    private List<BizConfQueryResp> getBizConfQueryResp(Set<String> codes, List<BizConfQueryResp> paramList) {
        ArrayList<Object> resultList = new ArrayList<BizConfQueryResp>();
        Map<Object, Object> confMap = CollectionUtils.isNotEmpty(paramList) ? paramList.stream().collect(Collectors.toMap(BizConfQueryResp::getConfCode, Function.identity())) : new HashMap();
        if (!confMap.isEmpty()) {
            resultList = new ArrayList();
            for (String code : codes) {
                BizConfQueryResp resp = (BizConfQueryResp)confMap.get(code);
                if (resp == null) {
                    resp = BizConfQueryResp.empty((String)code);
                }
                resultList.add(resp);
            }
        }
        return resultList;
    }

    private List<BizConfQueryResp> querySettingByCode(Set<String> codes, BizIdContext bizIdContext) {
        ArrayList<BizConfQueryResp> resultList = new ArrayList<BizConfQueryResp>();
        for (String code : codes) {
            List options;
            ConfigQueryReq configQueryReq = new ConfigQueryReq().setBizIdContext(bizIdContext).setCode(code);
            BizParamQueryResp paramResp = this.queryValue(configQueryReq);
            List<String> values = new ArrayList();
            if (paramResp == null) continue;
            if (CollectionUtils.isNotEmpty((Collection)paramResp.getValues())) {
                values = paramResp.getValues();
            } else {
                if (paramResp.getValue() == null) continue;
                values.add(paramResp.getValue());
            }
            if (this.settingService.isChoiceSetting(code)) {
                SettingOptionEo criteria = new SettingOptionEo();
                criteria.setSettingCode(code);
                criteria.setDr(0);
                criteria.setSqlFilters(new ArrayList());
                SqlFilter implCodeCriteria = new SqlFilter();
                implCodeCriteria.setProperty("option_value");
                implCodeCriteria.setOperator(SqlFilter.Operator.in);
                implCodeCriteria.setValue(values);
                criteria.getSqlFilters().add(implCodeCriteria);
                List optionEos = this.settingOptionDas.select((BaseEo)criteria, Integer.valueOf(0), Integer.valueOf(1000));
                optionEos.sort(Comparator.comparing(StdSettingOptionEo::getSort, Comparator.nullsLast(Integer::compareTo)).thenComparing(StdSettingOptionEo::getCode, String.CASE_INSENSITIVE_ORDER));
                options = optionEos.stream().map(eo -> BizConfOption.build((String)eo.getOptionValue(), (String)eo.getName(), (String)eo.getDescr())).collect(Collectors.toList());
            } else {
                options = values.stream().map(value -> BizConfOption.build((String)value, null, null)).collect(Collectors.toList());
            }
            BizConfQueryResp confResp = new BizConfQueryResp().setConfCode(code).setOptions(options);
            resultList.add(confResp);
        }
        return resultList;
    }

    private List<BizConfQueryResp> queryExtByCode(Set<String> codes, BizIdContext bizIdContext) {
        ArrayList<BizConfQueryResp> resultList = new ArrayList<BizConfQueryResp>();
        for (String code : codes) {
            ConfigQueryReq configQueryReq;
            BizExtImplQueryResp extResp;
            if (!code.contains(".ext.") || (extResp = this.queryImpl(configQueryReq = new ConfigQueryReq().setBizIdContext(bizIdContext).setCode(code))) == null || extResp.getValues() != null) continue;
            List implCodes = extResp.getValues();
            BizExtImplEo criteria = new BizExtImplEo();
            criteria.setBextCode(code);
            criteria.setDr(0);
            criteria.setTenantId(ServiceContext.getContext().getRequestTenantId());
            criteria.setSqlFilters(new ArrayList());
            SqlFilter implCodeCriteria = new SqlFilter();
            implCodeCriteria.setProperty("bext_impl_code");
            implCodeCriteria.setOperator(SqlFilter.Operator.in);
            implCodeCriteria.setValue((Object)implCodes);
            criteria.getSqlFilters().add(implCodeCriteria);
            List implEos = this.bizExtImplDas.select((BaseEo)criteria, Integer.valueOf(0), Integer.valueOf(1000));
            List options = implEos.stream().map(eo -> BizConfOption.build((String)eo.getBextImplCode(), (String)eo.getBextImplName(), (String)eo.getBextImplDesc())).collect(Collectors.toList());
            BizConfQueryResp confResp = new BizConfQueryResp().setConfCode(code).setOptions(options);
            resultList.add(confResp);
        }
        return resultList;
    }
}

