package com.dtyunxi.yundt.cube.center.channel.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;

/**
* 渠道账号信息Eo对象
*
* @author 代码生成器
*/
@ApiModel(value = "ChannelOfficeAccountReqDto", description = "渠道账号信息Eo对象")
public class ChannelAccountReqDto extends RequestDto{

    /**
    *  渠道账号id
    */
    @ApiModelProperty(name = "id", value = "渠道账号id")
    private Long id;

    /**
    *  渠道账号名称
    */
    @ApiModelProperty(name = "name", value = "渠道账号名称")
    private String name;

    /**
     * 账号
     */
    @Column(name = "account")
    private String account;

    /**
    *  渠道账号类型类型[0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook]
    */
    @ApiModelProperty(name = "type", value = "渠道账号类型[0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook 8企业微信]")
    private Integer type;

    /**
     * 配置JSON
     */
    @Column(name = "配置JSON[例如微信的渠道配置例子：{\"appid\": \"APPID\",\"appsecret\": \"APPSECRET\"}]")
    private String config;

    /**
    *  渠道账号头像
    */
    @ApiModelProperty(name = "headImg", value = "渠道账号头像")
    private String headImg;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name){
    this.name = name;
    }
    public String getName(){
    return this.name;
    }

    public void setType(Integer type){
    this.type = type;
    }
    public Integer getType(){
    return this.type;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getConfig() {
        return config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setHeadImg(String headImg){
    this.headImg = headImg;
    }
    public String getHeadImg(){
    return this.headImg;
    }

}