package com.dtyunxi.yundt.cube.center.channel.api.dto.wechat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;

/**
 * 获取指定渠道消息模板列表参数
 *
 * @author : 萧玄
 * @Date: 17:02 2020/12/9
 */
@ApiModel("获取指定渠道消息模板列表参数")
public class ChannelMsgTplReqDto {

    @Min(value = 0,message = "渠道类型最小值为0")
    @Max(value = 6,message = "渠道类型最大值为6")
    @ApiModelProperty(name = "渠道类型[0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook]")
    private Integer type = 0;

    @ApiModelProperty(name = "渠道账号id")
    @NotEmpty(message = "必须指定渠道账号id")
    private String accountId;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }
}
