package com.dtyunxi.yundt.cube.center.channel.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.channel.api.dto.ChannelMsgTemplate;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.ChannelAccountQueryReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.ChannelAccountReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 渠道账号信息服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"渠道账号信息服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-channel-api-query-IChannelAccountQueryApi",
        name = "${bundle.channel.center.data.name:bundle-channel-center-data}", path = "/v1/channel-account", url = "${bundle.channel.center.data.api:}")
public interface IChannelAccountQueryApi {

    /**
     * 根据id查询渠道账号信息
     *
     * @param id 渠道账号信息id
     * @return 渠道账号信息数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询渠道账号信息", notes = "根据id查询渠道账号信息")
    @Capability(capabilityCode = "basic-data.channel-account.query-by-id")
    RestResponse<ChannelAccountReqDto> queryById(@PathVariable("id") Long id);

    /**
     * 渠道账号信息分页数据
     *
     * @param channelAccountQueryReqDto 渠道账号信息查询条件
     * @return 渠道账号信息分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "渠道账号信息分页数据",hidden = true)
    @Capability(capabilityCode = "basic-data.channel-account.query-by-page")
    RestResponse<PageInfo<ChannelAccountReqDto>> queryByPage(@SpringQueryMap ChannelAccountQueryReqDto channelAccountQueryReqDto);

    /**
     * 查询指定渠道的原生消息模板列表
     *
     * @param channelAccountId 渠道账号id
     * @return 渠道账号信息分页数据
     */
    @GetMapping("/msg-template/{channel-account-id}/list")
    @ApiOperation(value = "根据id查询指定渠道的消息模板列表",hidden = true)
    @Deprecated
    RestResponse<ChannelMsgTemplate> queryMsgTemplateList(@PathVariable("channel-account-id") Long channelAccountId);

    /**
     * 获取渠道账号accessToken
     *
     * @param channelAccountId 获取微信公众号accessToken参数
     * @param refresh
     * @return 处理结果
     */
    @GetMapping("/{channel-account-id}/access-token")
    @ApiOperation(value = "根据id获取渠道账号accessToken",hidden = true)
    @Deprecated
    RestResponse<String> getAccessToken(@PathVariable("channel-account-id") Long channelAccountId, @RequestParam("refresh") boolean refresh);

    /**
     * 查询指定渠道的原生消息模板列表
     *
     * @param channelAccount 获取微信公众号accessToken参数
     * @param type 获取微信公众号accessToken参数
     *
     * @return 渠道账号信息分页数据
     */
    @GetMapping("/msg-template/{type}/{channel-account}/list")
    @ApiOperation(value = "获取指定渠道账号的消息模板列表",hidden = true)
    @Deprecated
    RestResponse<ChannelMsgTemplate> queryMsgTemplateList(@PathVariable("channel-account") String channelAccount, @PathVariable("type") Integer type);


    /**
     * 获取渠道账号accessToken
     *
     * @param channelAccount 获取微信公众号accessToken参数
     * @param type           获取微信公众号accessToken参数
     *
     * @param refresh
     * @return accessToken
     */
    @GetMapping("/{type}/{channel-account}/access-token")
    @ApiOperation(value = "获取指定渠道账号的accessToken",hidden = true)
    @Deprecated
    RestResponse<String> getAccessToken(@PathVariable("channel-account") String channelAccount, @PathVariable("type") Integer type, @RequestParam(value = "refresh",defaultValue = "false") boolean refresh);
}
