package com.dtyunxi.yundt.cube.center.channel.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.ChannelAccountReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 渠道账号信息服务接口
*
* @author 代码生成器
*/
@Api(tags = {"渠道账号信息服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-channel-api-IChannelAccountApi",
        name = "${bundle.channel.center.data.name:bundle-channel-center-data}", path = "/v1/channel-account", url = "${bundle.channel.center.data.api:}")
public interface IChannelAccountApi {

    /**
    * 新增渠道账号信息
    *
    *
     * @param addReqDto 渠道账号信息请求对象
     * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增渠道账号信息", notes = "新增渠道账号信息")
    @Capability(capabilityCode = "basic-data.channel-account.add")
    RestResponse<Long> add(@RequestBody ChannelAccountReqDto addReqDto);

    /**
    * 修改渠道账号信息
    *
    *
     * @param id
     * @param modifyReqDto 渠道账号信息请求对象
     * @return 处理结果
    */
    @PutMapping("/{id}")
    @ApiOperation(value = "修改渠道账号信息", notes = "修改渠道账号信息")
    @Capability(capabilityCode = "basic-data.channel-account.modify")
    RestResponse<Void> modify(@PathVariable("id") Long id, @RequestBody ChannelAccountReqDto modifyReqDto);

    /**
    * 删除渠道账号信息
    *
    * @param ids        渠道账号信息删除数据ID
    * @return 处理结果
    */
    @DeleteMapping("")
    @ApiOperation(value = "删除渠道账号信息", notes = "删除渠道账号信息")
    @Capability(capabilityCode = "basic-data.channel-account.remove")
    RestResponse<Void> remove(@RequestParam("ids") String ids);

}
