package com.dtyunxi.yundt.cube.center.channel.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.channel.api.dto.ChannelMsgTemplate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 外部渠道数据服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"外部渠道数据服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-channel-api-query-IExternalChannelDataApi",
        name = "${bundle.channel.center.data.name:bundle-channel-center-data}", path = "/v1/external-channel", url = "${bundle.channel.center.data.api:}")
public interface IExternalChannelDataApi {

    /**
     * 查询指定渠道的原生消息模板列表
     *
     * @param channelAccountId 渠道账号id
     * @return 外部渠道数据分页数据
     */
    @GetMapping("/msg-template/{channel-account-id}/list")
    @ApiOperation(value = "根据id查询指定渠道的消息模板列表", notes = "根据filter查询条件查询外部渠道数据数据，filter=ChannelOfficeAccountReqDto")
    @Capability(capabilityCode = "basic-data.external-channel.msg-template-list-of-id")
    RestResponse<ChannelMsgTemplate> queryMsgTemplateList(@PathVariable("channel-account-id") Long channelAccountId);

    /**
     * 获取渠道账号accessToken
     *
     * @param channelAccountId 获取微信公众号accessToken参数
     * @param refresh
     * @return 处理结果
     */
    @GetMapping("/{channel-account-id}/access-token")
    @ApiOperation(value = "根据id获取渠道账号accessToken", notes = "获取渠道账号accessToken")
    @Capability(capabilityCode = "basic-data.external-channel.access-token-of-id")
    RestResponse<String> getAccessToken(@PathVariable("channel-account-id") Long channelAccountId, @RequestParam("refresh") boolean refresh);

    /**
     * 查询指定渠道的原生消息模板列表
     *
     * @param channelAccount 获取微信公众号accessToken参数
     * @param type 获取微信公众号accessToken参数
     *
     * @return 外部渠道数据分页数据
     */
    @GetMapping("/msg-template/{type}/{channel-account}/list")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "channel-account", value = "渠道账号[例如微信的appId]"),
            @ApiImplicitParam(name = "type", value = "渠道账号类型[0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook 8企业微信]"),
    })
    @ApiOperation(value = "获取指定渠道账号的消息模板列表", notes = "根据filter查询条件查询外部渠道数据数据，filter=ChannelOfficeAccountReqDto")
    @Capability(capabilityCode = "basic-data.external-channel.msg-template-list-of-account")
    RestResponse<ChannelMsgTemplate> queryMsgTemplateList(@PathVariable("channel-account") String channelAccount, @PathVariable("type") Integer type);


    /**
     * 获取渠道账号accessToken
     *
     * @param channelAccount 获取微信公众号accessToken参数
     * @param type           获取微信公众号accessToken参数
     *
     * @param refresh
     * @return accessToken
     */
    @GetMapping("/{type}/{channel-account}/access-token")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "channel-account", value = "渠道账号[例如微信的appId]"),
            @ApiImplicitParam(name = "type", value = "渠道账号类型[0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook 8企业微信]"),
            @ApiImplicitParam(name = "refresh", value = "是否强制刷新accessToken，默认不刷新"),
    })
    @ApiOperation(value = "获取指定渠道账号的accessToken", notes = "获取渠道账号的accessToken")
    @Capability(capabilityCode = "basic-data.external-channel.access-token-of-account")
    RestResponse<String> getAccessToken(@PathVariable("channel-account") String channelAccount, @PathVariable("type") Integer type, @RequestParam(value = "refresh",defaultValue = "false") boolean refresh);

    /**
     *  获取渠道账号accessToken
     *
     * @param type           获取微信公众号accessToken参数
     *
     * @param refresh
     * @return accessToken
     */
    @GetMapping("/{type}/access-token/default")
    @ApiImplicitParams(value = {
            @ApiImplicitParam(name = "type", value = "渠道账号类型[0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook 8企业微信]"),
            @ApiImplicitParam(name = "refresh", value = "是否强制刷新accessToken，默认不刷新"),
    })
    @ApiOperation(value = "获取企业微信账号的accessToken，取第一个配置", notes = "获取渠道账号的accessToken")
    @Capability(capabilityCode = "basic-data.external-channel.access-token-of-account")
    RestResponse<String> getAccessToken(@PathVariable("type") Integer type, @RequestParam(value = "refresh",defaultValue = "false") boolean refresh);
}

