/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.channel.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.domain.event.service.IDomainEventService;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.channel.api.dto.WeChatEnterpriseConfigDto;
import com.dtyunxi.yundt.cube.center.channel.api.dto.request.ChannelAccountReqDto;
import com.dtyunxi.yundt.cube.center.channel.api.enums.ChannelAccountTypeEnum;
import com.dtyunxi.yundt.cube.center.channel.biz.config.WeChatEventTypeConfig;
import com.dtyunxi.yundt.cube.center.channel.biz.service.IChannelAccountService;
import com.dtyunxi.yundt.cube.center.channel.biz.service.IWeChatEnterpriseCallbackService;
import com.dtyunxi.yundt.cube.center.channel.event.ChangeContactEventDto;
import com.dtyunxi.yundt.cube.center.channel.event.ChangeExternalContactEventDto;
import com.dtyunxi.yundt.cube.center.channel.wechat.callback.AesException;
import com.dtyunxi.yundt.cube.center.channel.wechat.callback.WXBizMsgCrypt;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeChatEnterpriseCallbackServiceImpl
implements IWeChatEnterpriseCallbackService {
    private static Logger logger = LoggerFactory.getLogger(WeChatEnterpriseCallbackServiceImpl.class);
    @Resource
    private IChannelAccountService channelAccountService;
    @Resource
    private IDomainEventService domainEventService;
    @Autowired(required=false)
    private WeChatEventTypeConfig weChatEventTypeConfig;

    @Override
    public void verifyURL(String account, String msgSignature, Integer timeStamp, String nonce, String echoStr, HttpServletResponse httpServletResponse) {
        WeChatEnterpriseConfigDto configVo = this.getWeChatEnterpriseConfig(account);
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(configVo.getToken(), configVo.getEncodingAESKey(), account);
            String sEchoStr = wxcpt.VerifyURL(msgSignature, timeStamp.toString(), nonce, echoStr);
            logger.info("verifyurl echostr: {}", (Object)sEchoStr);
            httpServletResponse.getOutputStream().print(Long.parseLong(sEchoStr));
        }
        catch (AesException e) {
            logger.info("verifyURL\u8c03\u7528\u5f02\u5e38\uff0c\u9519\u8bef\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getCode(), (Object)e.getMessage());
            logger.error("verifyURL\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new BizException(e.getCode() + "", e.getMessage());
        }
        catch (IOException e) {
            logger.error("verifyURL\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new BizException("500", e.getMessage());
        }
    }

    private WeChatEnterpriseConfigDto getWeChatEnterpriseConfig(String account) {
        ChannelAccountReqDto channelAccountReqDto = this.channelAccountService.queryByAccount(account, ChannelAccountTypeEnum.WECHAT_ENTERPRISE_ACCOUNT.getKey());
        WeChatEnterpriseConfigDto configVo = (WeChatEnterpriseConfigDto)JSONObject.parseObject((String)channelAccountReqDto.getConfig(), WeChatEnterpriseConfigDto.class);
        if (configVo == null) {
            throw new BizException("500", "\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)configVo.getToken())) {
            throw new BizException("500", "\u4f01\u4e1a\u5fae\u4fe1Token\u672a\u914d\u7f6e");
        }
        if (StrUtil.isBlank((CharSequence)configVo.getEncodingAESKey())) {
            throw new BizException("500", "\u4f01\u4e1a\u5fae\u4fe1EncodingAESKey\u672a\u914d\u7f6e");
        }
        return configVo;
    }

    @Override
    public String receiveData(String account, String msgSignature, Integer timeStamp, String nonce, String xmlData) {
        Map<String, Object> mapData = this.decryptData(account, msgSignature, timeStamp, nonce, xmlData);
        return this.handleData(mapData);
    }

    @Override
    public Map<String, Object> decryptData(String account, String msgSignature, Integer timeStamp, String nonce, String xmlData) {
        Map map;
        WeChatEnterpriseConfigDto configVo = this.getWeChatEnterpriseConfig(account);
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(configVo.getToken(), configVo.getEncodingAESKey(), account);
            String sMsg = wxcpt.DecryptMsg(msgSignature, timeStamp.toString(), nonce, xmlData);
            logger.debug("after decrypt msg:{} ", (Object)sMsg);
            map = XmlUtil.xmlToMap((String)sMsg);
        }
        catch (Exception e) {
            logger.info("receiveData\u8c03\u7528\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            logger.error("receiveData\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new BizException("500", e.getMessage());
        }
        return map;
    }

    @Override
    public String handleData(Map<String, Object> mapData) {
        String eventType = MapUtil.getStr(mapData, (Object)"Event", (String)"");
        if (this.weChatEventTypeConfig != null && CollectionUtil.isNotEmpty(this.weChatEventTypeConfig.getWhiteLists())) {
            if (this.weChatEventTypeConfig.getWhiteLists().contains(eventType)) {
                switch (eventType) {
                    case "change_contact": 
                    case "batch_job_result": {
                        this.publishChangeContactEvent(mapData);
                        break;
                    }
                    case "change_external_contact": 
                    case "change_external_chat": 
                    case "change_external_tag": {
                        this.publishChangeExternalContactEvent(mapData);
                        break;
                    }
                    default: {
                        logger.info("\u4e8b\u4ef6\u7c7b\u578b\uff1a{}\u6682\u65e0\u4e1a\u52a1\u65b9\u9700\u8981\u5904\u7406\uff0c\u4e0d\u53d1\u9001\u9886\u57df\u4e8b\u4ef6\uff01", (Object)eventType);
                        break;
                    }
                }
            } else {
                logger.info("\u4e8b\u4ef6\u7c7b\u578b\uff1a{}\u672a\u914d\u7f6e\u767d\u540d\u5355\uff0c\u4e0d\u53d1\u9001\u9886\u57df\u4e8b\u4ef6\uff01", (Object)eventType);
            }
        } else {
            logger.info("\u4f01\u4e1a\u5fae\u4fe1\u4e8b\u4ef6\u8f6c\u53d1\u767d\u540d\u5355\u672a\u914d\u7f6e\uff0c\u4e0d\u53d1\u9001\u9886\u57df\u4e8b\u4ef6\uff01");
        }
        return null;
    }

    private void publishChangeContactEvent(Map<String, Object> mapData) {
        ChangeContactEventDto changeContactEventDto = new ChangeContactEventDto();
        changeContactEventDto.setDataMap(mapData);
        this.domainEventService.publishEvent((Object)changeContactEventDto);
    }

    private void publishChangeExternalContactEvent(Map<String, Object> mapData) {
        ChangeExternalContactEventDto changeExternalContactEventDto = new ChangeExternalContactEventDto();
        changeExternalContactEventDto.setDataMap(mapData);
        this.domainEventService.publishEvent((Object)changeExternalContactEventDto);
    }
}

