
CREATE TABLE IF NOT EXISTS `flw_color_pool`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `rgb` varchar(11)  NULL DEFAULT NULL COMMENT '颜色rgb值',
  `sort` int(4) NOT NULL DEFAULT 0 COMMENT '排序值',
  `remark` varchar(200)  NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程颜色池' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `flw_convert_node`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NOT NULL COMMENT '类全限定名#方法名',
  `name` varchar(64)  NOT NULL COMMENT '名称',
  `input_code` varchar(256)  NOT NULL COMMENT '入参编码',
  `output_code` varchar(256)  NOT NULL COMMENT '出参编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程转换节点' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `flw_doc`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NOT NULL COMMENT '领域编码.类名',
  `domain` varchar(32)  NOT NULL COMMENT '领域编码',
  `name` varchar(64)  NOT NULL COMMENT '名称',
  `status_field` longtext  NULL COMMENT '单据实例 的状态：json格式，例子：{\"orderStatus\", \"业务状态\"}',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程单据' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `flw_node`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NOT NULL COMMENT '类全限定名#方法名',
  `color` varchar(11)  NULL DEFAULT NULL COMMENT '颜色rgb值',
  `name` varchar(64)  NOT NULL COMMENT '名称',
  `input_code` varchar(256)  NOT NULL COMMENT '入参编码',
  `output_code` varchar(256)  NOT NULL COMMENT '出参编码',
  `doc_type` varchar(200)  NOT NULL COMMENT '单据类型',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程处理节点' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `flw_node_convert_map`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `flow_def_id` bigint(20) NOT NULL COMMENT '流程方案ID',
  `prev_node_code` varchar(200)  NOT NULL COMMENT '前置处理节点编码',
  `prev_node_result_code` varchar(200)  NULL DEFAULT NULL COMMENT '前置处理节点结果编码',
  `convert_node_code` varchar(200)  NOT NULL COMMENT '转换节点编码',
  `next_node_code` varchar(200)  NOT NULL COMMENT '后置处理节点编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '处理-转换-处理映射集' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `flw_node_link`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `doc_type` varchar(200)  NULL DEFAULT NULL COMMENT '关联的单据类型, 采用 领域+单据两级编码',
  `flow_def_id` bigint(20) NOT NULL COMMENT '流程方案ID',
  `pre_node_code` varchar(256)  NOT NULL COMMENT '前序节点编码, 处理节点用 类名+\"#\"+方法名,  状态节点用节点id, start表示起点',
  `pre_node_type` tinyint(4) NOT NULL COMMENT '前序节点类型, 可选值 1:预置节点,如start,end  2:处理节点,  3:状态节点',
  `pre_result` varchar(20)  NOT NULL DEFAULT 'succ' COMMENT '前置节点的处理结果. 如果前置是状态节点或预制, 统一为succ.  如果是处理节点,则是处理节点的结果',
  `next_node_code` varchar(256)  NOT NULL COMMENT '后续节点编码, 处理节点用 类名+\"#\"+方法名,  状态节点用节点id, start表示起点',
  `next_node_type` tinyint(4) NOT NULL COMMENT '后续节点类型, 可选值 1:预置节点,如start,end  2:处理节点,  3:状态节点',
  `remark` varchar(200)  NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '节点关联关系' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `flw_node_result`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(64)  NOT NULL COMMENT '编码(节点下唯一)',
  `name` varchar(64)  NOT NULL COMMENT '名称',
  `flw_node_code` varchar(200)  NOT NULL COMMENT '所属流程处理节点编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程处理节点结果' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `flw_node_result_call`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `caller_flw_node_code` varchar(255)  NULL DEFAULT NULL COMMENT '发起回调的节点编码',
  `flw_node_result_code` varchar(64)  NOT NULL COMMENT '流程处理节点结果编码',
  `callee_flw_node_code` varchar(200)  NOT NULL COMMENT '接收回调的节点编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程处理节点结果的回调处理' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `flw_solution`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(50)  NULL DEFAULT NULL COMMENT '流程方案编码，自动生成',
  `version` varchar(20)  NULL DEFAULT NULL COMMENT '流程方案版本，自动生成',
  `cur_show` tinyint(1) NULL DEFAULT NULL COMMENT '当前显示[1为显示，每个流程方案只显示最大的，方便技术实现]',
  `name` varchar(50)  NULL DEFAULT NULL COMMENT '流程方案名称',
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT '' COMMENT '流程方案类型码[交易]',
  `doc_type` varchar(50)  NULL DEFAULT NULL COMMENT '关联的单据类型, 采用 领域+单据两级编码',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '0 禁用  1启用  2草稿',
  `remark` varchar(200)  NULL DEFAULT NULL COMMENT '备注',
  `style` text  NULL COMMENT '流程图样式',
  `extension` longtext  NULL COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '流程方案' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `flw_status`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `doc_type` varchar(200)  NULL DEFAULT NULL COMMENT '关联的单据类型, 采用 领域+单据两级编码',
  `status_field` varchar(50)  NOT NULL DEFAULT 'status' COMMENT '存储状态顺序的字段',
  `read_only` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否只读 0 true 1 false',
  `pre_set` tinyint(1) NULL DEFAULT 0 COMMENT '是否预设 0 不是 1 是',
  `status_code` varchar(50)  NULL DEFAULT NULL COMMENT '状态编码, 同一个流程方案中,状态节点的编码不允许重复',
  `status_name` varchar(50)  NULL DEFAULT NULL COMMENT '状态名称, 同一个流程方案中,状态节点的名称不允许重复',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '0 禁用  1启用  2草稿',
  `color` varchar(11)  NULL DEFAULT NULL COMMENT '颜色rgb值',
  `remark` varchar(200)  NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '状态节点信息' ROW_FORMAT = Dynamic;