/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.bundle.login.log.center.identity.biz.confimpl.ext;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.yundt.cube.bundle.login.log.center.identity.biz.config.LoginLogIndexConfig;
import com.dtyunxi.yundt.cube.bundle.login.log.center.identity.biz.service.ILoginLogService;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.LoginLogAddReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.LoginLogReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.LoginLogRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.conf.ext.ILoginLogManageExt;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@CubeExtImpl(name="\u5199log\u540c\u6b65\u5230es\uff0c\u518d\u4ecees\u67e5\u8be2")
@Component
public class LoginLogManageByEsExtImpl
implements ILoginLogManageExt {
    private static final Logger logger = LoggerFactory.getLogger(LoginLogManageByEsExtImpl.class);
    @Autowired
    private IOpenSearchService openSearchService;
    @Autowired
    private LoginLogIndexConfig loginLogIndexConfig;
    @Autowired
    private ILoginLogService loginLogService;

    public Boolean saveLoginLog(UserLoginReqDto user, UserDto userDto, String token, Integer status) {
        LoginLogAddReqDto addLog = new LoginLogAddReqDto();
        addLog.setLoginChannel(user.getLoginChannel());
        addLog.setLoginSource(user.getLoginSource());
        this.loginLogService.addLoginLog(addLog, userDto.getId().toString(), token, status);
        return true;
    }

    public PageInfo<LoginLogRespDto> queryLoginLog(String filter, Integer pageNum, Integer pageSize) {
        LoginLogReqDto loginLogReqDto;
        try {
            loginLogReqDto = (LoginLogReqDto)ObjectHelper.Json2Bean((String)filter, LoginLogReqDto.class);
        }
        catch (Exception e) {
            throw new BizException(IdentityExceptionCode.FAIL.getCode(), IdentityExceptionCode.FAIL.getMsg());
        }
        Assert.notNull((Object)loginLogReqDto.getBeginTime(), (String)"\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)loginLogReqDto.getEndTime(), (String)"\u67e5\u8be2\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)loginLogReqDto.getBeginTime().before(loginLogReqDto.getEndTime()), (String)"\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u67e5\u8be2\u7ed3\u675f\u65f6\u95f4");
        Assert.isTrue((DateUtil.getDayDiff((Date)loginLogReqDto.getBeginTime(), (Date)loginLogReqDto.getEndTime()) <= 180 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc7180\u5929");
        if (StringUtils.isNotEmpty((CharSequence)loginLogReqDto.getRoleCode())) {
            Assert.isTrue((loginLogReqDto.getRoleCode().split(",").length <= 5 ? 1 : 0) != 0, (String)"\u4e00\u6b21\u6700\u591a\u67e5\u8be25\u4e2a\u89d2\u8272");
        }
        if (pageNum == null || pageNum < 0) {
            pageNum = 1;
        }
        if (pageSize == null || pageSize < 0) {
            pageSize = 20;
        }
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setFetchSource(true);
        osSearchVo.setIndexName(this.loginLogIndexConfig.getIndexName());
        osSearchVo.setTypeName(this.loginLogIndexConfig.getType());
        osSearchVo.addRangeFilter("logTime", DateUtil.getDateFormat((Date)loginLogReqDto.getBeginTime(), (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.getDateFormat((Date)loginLogReqDto.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (StringUtils.isNotBlank((CharSequence)loginLogReqDto.getRoleCode())) {
            osSearchVo.addQuery(loginLogReqDto.getRoleCode(), new String[]{"roleCodeStr"});
        }
        if (StringUtils.isNotBlank((CharSequence)loginLogReqDto.getUserName())) {
            osSearchVo.addQuery(loginLogReqDto.getUserName(), new String[]{"userName"});
        }
        if (StringUtils.isNotBlank((CharSequence)loginLogReqDto.getClientIp())) {
            osSearchVo.addQuery(loginLogReqDto.getClientIp(), new String[]{"clientIp"});
        }
        if (loginLogReqDto.getStatus() != null) {
            osSearchVo.addEqualFilter("status", loginLogReqDto.getStatus().toString());
        }
        if (loginLogReqDto.getInstanceId() != null) {
            osSearchVo.addEqualFilter("instanceId", loginLogReqDto.getInstanceId().toString());
        }
        if (loginLogReqDto.getTenantId() != null) {
            osSearchVo.addEqualFilter("tenantId", loginLogReqDto.getTenantId().toString());
        }
        osSearchVo.addSort("logTime", SortOrder.DESC);
        osSearchVo.setPage(pageNum.intValue());
        osSearchVo.setPageSize(pageSize.intValue());
        SearchResultVo result = this.openSearchService.search(osSearchVo);
        logger.info("SearchResultVo:{}", (Object)JSON.toJSONString((Object)result));
        List loginLogRespDtoList = Lists.newArrayList();
        if (result != null) {
            loginLogRespDtoList = result.getDocValues((TypeReference)new TypeReference<List<LoginLogRespDto>>(){});
            PageInfo pageInfo = new PageInfo(loginLogRespDtoList);
            pageInfo.setPageNum(pageNum.intValue());
            pageInfo.setPageSize(pageSize.intValue());
            pageInfo.setSize(loginLogRespDtoList.size());
            pageInfo.setPages(result.getTotalPageNum().intValue());
            pageInfo.setTotal(result.getTotalSize());
            pageInfo.setStartRow((long)((pageNum - 1) * pageSize + 1));
            pageInfo.setEndRow((long)((pageNum - 1) * pageSize + loginLogRespDtoList.size()));
            return pageInfo;
        }
        return new PageInfo(loginLogRespDtoList);
    }
}

