/**
 * @(#)IOrganizationApi.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvEnableReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.VirtualRelateBusinessReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvOpRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 用户组织机构管理API接口
 *
 * @author shuangqing
 */
@Api(tags = {"用户中心：组织单元服务(v2)"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-IOrganizationExtApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v2/organization"
)
public interface IOrganizationExtApi {


    /**
     * 添加组织单元(业务单元、虚拟单元)信息
     *
     * @param orgAdvAddReqDto 组织信息
     */
    @PostMapping("")
    @ApiOperation(value = "添加组织单元(业务单元、虚拟单元)信息", notes = "添加组织单元(业务单元、虚拟单元)信息")
    @Capability(capabilityCode = "user.organization.add")
    RestResponse<OrgAdvOpRespDto> add(@RequestBody OrgAdvAddReqDto orgAdvAddReqDto);


    /**
     * 虚拟单元下关联业务单元
     *
     * @param reqDto 业务单元信息
     */
    @PostMapping("virtual-relate-business")
    @ApiOperation(value = "虚拟单元下关联业务单元", notes = "虚拟单元下关联业务单元")
    @Capability(capabilityCode = "user.organization.virtualRelateBusiness")
    RestResponse<Long> virtualRelateBusiness(VirtualRelateBusinessReqDto reqDto);

    /**
     * 解除虚拟单元下关联业务单元
     *
     * @param reqDto 业务单元信息
     */
    @DeleteMapping("virtual-unrelate-business")
    @ApiOperation(value = "解除虚拟单元下关联业务单元", notes = "解除虚拟单元下关联业务单元")
    @Capability(capabilityCode = "user.organization.virtualUnRelateBusiness")
    RestResponse<Void> virtualUnRelateBusiness(VirtualRelateBusinessReqDto reqDto);

    /**
     * 修改组织单元(业务单元、虚拟单元)信息
     *
     * @param orgAdvModifyReqDto 组织信息
     */
    @PutMapping("")
    @ApiOperation(value = "修改组织单元(业务单元、虚拟单元)信息", notes = "修改组织单元(业务单元、虚拟单元)信息")
    @Capability(capabilityCode = "user.organization.modify")
    RestResponse<OrgAdvOpRespDto> modify(@RequestBody OrgAdvModifyReqDto orgAdvModifyReqDto);

    /**
     * 根据编码删除组织单元(业务单元、虚拟单元)信息
     *
     * @param id 组织单元（业务单元、虚拟单元id）
     */
    @DeleteMapping("/id")
    @ApiOperation(value = "根据id删除组织单元(业务单元、虚拟单元)信息", notes = "根据id删除组织单元(业务单元、虚拟单元)信息")
    @Capability(capabilityCode = "user.organization.remove")
    RestResponse<Void> removeById(@RequestParam("id") Long id);


    /**
     * 批量删除组织单元(业务单元、虚拟单元)信息
     */
    @DeleteMapping("/remove/{ids}")
    @ApiOperation(value = "批量删除组织单元(业务单元、虚拟单元)信息", notes = "批量删除组织单元")
    @Capability(capabilityCode = "user.organization.remove")
    RestResponse<Void> removeBatch(String ids);


    /**
     * 批量启用禁用组织单元(业务单元、虚拟单元)信息
     */
    @PutMapping("/status/batch")
    @ApiOperation(value = "批量启用禁用组织单元(业务单元、虚拟单元)信息", notes = "批量启用禁用组织单元(业务单元、虚拟单元)信息，只能选择id和编码之中一个进行批量禁用启用")
    @Capability(capabilityCode = "user.organization.enable")
    RestResponse<Void> enableOrg(@RequestBody OrgAdvEnableReqDto orgAdvEnableReqDto);


    /**
     * 组织业务单元上移
     */
    @PutMapping("/sort-up/by-id")
    @ApiOperation(value = "组织业务单元上移", notes = "组织业务单元上移")
    @Capability(capabilityCode = "user.organization.sort-organization")
    RestResponse<Void> sortUpOrgById(@RequestParam("id") Long id);

    /**
     * 组织业务单元上移
     *
     * @param orgCode
     */
    @PutMapping("/sort-up")
    @ApiOperation(value = "组织业务单元上移", notes = "组织业务单元上移")
    @Capability(capabilityCode = "user.organization.sort-organization")
    RestResponse<Void> sortUpOrg(@RequestParam("orgCode") String orgCode);

    /**
     * 组织业务单元下移
     *
     * @param orgCode
     */
    @PutMapping("/sort-down")
    @ApiOperation(value = "组织业务单元下移", notes = "组织业务单元下移")
    @Capability(capabilityCode = "user.organization.sort-organization")
    RestResponse<Void> sortDownOrg(@RequestParam("orgCode") String orgCode);

    /**
     * 组织业务单元下移
     *
     * @param id
     */
    @PutMapping("/sort-down/by-id")
    @ApiOperation(value = "组织业务单元下移", notes = "组织业务单元下移")
    @Capability(capabilityCode = "user.organization.sort-organization")
    RestResponse<Void> sortDownOrgById(@RequestParam("id") Long id);

    /**
     * 历史组织数据迁移到新组织模型
     *
     * @param tenantId 租户id
     * @return
     */
    @PostMapping("/migrate/org-data")
    @ApiOperation(value = "历史组织数据迁移到新组织模型", notes = "历史组织数据迁移到新组织模型")
    @Capability(capabilityCode = "user.organization.modify")
    RestResponse<Void> migrateOldOrgData(@RequestParam("tenantId") Long tenantId, @RequestParam(value = "instanceId", required = false) Long instanceId);
}
