package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvTreeRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgGroupRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 组织服务接口
 *
 * @author qiuzhi
 * @since 2020-09-02
 */
@Api(tags = {"用户中心：组织服务(v2)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-query-IOrgGroupQueryApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v2/org-group"
)
public interface IOrgGroupQueryApi {

    /**
     * 根据id查询组织
     *
     * @param id 组织id
     * @return 组织数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询组织", notes = "根据id查询组织")
    @Capability(capabilityCode = "user.organization.orgGroup.queryById")
    RestResponse<OrgGroupRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 组织分页数据
     *
     * @param reqDto   组织查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 组织分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "组织分页数据", notes = "根据查询条件查询组织数据")
    @Capability(capabilityCode = "user.organization.orgGroup.queryByPage")
    RestResponse<PageInfo<OrgGroupRespDto>> queryByPage(@SpringQueryMap OrgGroupQueryReqDto reqDto,
                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 查询组织树信息
     */
    @GetMapping("/tree")
    @ApiOperation(value = "查询组织树信息", notes = "查询组织树信息")
    @Capability(capabilityCode = "user.organization.queryOrgTree")
    RestResponse<List<OrgAdvTreeRespDto>> queryOrgTree(@RequestParam("id") Long id);

    /**
     * 查询某个虚拟单元可有关联的业务单元树
     */
    @GetMapping("/tree-by-virtual")
    @ApiOperation(value = "查询某个虚拟单元可有关联的业务单元树", notes = "查询某个虚拟单元可有关联的业务单元树")
    @Capability(capabilityCode = "user.organization.bizOrgTreeByVirtual")
    RestResponse<List<OrgAdvTreeRespDto>> bizOrgTreeByVirtual(@RequestParam("orgGroupId") Long orgGroupId, @RequestParam("virtualOrgId") Long virtualOrgId);


    /**
     * 查询租户下所有人力组织树
     */
    @GetMapping("/human-resource-tree")
    @ApiOperation(value = "查询租户下所有人力组织树", notes = "查询租户下所有人力组织树")
    @Capability(capabilityCode = "user.organization.queryHumanResourceTree")
    RestResponse<List<OrgAdvTreeRespDto>> queryHumanResourceTree(@RequestParam("tenantId") Long tenantId);
}
