/**
 * @(#)IOrganizationApi.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvTreeReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgInfoAdvReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户组织机构管理API接口
 *
 * @author 南枫
 * @since 1.0.0
 */
@Api(tags = {"用户中心：组织机构管理服务(v2)"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-IOrganizationQueryExtApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v2/organization"
)
public interface IOrganizationQueryExtApi {

    /**
     * 查询组织单元(业务单元、虚拟单元)详情信息
     *
     * @param id 组织单元id
     */
    @GetMapping("/by-id")
    @ApiOperation(value = "查询组织单元(业务单元、虚拟单元)详情信息", notes = "查询组织单元(业务单元、虚拟单元)详情信息")
    @Capability(capabilityCode = "user.organization.query")
    RestResponse<OrgAdvDetailRespDto> queryById(@RequestParam("id") Long id);


    /**
     * 分页查询组织单元(业务单元、虚拟单元)信息
     *
     * @param orgAdvQueryReqDto 组织信息
     */
    @GetMapping("")
    @ApiOperation(value = "分页查询组织单元(业务单元、虚拟单元)信息", notes = "分页查询组织单元(业务单元、虚拟单元)信息")
    @Capability(capabilityCode = "user.organization.query")
    RestResponse<PageInfo<OrgAdvRespDto>> queryPage(@SpringQueryMap OrgAdvQueryReqDto orgAdvQueryReqDto,
                                                    @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                    @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询业务单元树信息
     *
     * @param orgAdvTreeReqDto 组织信息
     */
    @GetMapping("/tree")
    @ApiOperation(value = "查询业务单元树信息", notes = "查询业务单元树信息")
    @Capability(capabilityCode = "user.organization.query")
    RestResponse<OrgAdvTreeRespDto> queryTree(@SpringQueryMap OrgAdvTreeReqDto orgAdvTreeReqDto);

    /**
     * 查询业务单元的企业法人信息，该接口只支持在业务单元的详情里面使用，且因为存在重复数据需要去重返回数据量不一定为pageSize，建议只查询第一页的数据
     *
     * @param orgInfoAdvReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/org-info")
    @ApiOperation(value = "查询业务单元的企业法人信息", notes = "查询业务单元的企业法人信息，该接口只支持在业务单元的详情里面使用，且因为存在重复数据需要去重返回数据量不一定为pageSize，建议只查询第一页的数据")
    @Capability(capabilityCode = "user.organization.query")
    RestResponse<PageInfo<OrgInfoAdvRespDto>> queryOrgInfo(@SpringQueryMap OrgInfoAdvReqDto orgInfoAdvReqDto,
                                                           @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(value = "pageSize", required = false, defaultValue = "1000") Integer pageSize);


    /**
     * 查询企业法人信息
     *
     * @param orgName
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/org/name")
    @ApiOperation(value = "分页查询业务单元名称（模糊）", notes = "查询企业法人信息")
    @Capability(capabilityCode = "user.organization.query")
    RestResponse<PageInfo<String>> queryOrgName(@RequestParam(value = "orgName", required = false) String orgName,
                                                @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                @RequestParam(value = "pageSize", required = false, defaultValue = "100") Integer pageSize);

    /**
     * 分页查询业务单元编码（模糊）
     *
     * @param orgCode
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/org/code")
    @ApiOperation(value = "分页查询业务单元编码（模糊）", notes = "分页查询业务单元编码（模糊）")
    @Capability(capabilityCode = "user.organization.query")
    RestResponse<PageInfo<String>> queryOrgCode(@RequestParam(value = "orgCode", required = false) String orgCode,
                                                @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                @RequestParam(value = "pageSize", required = false, defaultValue = "100") Integer pageSize);

    /**
     * 查询组织实体属性
     *
     * @return
     */
    @GetMapping("/org/entity-property")
    @ApiOperation(value = "查询组织实体属性", notes = "查询组织实体属性")
    @Capability(capabilityCode = "user.organization.query")
    RestResponse<PageInfo<OrgEntityPropertyRespDto>> queryOrgEntityProperty();

    /**
     * 查询组织职能类型
     *
     * @return
     */
    @GetMapping("/org/func-type")
    @ApiOperation(value = "查询组织职能类型", notes = "查询组织职能类型")
    @Capability(capabilityCode = "user.organization.query")
    RestResponse<PageInfo<OrgFuncTypeRespDto>> queryOrgFuncType();

    /**
     * 查询组织模型, true:单组织, false:多组织
     *
     * @return
     */
    @GetMapping("/org/model")
    @ApiOperation(value = "查询组织模型, true:单组织, false:多组织", notes = "查询组织模型, true:单组织, false:多组织")
    @Capability(capabilityCode = "user.organization.query")
    RestResponse<Boolean> queryOrgModel();

}
