/**
 * @(#) ICustomerApi.java 1.0 2019-01-31
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.ImportCustomerResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 客户服务API接口
 *
 * @author 刘备
 * @since 1.0.0
 */
@Deprecated
@Api(tags = {"用户中心：客户服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-ICustomerApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        path = "/v1/customer",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}"
)
public interface ICustomerApi {

    /**
     * 增加客户
     *
     * @param orgId       组织机构ID
     * @param customerDto 客户信息集合
     * @return
     */
    @PostMapping
    @ApiOperation(value = "增加客户", notes = "增加客户")
    @Capability(capabilityCode = "user.customer.add-customer")
    RestResponse<Long> addCustomer(@RequestParam(name = "orgId", required = false) Long orgId, @RequestBody CustomerDto customerDto);

    /**
     * 根据指定Id删除客户
     *
     * @param id 客户ID
     * @return
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除客户", notes = "根据指定Id删除客户")
    @Capability(capabilityCode = "user.customer.delete-customer")
    RestResponse<Void> deleteCustomer(@PathVariable("id") Long id);


    /**
     * 修改客户
     *
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "修改客户", notes = "修改客户")
    @Capability(capabilityCode = "user.customer.update-customer")
    RestResponse<Void> updateCustomer(@PathVariable("id") Long id, @RequestBody CustomerDto customerDto);

    /**
     * 导入客户信息
     *
     * @param orgId           组织机构ID
     * @param customerDtoList 客户集合
     * @return
     */
    @PostMapping("/batch")
    @ApiOperation(value = "导入客户", notes = "批量导入客户，返回成功添加的客户和失败原因")
    @Capability(capabilityCode = "user.customer.import-customer")
    RestResponse<ImportCustomerResult> importCustomer(@RequestParam(name = "orgId", required = false) Long orgId, @RequestBody List<CustomerDto> customerDtoList);
}
