package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerOrgInfoDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author yufan
 * @time 2020/9/27 16:46
 */
@Api(tags = {"用户中心：【客商中心】客户组织信息管理服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-ICustomerOrgInfoApi"
        , name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}"
        , path = "/v1/customer-org-info"
        , url = "${dtyunxi.yundt.cube_organization-center-user_api:}")
public interface ICustomerOrgInfoApi {
    /**
     * 添加客户组织信息
     *
     * @param customerOrgInfoDto 客户组织信息
     */
    @PostMapping("/add")
    @ApiOperation(value = "添加客户组织信息", notes = "添加客户组织信息")
    @Capability(capabilityCode = "user.customer.add-org-info")
    RestResponse<Long> addCustomerOrgInfo(@RequestBody CustomerOrgInfoDto customerOrgInfoDto);

    /**
     * 更新客户组织信息
     *
     * @param customerOrgInfoDto 更新客户组织信息
     */
    @PutMapping("/update")
    @ApiOperation(value = "更新客户组织信息", notes = "更新客户组织信息")
    @Capability(capabilityCode = "user.customer.update-org-info")
    RestResponse<Void> updateCustomerOrgInfo(@RequestBody CustomerOrgInfoDto customerOrgInfoDto);
}
