package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeModifyReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 员工信息表服务接口
 *
 * @author qiuzhi
 * @since 2020-09-25
 */
@Api(tags = {"用户中心：员工信息表服务(v2)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IEmployeeApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:bundle-organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v2/employee"
)
public interface IEmployeeApi {

    /**
     * 新增员工信息表
     *
     * @param reqDto 员工信息表添加请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增员工信息表", notes = "新增员工信息表")
    @Capability(capabilityCode = "addEmployee")
    RestResponse<Long> addEmployee(@RequestBody EmployeeAddReqDto reqDto);

    /**
     * 修改员工信息表
     *
     * @param reqDto 员工信息表修改请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改员工信息表", notes = "修改员工信息表")
    @Capability(capabilityCode = "modifyEmployee")
    RestResponse<Void> modifyEmployee(@RequestBody EmployeeModifyReqDto reqDto);


    /**
     * 批量修改状态
     *  @param ids    岗位id
     * @param status 0禁用,1启用
     */
    @PutMapping("/status")
    @ApiOperation(value = "批量修改岗位状态", notes = "批量修改岗位状态")
    @Capability(capabilityCode = "user.organization.changePostStatus")
    RestResponse<Void> changeEmployeeStatus(@RequestParam("ids") String ids, @RequestParam("status") Integer status);

    /**
     * 删除员工信息表
     *
     * @param ids 员工信息表删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("{ids}")
    @ApiOperation(value = "删除员工信息表", notes = "删除员工信息表")
    @Capability(capabilityCode = "removeEmployee")
    RestResponse<Void> removeEmployee(@PathVariable("ids") String ids);

}
