package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PostAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PostModifyReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 岗位服务接口
 *
 * @author qiuzhi
 * @since 2020-09-04
 */
@Api(tags = {"用户中心：岗位服务(v2)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IPostExtApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v2/post"
)
public interface IPostExtApi {

    /**
     * 新增岗位
     *
     * @param addReqDto 岗位请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增岗位", notes = "新增岗位")
    @Capability(capabilityCode = "user.organization.addPost")
    RestResponse<Long> addPost(@RequestBody PostAddReqDto addReqDto);

    /**
     * 修改岗位
     *
     * @param modifyReqDto 岗位请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改岗位", notes = "修改岗位")
    @Capability(capabilityCode = "user.organization.modifyPost")
    RestResponse<Void> modifyPost(@RequestBody PostModifyReqDto modifyReqDto);

    /**
     * 批量修改状态
     *  @param ids    岗位id
     * @param status 0禁用,1启用
     */
    @PutMapping("/status")
    @ApiOperation(value = "批量修改岗位状态", notes = "批量修改岗位状态")
    @Capability(capabilityCode = "user.organization.changePostStatus")
    RestResponse<Void> changePostStatus(@RequestParam("ids") String ids, @RequestParam("status") Integer status);

    /**
     * 删除岗位
     *
     * @param ids 岗位删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除岗位", notes = "删除岗位")
    @Capability(capabilityCode = "user.organization.removePost")
    RestResponse<Void> removePost(@PathVariable("ids") String ids);
}
