package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.dtyunxi.cube.utils.bean.VerifyUtil;
import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.Date;

/**
 * @author yufan
 * @time 2020/9/27 15:29
 */
@ApiModel(value = "CustomerOrgInfoDto", description = "客户组织信息")
public class CustomerOrgInfoDto extends BaseDto {
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 组织名称
     */
    @NotNull(message = "组织名称不能为null")
    @ApiModelProperty(value = "组织名称，新增必填")
    private String orgName;
    /**
     * 组织编号
     */
    @NotNull(message = "组织编号不能为null")
    @ApiModelProperty(value = "组织编号，新增必填")
    private String orgCode;
    /**
     * 公司地址
     */
    @ApiModelProperty(value = "公司地址，选填")
    private String address;
    /**
     * 机构类型
     */
    @ApiModelProperty(value = "机构类型，默认‘customer’")
    private String orgType = "customer";
    /**
     * 用户Id
     */
    @ApiModelProperty(value = "管理员账号id")
    private Long userId;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称，选填")
    private String simpleName;


    /**
     * 营业执照URL
     */
    @ApiModelProperty(value = "营业执照URL，选填")
    private String bussinessLicenseUrl;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgType() {
        return orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getSimpleName() {
        return simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public String getBussinessLicenseUrl() {
        return bussinessLicenseUrl;
    }

    public void setBussinessLicenseUrl(String bussinessLicenseUrl) {
        this.bussinessLicenseUrl = bussinessLicenseUrl;
    }


}
