/**
 * @(#)EmployeeDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved. YUNXI
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;


/**
 * 员工信息请求Dto
 *
 * @author qiuzhi
 * @since 1.0.0
 */
@ApiModel(value = "EmployeeAddReqDto", description = "员工信息")
public class EmployeeAddReqDto extends RequestDto {

    /**
     * 员工姓名
     */
    @NotNull(message = "员工姓名不能为空")
    @Size(message = "员工姓名字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(value = "员工姓名, 选填")
    private String name;

    /**
     * 员工号
     */
    @NotNull(message = "员工号不能为空")
    @Size(message = "员工号字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(value = "员工号, 选填")
    private String employeeNo;

    /**
     * 手机号码
     */
    @Size(message = "手机号码字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(value = "手机号码, 选填")
    private String phoneNum;

    /**
     * 邮箱号
     */
    @Size(message = "员工编号字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(value = "邮箱号, 选填")
    private String email;

    /**
     * 员工状态：1，启用，2禁用
     */
    @ApiModelProperty(value = "员工状态: 1启用,2禁用.默认启用", allowableValues = "0,1,2")
    private Integer status;

    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id, 选填")
    private Long userId;

    /**
     * 昵称
     */
    @Size(message = "员工昵称字符长度为[1-50]", min = 1, max = 50)
    @ApiModelProperty(value = "昵称, 选填")
    private String nickName;

    @Size(message = "备注字符长度为[1-255]", max = 255)
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 组织单元
     */
    @ApiModelProperty(value = "组织单元")
    private List<OrgOrgDto> orgDtoList;

    /**
     * 岗位Id
     */
    @ApiModelProperty(value = "岗位Id")
    private List<Long> postIds;

    /**
     * 批量新增员工，用于全量同步企业微信员工到BOC
     */
    private Long id;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }


    public String getEmployeeNo() {
        return employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<OrgOrgDto> getOrgDtoList() {
        return orgDtoList;
    }

    public void setOrgDtoList(List<OrgOrgDto> orgDtoList) {
        this.orgDtoList = orgDtoList;
    }

    public List<Long> getPostIds() {
        return postIds;
    }

    public void setPostIds(List<Long> postIds) {
        this.postIds = postIds;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
