package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 高级用户组织功能包--组织业务单元的组织属性dto
 *
 * @author shuangqing
 */
@ApiModel(value = "OrgAdvPropRespDto", description = "高级用户组织功能包--组织业务单元的组织属性dto")
public class OrgAdvPropRespDto extends BaseDto {

    /**
     * 职能类型编码
     */
    @ApiModelProperty(value = "职能类型编码")
    private String funcTypeCode;

    /**
     * 组织属性编码
     */
    @ApiModelProperty(value = "组织属性编码")
    private String code;

    /**
     * 组织属性名称
     */
    @ApiModelProperty(value = "组织属性名称")
    private String name;

    /**
     * 组织属性值(输入类型，选项该value无值)
     */
    @ApiModelProperty(value = "组织属性值(输入类型)")
    private String value;

    /**
     * 属性值枚举方式(0填写,1单选,2多选)
     */
    @ApiModelProperty(value = "属性值枚举方式(0填写,1单选,2多选)")
    private Integer editType;
    /**
     * 属性值字符类型(0字符串,1数字,2时间)
     */
    @ApiModelProperty(value = "属性值字符类型(0字符串,1数字,2时间)")
    private Integer valueType;
    /**
     * 属性值字段长度
     */
    @ApiModelProperty(value = "属性值字段长度")
    private Integer length;

    /**
     * 组织属性选项值
     */
    @ApiModelProperty(value = "组织属性选项值")
    private List<OrgAdvPropOption> orgAdvPropOptions;

    @ApiModel(value = "OrgAdvPropOption", description = "组织业务单元的组织属性的选项dto")
    public static class OrgAdvPropOption implements Serializable {

        /**
         * 组织属性选项值
         */
        @ApiModelProperty(value = "组织属性选项值")
        private String value;

        /**
         * 是否已选: 1 已选 0 未选
         */
        @ApiModelProperty(value = "是否已选: 1 已选 0 未选")
        private Integer isSelected;


        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Integer getIsSelected() {
            return isSelected;
        }

        public void setIsSelected(Integer isSelected) {
            this.isSelected = isSelected;
        }
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<OrgAdvPropOption> getOrgAdvPropOptions() {
        return orgAdvPropOptions;
    }

    public void setOrgAdvPropOptions(List<OrgAdvPropOption> orgAdvPropOptions) {
        this.orgAdvPropOptions = orgAdvPropOptions;
    }

    public Integer getEditType() {
        return editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public Integer getLength() {
        return length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String getFuncTypeCode() {
        return funcTypeCode;
    }

    public void setFuncTypeCode(String funcTypeCode) {
        this.funcTypeCode = funcTypeCode;
    }
}
