package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgOrgDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 岗位响应对象
 *
 * @author qiuzhi
 * @since 2020-09-04
 */
@ApiModel(value = "PostRespDto", description = "岗位响应对象")
public class PostRespDto extends BaseDto {

    /**
     * 主键
     */
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 岗位名称
     */
    @ApiModelProperty(value = "岗位名称")
    private String name;
    /**
     * 岗位编码
     */
    @ApiModelProperty(value = "岗位编码")
    private String code;
    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织Id")
    private Long orgGroupId;
    /**
     * 组织单元编码
     */
    @ApiModelProperty(value = "组织单元Id")
    private String orgIds;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;
    /**
     * 状态 [0禁用 1启用]
     */
    @ApiModelProperty(value = "状态 [0禁用 1启用]")
    private Integer status;
    
    @ApiModelProperty(value = "父级岗位id")
    private Long parentId;
    
    @ApiModelProperty(value = "父级岗位编码")
    private String parentCode;
    
    @ApiModelProperty(value = "父级岗位名称")
    private String parentName;

    @ApiModelProperty
    private List<OrgOrgDto> orgDtoList;

    @ApiModelProperty
    private Integer employeeCount;

    public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getParentCode() {
		return parentCode;
	}

	public void setParentCode(String parentCode) {
		this.parentCode = parentCode;
	}

	public String getParentName() {
		return parentName;
	}

	public void setParentName(String parentName) {
		this.parentName = parentName;
	}

	public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public Long getOrgGroupId() {
        return orgGroupId;
    }

    public void setOrgGroupId(Long orgGroupId) {
        this.orgGroupId = orgGroupId;
    }

    public String getOrgIds() {
        return orgIds;
    }

    public void setOrgIds(String orgIds) {
        this.orgIds = orgIds;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<OrgOrgDto> getOrgDtoList() {
        return orgDtoList;
    }

    public void setOrgDtoList(List<OrgOrgDto> orgDtoList) {
        this.orgDtoList = orgDtoList;
    }

    public Integer getEmployeeCount() {
        return employeeCount;
    }

    public void setEmployeeCount(Integer employeeCount) {
        this.employeeCount = employeeCount;
    }
}
