package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PostByOrgReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PostQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgPostResDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.PostRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 岗位服务接口
*
* @author qiuzhi
* @since 2020-09-04
*/
@Api(tags = {"用户中心：岗位服务(v2)"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-user-api-query-IPostExtQueryApi",
    name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
    url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
    path = "/v2/post"
)
public interface IPostExtQueryApi {

    /**
    * 根据id查询岗位
    *
    * @param id 岗位id
    * @return   岗位数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询岗位", notes = "根据id查询岗位")
    @Capability(capabilityCode = "user.organization.queryPostExtById")
    RestResponse<PostRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 岗位分页数据
    *
    * @param reqDto   岗位查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 岗位分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "岗位分页数据", notes = "根据查询条件查询岗位数据")
    @Capability(capabilityCode = "user.organization.queryPostExtByPage")
    RestResponse<PageInfo<PostRespDto>> queryByPage(@SpringQueryMap PostQueryReqDto reqDto,
                                                        @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                        @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据组织单元过滤岗位
     */
    @PostMapping("/by-org")
    @ApiOperation(value = "根据组织单元过滤岗位", notes = "根据组织单元过滤岗位")
    @Capability(capabilityCode = "user.organization.filterPostByOrg")
    RestResponse<List<OrgPostResDto>> filterByOrg(@RequestBody PostByOrgReqDto reqDto);

}
