/**
 * @(#)IOrganizationApi.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.EmployeeOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 用户组织机构管理API接口
 *
 * @author 南枫
 * @since 1.0.0
 */
@Api(tags = {"用户中心：组织机构管理服务(v1)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IOrganizationApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v1/organization"
)
public interface IOrganizationApi {

    /**
     * 根据传入的组织信息，添加组织节点信息，单个节点新增，根据传入的parentId确定父节点,如果为空就是根节点，不需要传入组织id，系统生成返回组织id
     * 添加组织信息
     *
     * @param instanceId      应用实例Id
     * @param organizationDto 组织信息
     * @return Long
     */
    @Deprecated //由com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi.add代替
    @RequestMapping(value = "", method = RequestMethod.POST)
    @ApiOperation(value = "添加组织（废弃，由[/v2/organization/add]代替）", notes = "请求参数为： Application-Key  应用实例id， parentId 该组织所属父id，为空则为根节点   name 组织名称" +
            " description 描述  sortNO 序号")
    @Capability(capabilityCode = "user.organization.add")
    RestResponse<Long> add(@RequestParam("instanceId") Long instanceId, @RequestBody OrganizationDto organizationDto);

    /**
     * 根据传入的组织信息，添加组织节点信息，单个节点新增，根据传入的parentId确定父节点,如果为空就是根节点，不需要传入组织id，系统生成返回组织id
     * 添加组织信息
     *
     * @param organizationDto 组织信息
     * @return 组织ID
     */
    @Deprecated //由com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi.add代替
    @PostMapping("/add")
    @ApiOperation(value = "添加组织（废弃，由[/v2/organization]代替）", notes = "支持租户实例级别，请求参数为： Application-Key  应用实例id， parentId 该组织所属父id，为空则为根节点   name 组织名称" +
            " description 描述  sortNO 序号")
    @Capability(capabilityCode = "user.organization.add")
    RestResponse<Long> add(@RequestBody OrganizationDto organizationDto);

    /**
     * 根据传入的组织信息，修改组织节点信息，包括修改父节点，启用或者禁用该组织节点信息，以及修改节点的基本信息（名称，描述等），需要传入组织id
     * 修改组织信息，以及更新组织部门信息
     *
     * @param instanceId      应用实例Id
     * @param organizationDto 组织信息
     * @param organizationId  组织Id
     * @return Long
     */
    @Deprecated //由com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi.modify代替
    @RequestMapping(value = "/{organizationId}", method = RequestMethod.PUT)
    @ApiOperation(value = "修改组织（废弃，由[/v2/organization]代替）", notes = "请求参数为：  instanceId  应用实例id  id 需要更新的组织的id  parentId 该组织所属父id，为空则为根节点 name 组织名称" +
            " description 描述  sortNO 序号")
    @Capability(capabilityCode = "user.organization.modify-org")
    RestResponse<Long> modifyOrg(@RequestParam("instanceId") Long instanceId,
                                 @PathVariable("organizationId") Long organizationId,
                                 @RequestBody OrganizationDto organizationDto);

    /**
     * 根据传入的组织信息，修改组织节点信息，包括修改父节点，启用或者禁用该组织节点信息，以及修改节点的基本信息（名称，描述等），需要传入组织id
     * 修改组织信息，以及更新组织部门信息
     *
     * @param organizationDto organizationDto
     * @return 组织ID
     */
    @Deprecated //由com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi.modify代替
    @PutMapping("")
    @ApiOperation(value = "修改组织（废弃，由[/v2/organization]代替）", notes = "请求参数为：  instanceId  应用实例id  id 需要更新的组织的id, , swagger调用需要手动将id加到dto中  parentId 该组织所属父id，为空则为根节点 name 组织名称" +
            " description 描述  sortNO 序号")
    @Capability(capabilityCode = "user.organization.modify-org")
    RestResponse<Long> modifyOrg(@RequestBody OrganizationDto organizationDto);

    /**
     * 删除组织信息，删除叶子节点组织信息，如果该节点有员工信息则不能删除，否则可以删除
     *
     * @param organizationId 组织Id
     * @return void
     */
    @Deprecated //由com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi.remove代替
    @RequestMapping(value = "/{organizationId}", method = RequestMethod.DELETE)
    @ApiOperation(value = "删除组织（废弃，由[/v2/organization]代替）", notes = "请求参数为： organizationId 组织id, 如果存在子节点或员工, 则不能删除")
    @Capability(capabilityCode = "user.organization.remove-organization")
    RestResponse<Void> removeOrganization(@PathVariable("organizationId") Long organizationId);

    /**
     * 添加员工基本信息，包括组织id信息，扩展字段信息（可空），进行员工信息保存，默认是启用状态
     * 添加员工信息
     *
     * @param employeeDto 员工信息
     * @return Long
     */
    @RequestMapping(value = "/employee", method = RequestMethod.POST)
    @ApiOperation(value = "添加员工", notes = "请求参数为： name 员工姓名  station 岗位  employeeNo员工编号  phoneNum 手机号码" +
            " emailNum 邮箱号  organizationIds 所在组织id  user 用户参数，同时新建用户")
    @Capability(capabilityCode = "user.organization.add")
    RestResponse<Long> add(@RequestBody EmployeeDto employeeDto);

    /**
     * 编辑员工信息，修改员工的基本信息，包括所在组织，扩展字段里面的信息，状态的启用和禁用。
     *
     * @param oldOrganizationId 原组织Id
     * @param employeeId        员工Id
     * @param employeeDto       员工信息
     * @return Long
     */
    @RequestMapping(value = "{organizationId}/employee/{employeeId}", method = RequestMethod.PUT)
    @ApiOperation(value = "修改员工", notes = "请求参数为： employeeId 员工id  name 员工姓名  station 岗位  employeeNo员工编号  phoneNum 手机号码" +
            " emailNum 邮箱号  organizationIds 所在组织id  propPageDto 扩展字段信息，非必填项, 接口会先解除原有员工和组织的关系, 再重新新增, 若业务与组织无关, 可调用employee/{employeeId}/info")
    @Capability(capabilityCode = "user.organization.modify")
    RestResponse<Long> modify(@PathVariable("organizationId") Long oldOrganizationId,
                              @PathVariable("employeeId") Long employeeId,
                              @RequestBody EmployeeDto employeeDto);

    /**
     * 修改员工信息(boc)
     *
     * @param employeeId
     * @param employeeDto
     * @return
     */
    @RequestMapping(value = "employee/{employeeId}/info", method = RequestMethod.PUT)
    @ApiOperation(value = "修改员工信息", notes = "请求参数为： employeeId 员工id  name 员工姓名  station 岗位  employeeNo员工编号  phoneNum 手机号码" +
            " emailNum 邮箱号   propPageDto 扩展字段信息")
    @Capability(capabilityCode = "user.organization.modify-employee")
    RestResponse<Void> modifyEmployee(@PathVariable("employeeId") Long employeeId, @RequestBody EmployeeDto employeeDto);

    /**
     * 根据id删除员工详细信息，删除员工基本信息和所在组织列表，和扩展信息
     * 删除员工信息
     *
     * @param organizationId 组织Id
     * @param id             id
     * @return Long
     */
    @RequestMapping(value = "{organizationId}/employee/{id}", method = RequestMethod.DELETE)
    @ApiOperation(value = "删除员工信息", notes = "请求参数为： id 组织id, 若业务与组织无关, 可调用DELETE /employee, 删除员工api")
    @Capability(capabilityCode = "user.organization.remove")
    RestResponse<Long> remove(@PathVariable("organizationId") Long organizationId, @PathVariable("id") Long id);

    /**
     * 重新绑定指定组织下面的员工关系
     *
     * @param employeeOrgRelationReqDto 员工组织关系映射集
     * @return Long
     */
    @RequestMapping(value = "{organizationId}/employee/relation", method = RequestMethod.POST)
    @ApiOperation(value = "重新绑定指定组织下面的员工关系", notes = "重新绑定指定组织下面的员工关系")
    @Capability(capabilityCode = "user.organization.re-bind-relation")
    RestResponse<Void> reBindRelation(@PathVariable("organizationId") Long organizationId, @Valid @RequestBody EmployeeOrgRelationBatchUpdateReqDto employeeOrgRelationReqDto);


    /**
     * 组织排序
     *
     * @param id         组织ID
     * @param sortReqDto 排序类型(BOTTOM：置底，INCR：升序，DECR：降序，TOP：置顶)
     * @return 操作结果
     */
    @PutMapping("/sort/{id}")
    @ApiOperation(value = "组织排序", notes = "sortType=排序类型(BOTTOM：置底，INCR：升序，DECR：降序，TOP：置顶)")
    @Capability(capabilityCode = "user.organization.sort-organization")
    RestResponse<Void> sortOrganization(@NotNull(message = "组织ID不允许为空") @PathVariable("id") Long id,
                                        @RequestBody SortReqDto sortReqDto);


    /**
     * 新增员工和组织关系
     *
     * @param employeeOrgRelationReqDto 员工-组织关系
     * @return 增加的记录id
     */
    @PostMapping({"/ref/employee"})
    @ApiOperation(value = "新增员工和组织关系")
    @Capability(capabilityCode = "user.organization.add-employee-org-relation")
    RestResponse<Long> addEmployeeOrgRelation(@Valid @RequestBody EmployeeOrgRelationReqDto employeeOrgRelationReqDto);

    /**
     * 修改员工状态
     *
     * @param employeeId 员工id
     * @param status     状态
     * @return 操作结果
     */
    @PutMapping({"/employee/{employeeId}"})
    @ApiOperation(value = "修改员工状态, 1为启用, 2为禁用, 禁用时同时禁用关联的账号")
    @Capability(capabilityCode = "user.organization.modify-status")
    RestResponse<Void> modifyStatus(@PathVariable("employeeId") Long employeeId, @RequestParam("status") Integer status);

    /**
     * 删除员工
     *
     * @param employeeId 员工id
     * @return 操作结果
     */
    @DeleteMapping({"/employee"})
    @ApiOperation(value = "删除员工")
    @Capability(capabilityCode = "user.organization.delete-employee")
    RestResponse<Void> deleteEmployee(@RequestParam("employeeId") Long employeeId);

    /**
     * 删除员工和组织关系,因为前端不支持body放内容提供多一个方法
     *
     * @param employeeOrgRelationReqDto 员工-组织关系
     * @return 删除的记录id, null表示记录不存在或已删除
     */
    @PutMapping({"/ref/employee/disable"})
    @ApiOperation(value = "删除员工和组织的关系,如果前端不支持body放内容提供多一个方法")
    @Capability(capabilityCode = "user.organization.remove-employee-org-relation-by-put")
    RestResponse<Long> removeEmployeeOrgRelationByPut(@Valid @RequestBody EmployeeOrgRelationReqDto employeeOrgRelationReqDto);

    /**
     * 删除员工和组织关系
     *
     * @param employeeOrgRelationReqDto 员工-组织关系
     * @return 删除的记录id, null表示记录不存在或已删除
     */
    @DeleteMapping({"/ref/employee"})
    @ApiOperation(value = "删除员工和组织的关系")
    @Capability(capabilityCode = "user.organization.remove-employee-org-relation")
    RestResponse<Long> removeEmployeeOrgRelation(@Valid @RequestBody EmployeeOrgRelationReqDto employeeOrgRelationReqDto);

    /**
     * 组织关联多个员工
     *
     * @param relateEmployeesOrgReqDto 请求体
     * @return void
     */
    @PostMapping({"/ref/employees"})
    @ApiOperation(value = "组织关联多个员工")
    @Capability(capabilityCode = "user.organization.relate-employees-org")
    RestResponse<Void> relateEmployeesOrg(@Valid @RequestBody RelateEmployeesOrgReqDto relateEmployeesOrgReqDto);

    /**
     * 新增组织及企业详情
     *
     * @param orgAndOrgInfoReqDto 新增组织及企业详情dto
     * @return id
     */
    @PostMapping({"/org/info"})
    @ApiOperation(value = "新增组织及企业详情")
    @Capability(capabilityCode = "user.organization.add-org-and-org-info")
    RestResponse<Long> addOrgAndOrgInfo(@Valid @RequestBody OrgAndOrgInfoReqDto orgAndOrgInfoReqDto);

    /**
     * 修改组织及企业详情情
     *
     * @param id                  id
     * @param orgAndOrgInfoReqDto 请求体
     * @return void
     */
    @PutMapping({"/org/info"})
    @ApiOperation(value = "修改组织及企业详情情")
    @Capability(capabilityCode = "user.organization.modify-org-and-org-info")
    RestResponse<Void> modifyOrgAndOrgInfo(@RequestParam("id") Long id, @Valid @RequestBody OrgAndOrgInfoReqDto orgAndOrgInfoReqDto);

    /**
     * 员工关联账号
     *
     * @param employeeId 员工id
     * @param userId     用户id
     * @return void
     */
    @PostMapping({"/employee/{employeeId}/user/{userId}"})
    @ApiOperation(value = "员工关联账号")
    @Capability(capabilityCode = "user.organization.relate-employee-user")
    RestResponse<Void> relateEmployeeUser(@PathVariable("employeeId") Long employeeId, @PathVariable("userId") Long userId);

    /**
     * 员工解除账号关联
     *
     * @param employeeId 员工id
     * @return void
     */
    @PutMapping({"/employee/{employeeId}/user"})
    @ApiOperation(value = "员工解除账号关联")
    @Capability(capabilityCode = "user.organization.remove-employee-user-relation")
    RestResponse<Void> removeEmployeeUserRelation(@PathVariable("employeeId") Long employeeId);

    /**
     * 用户关联多个组织(全量分配，会先删除用户已关联的组织信息)
     *
     * @param userOrgRelationReqDto 请求Dto
     * @return 操作结果
     */
    @PostMapping({"/user/relate/all"})
    @ApiOperation(value = "用户关联多个组织(全量分配，会先删除用户已关联的组织信息)")
    @Capability(capabilityCode = "user.organization.add-user-org-relation-all")
    RestResponse<Void> addUserOrgRelationAll(@Valid @RequestBody UserOrgRelationReqDto userOrgRelationReqDto);

    /**
     * 用户关联多个组织(增量分配)
     *
     * @param userOrgRelationReqDto 请求Dto
     * @return 操作结果
     */
    @PostMapping({"/user/relate"})
    @ApiOperation(value = "用户关联多个组织(增量分配)")
    @Capability(capabilityCode = "user.organization.add-user-org-relation")
    RestResponse<Void> addUserOrgRelation(@Valid @RequestBody UserOrgRelationReqDto userOrgRelationReqDto);

    /**
     * 解除组织用户关联关系
     *
     * @param userOrgRelationReqDto 请求Dto
     * @return 操作结果
     */
    @PutMapping({"/user/relate"})
    @ApiOperation(value = "解除组织用户关联关系)")
    @Capability(capabilityCode = "user.organization.delete-user-org-relation")
    RestResponse<Void> deleteUserOrgRelation(@Valid @RequestBody UserOrgRelationReqDto userOrgRelationReqDto);
}
