package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrganizationPropAddReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrganizationPropModifyReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 组织属性服务接口
 *
 * @author qiuzhi
 * @since 2020-09-01
 */
@Api(tags = {"用户中心：组织属性服务(v2)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IOrganizationPropApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v2/org-prop"
)
public interface IOrganizationPropApi {

    /**
     * 新增组织属性
     *
     * @param addReqDto 组织属性请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增组织属性", notes = "新增组织属性")
    @Capability(capabilityCode = "user.organization.addOrganizationProp")
    RestResponse<Long> addOrganizationProp(@RequestBody OrganizationPropAddReqDto addReqDto);

    /**
     * 修改组织属性
     *
     * @param modifyReqDto 组织属性请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改组织属性", notes = "修改组织属性")
    @Capability(capabilityCode = "user.organization.modifyOrganizationProp")
    RestResponse<Void> modifyOrganizationProp(@RequestBody OrganizationPropModifyReqDto modifyReqDto);

    /**
     * 删除组织属性
     *
     * @param ids        组织属性删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除组织属性", notes = "删除组织属性")
    @Capability(capabilityCode = "user.organization.removeOrganizationProp")
    RestResponse<Void> removeOrganizationProp(@PathVariable("ids") String ids);
}
