/**
 * @(#)OrganizationDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 组织Dto
 * 用于新建,存放,查询组织的数据传输对象
 *
 * @author 南枫
 * @since 1.0.0
 */
@ApiModel(value = "OrganizationDto", description = "组织信息")
public class OrganizationDto extends BaseDto{

    private static final long serialVersionUID = 8214864658606865113L;
    /**
     * id
     */
    @ApiModelProperty(value = "组织id")
    private Long id;

    /**
     * 父组织id
     */
    @ApiModelProperty(value = "父组织id, 若parentId为空，则查询该实例id是否有根组织节点信息，如果没有，则设置parentId为root根节点，否则设置为实例的根节点")
    private Long parentId;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称, 必填")
    private String name;

    /**
     * 组织名称1
     */
    @ApiModelProperty(value = "组织名称1, 选填")
    private String name_i1;

    /**
     * 组织名称2
     */
    @ApiModelProperty(value = "组织名称2, 选填")
    private String name_i2;

    /**
     * 组织描述
     */
    @ApiModelProperty(value = "组织描述, 选填")
    private String description;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号, 选填")
    private Integer sortNO;

    /**
     * 组织类型
     */
    @ApiModelProperty(value = "组织类型, 选填")
    private String type;

    /**
     * 组织编号
     */
    @ApiModelProperty(value = "组织编号, 选填")
    private String code;

    /**
     * 子组织
     */
    @ApiModelProperty(value = "子组织")
    private List<OrganizationDto> children;

    /**
     *
     */
    @ApiModelProperty(value = "组织员工")
    private List<EmployeeDto> employees;

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getSortNO() {
        return sortNO;
    }

    public void setSortNO(Integer sortNO) {
        this.sortNO = sortNO;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<OrganizationDto> getChildren() {
        return children;
    }

    public void setChildren(List<OrganizationDto> children) {
        this.children = children;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<EmployeeDto> getEmployees() {
        return employees;
    }

    public void setEmployees(List<EmployeeDto> employees) {
        this.employees = employees;
    }

    public String getName_i1() {
        return name_i1;
    }

    public void setName_i1(String name_i1) {
        this.name_i1 = name_i1;
    }

    public String getName_i2() {
        return name_i2;
    }

    public void setName_i2(String name_i2) {
        this.name_i2 = name_i2;
    }
}
