/**
 * @(#) ICustomerQueryApi.java 1.0 2019-01-31
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.CustomerDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 客户查询服务API接口
 *
 * @author 刘备
 * @since 1.0.0
 */
@Deprecated
@Api(tags = {"用户中心：客户服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-query-ICustomerQueryApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v1/customer"
)
public interface ICustomerQueryApi {


    /**
     * 根据ID查询客户
     *
     * @param id 客户ID
     * @return
     */
    @RequestMapping(value = {"/{id}"}, produces = "application/json", method = RequestMethod.GET)
    @ApiOperation(value = "根据id查询指定的客户信息", notes = "根据id查询指定的客户信息")
    @Capability(capabilityCode = "user.customer.query-by-id")
    RestResponse<CustomerDto> queryById(@PathVariable("id") Long id);


    /**
     * 分页查询客户列表
     *
     * @param filter   tenantId, instanceId通过filter传递
     * @param pageNum  起始页
     * @param pageSize 每一页的记录数
     * @return PageInfo
     */
    @RequestMapping(value = {"/page"}, produces = "application/json", method = RequestMethod.GET)
    @ApiImplicitParams({@ApiImplicitParam(name = "filter", value = "查询条件json字符串", dataType = "string", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageNum", value = "起始页", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageSize", value = "每一页的记录数", dataType = "int", paramType = "query", required = true)})
    @ApiOperation(value = "分页查询用户列表（通用方法）", notes = "分页查询用户列表的通用方法,filter为查询条件的json字符串，内容如下：" +
            "tenantId：租户ID" +
            "instanceId: 实例ID" +
            "filters:查询条件，由property、operator、value组成，分别代表属性、运算符(eq | ne | gt | lt | ge | le | like | in | isNull | isNotNull )、属性值" +
            "reses: 查询关联的对象，如us_customer关联的us_user信息" +
            "orderBy：升序字段,多个字段时逗号隔开" +
            "orderByDesc：降序字段,多个字段时逗号隔开")
    @Capability(capabilityCode = "user.customer.query-by-page")
    RestResponse<PageInfo<CustomerDto>> queryByPage(@RequestParam("filter") String filter,
                                                    @RequestParam("pageNum") Integer pageNum,
                                                    @RequestParam("pageSize") Integer pageSize);
}
