package com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.base;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;

/**
 *
 * @author : 萧玄
 * @Date: 17:02 2020/4/21
 */
@ApiModel(value = "PostBaseDto", description = "岗位基础信息")
public class PostBaseDto extends RequestDto{

    /**
    *  岗位名称
    */
    @ApiModelProperty(name = "name", value = "岗位名称")
    @NotEmpty(message = "岗位名称不能为空")
    @Size(message = "岗位名称长度为1~50",min = 1,max = 50)
    private String name;

    /**
    *  岗位编码
    */
    @ApiModelProperty(name = "code", value = "岗位编码")
    @NotEmpty(message = "岗位编码不能为空")
    @Size(message = "岗位编码长度为1~50",min = 1,max = 50)
    private String code;

    @ApiModelProperty(name = "status", value = "状态 [0禁用 1启用]",allowableValues = "0,1")
    private Integer status;

    /**
    *  组织编码
    */
    @ApiModelProperty(name = "orgCode", value = "组织编码")
    @NotEmpty(message = "组织编码不能为空")
    @Size(message = "组织编码长度为1~50",min = 1,max = 50)
    private String orgCode;

    public void setName(String name){
    this.name = name;
    }

    public String getName(){
    return this.name;
    }

    public void setCode(String code){
    this.code = code;
    }

    public String getCode(){
    return this.code;
    }

    public void setOrgCode(String orgCode){
    this.orgCode = orgCode;
    }

    public String getOrgCode(){
    return this.orgCode;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}