/*
 * @(#) OrganizationReqDto.java 1.1.0 2019-07-18
 * Copyright (c)  2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/***
 * 渠道请求类
 * @author diyun
 * @date 2019/7/18
 */
@ApiModel(value = "OrganizationReqDto", description = "渠道请求类")
public class OrganizationReqDto {

    /***
     * 渠道名称
     */
    @ApiModelProperty(value = "渠道名称")
    private String name;

    /***
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码")
    private String code;

    /***
     * 渠道类型
     */
    @ApiModelProperty(value = "渠道类型(1:线下 2:线上)")
    private String type;

    /***
     * 渠道类型
     */
    @ApiModelProperty(value = "渠道类型(1:线下 2:线上)")
    private List<String> types;

    @ApiModelProperty(value = "状态")
    private String status;

    private boolean pageFlag=true;

    public boolean isPageFlag() {
        return pageFlag;
    }

    public void setPageFlag(boolean pageFlag) {
        this.pageFlag = pageFlag;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.types = Lists.newArrayList(type);
        this.type = type;
    }

    public List<String> getTypes() {
        return types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }
}
