package com.dtyunxi.yundt.cube.bundle.org.center.user.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.base.BaseBatchDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.base.PostBaseDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.PostQueryReqDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.request.PostReqDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.EmployeePagerRespDto;
import com.dtyunxi.yundt.cube.bundle.org.center.user.api.dto.response.PostPagerRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 岗位服务接口
 * @see com.dtyunxi.yundt.cube.center.user.api.query.IPostExtQueryApi
 * @author 代码生成器
 */

@Api(tags = {"用户中心：岗位服务(v1)"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-bundle-org-center-user-api-query-IPostQueryApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v1/post"
)
public interface IPostQueryApi {

    /**
     * 根据id查询岗位
     *
     * @param id 岗位id
     * @return 岗位数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询岗位", notes = "根据id查询岗位")
    RestResponse<PostReqDto> queryById(@PathVariable("id") Long id);

    /**
     * 岗位分页数据
     *
     * @param postQueryReqDto 查询条件
     * @param pageNum         当前页
     * @param pageSize        页大小
     * @return 岗位分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "岗位分页数据", notes = "根据filter查询条件查询岗位数据，filter=PostReqDto")
    RestResponse<PageInfo<PostPagerRespDto>> queryByPage(@SpringQueryMap PostQueryReqDto postQueryReqDto,
                                                         @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                         @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 岗位下拉框列表
     *
     * @param baseBatchDto 岗位编码
     * @return 处理结果
     */
    @GetMapping("/comboBox")
    @ApiOperation(value = "岗位下拉框列表", notes = "岗位下拉框列表")

    @ApiImplicitParams({
            @ApiImplicitParam(value = "组织编码列表", name = "list")
    })
    RestResponse<List<PostBaseDto>> comboBox(@SpringQueryMap BaseBatchDto<String> baseBatchDto);

    /**
     * 岗位下员工列表
     *
     * @param code 岗位编码
     * @return 处理结果
     */
    @GetMapping("/{code}/employee/list")
    @ApiOperation(value = "岗位下员工列表", notes = "岗位下员工列表")
    RestResponse<List<EmployeePagerRespDto>> employeeList(@PathVariable("code") String code);
}
