/**
 * @(#) BaseDto.java 1.0 2018-09-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 员工-组织关系
 *
 * @author youyang
 * @since 2.5.20.0
 */
public class EmployeeOrgRelationReqDto extends BaseVo {
    /**
     * 员工id
     */
    @ApiModelProperty(value = "员工id,必填")
    @NotNull
    private Long employeeId;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "组织id", value = "组织id,必填")
    @NotNull
    private Long orgId;

    public Long getEmployeeId() {
        return employeeId;
    }

    public EmployeeOrgRelationReqDto setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    public Long getOrgId() {
        return orgId;
    }

    public EmployeeOrgRelationReqDto setOrgId(Long orgId) {
        this.orgId = orgId;
        return this;
    }
}
