package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

public class OrgSortReqDto extends BaseVo {
    @NotEmpty(message = "类型不可以为空")
    @ApiModelProperty(value = "类型可以为UP或DOWN", allowableValues = "UP,DOWN")
    private String type;

    @NotNull(message = "当前id不能为空")
    @ApiModelProperty(value = "当前id")
    private Long id;

    @NotEmpty(message = "所有兄弟节点id列表不能为空")
    @ApiModelProperty(value = "所有兄弟节点id列表")
    private List<Long> ids;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }
}
