/*
 * @(#) OrganizationReqDto.java 1.1.0 2019-07-18
 * Copyright (c)  2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/***
 * 渠道请求类
 * @author diyun
 * @date 2019/7/18
 */
@ApiModel(value = "ThridOrganizationReqDto", description = "组织查询请求")
public class ThridOrganizationReqDto extends BaseVo {

    /***
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    private String name;

    /***
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码")
    private String code;

    /***
     * 组织编码
     */
    @ApiModelProperty(value = "第三方组织编码")
    private String thridCode;

    @ApiModelProperty(value = "页码")
    private Integer pageNum = 1;

    @ApiModelProperty(value = "页数")
    private Integer pageSize = 10;

    @ApiModelProperty(value = "组织id")
    private Long orgId ;


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getThridCode() {
        return thridCode;
    }

    public void setThridCode(String thridCode) {
        this.thridCode = thridCode;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}
