package com.dtyunxi.yundt.cube.center.user.api.dto.response;

import com.dtyunxi.yundt.cube.center.user.api.dto.BaseDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgOrgDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.PostDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * EmployeeRespDto对象
 *
 * @author qiuzhi
 * @since 2020-09-25
 */
@ApiModel(value = "EmployeeRespDto", description = "Employee响应对象")
public class EmployeeRespDto extends BaseDto {
    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id")
    private Long id;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织ID")
    private Long orgGroupId;
    /**
     * 组织单元编码
     */
    @ApiModelProperty(value = "组织单元编码")
    private String orgIds;

    /**
     * 工号
     */
    @ApiModelProperty(value = "工号")
    private String employeeNo;
    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String name;
    /**
     * 英文名
     */
    @ApiModelProperty(value = "英文名")
    private String nameEn;
    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    private String phoneNum;
    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;
    /**
     * 岗位 (应该放到人员-部门关系)
     */
    @ApiModelProperty(value = "岗位 (应该放到人员-部门关系)")
    private String station;
    /**
     * 状态:1启用,2禁用
     */
    @ApiModelProperty(value = "状态:1启用,2禁用")
    private Integer status;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;
    /**
     * 设备ID
     */
    @ApiModelProperty(value = "设备ID")
    private String deviceId;
    /**
     * 业务唯一编码
     */
    @ApiModelProperty(value = "业务唯一编码")
    private String busicode;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称")
    private String nickName;
    /**
     * 关联账号id
     */
    @ApiModelProperty(value = "关联账号id")
    private Long userId;

    /**
     * 关联账号用户名
     */
    @ApiModelProperty(value = "关联账号用户名")
    private String userName;

    @ApiModelProperty
    private List<OrgOrgDto> orgDtoList;

    @ApiModelProperty
    private List<PostDto> postDtoList;
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOrgGroupId() {
        return orgGroupId;
    }

    public void setOrgGroupId(Long orgGroupId) {
        this.orgGroupId = orgGroupId;
    }

    public String getOrgIds() {
        return orgIds;
    }

    public void setOrgIds(String orgIds) {
        this.orgIds = orgIds;
    }

    public String getEmployeeNo() {
        return employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameEn() {
        return nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getStation() {
        return station;
    }

    public void setStation(String station) {
        this.station = station;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getBusicode() {
        return busicode;
    }

    public void setBusicode(String busicode) {
        this.busicode = busicode;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public List<OrgOrgDto> getOrgDtoList() {
        return orgDtoList;
    }

    public void setOrgDtoList(List<OrgOrgDto> orgDtoList) {
        this.orgDtoList = orgDtoList;
    }

    public List<PostDto> getPostDtoList() {
        return postDtoList;
    }

    public void setPostDtoList(List<PostDto> postDtoList) {
        this.postDtoList = postDtoList;
    }
}
